# $Id: picasso.tcl,v 1.29 94/02/14 14:54:47 mangin Exp $
# Tcl version: 7.1 (Tcl/Tk/XF)
# Tk version: 3.4

################################################################
####		       Init files                           ####
################################################################

if {$Debug} {
  puts -nonewline "Sourcing $PicassoLib/picrc.tcl..."
}

source "$PicassoLib/picbind.tcl"
source "$PicassoLib/picrc.tcl"

if {$Debug} {
  puts "Done"
}

if {[file readable "$env(HOME)/.picassorc"]} {
  if {$Debug} {
  puts "Sourcing $env(HOME)/.picassorc"
}
  source "$env(HOME)/.picassorc"
}

set bitmapPath "$PicassoLib/bitmaps $TmpDir $bitmapPath"

################################################################
####		     Symbolic names                         ####
################################################################

global {symbolicName}
set {symbolicName(ShowFonts)}      {.optionFr.fontFr.show.label}
set {symbolicName(alignVBar)}      {.optionFr.alignFr.f.vbarFr.frame40}
set {symbolicName(alignHBar)}      {.optionFr.alignFr.f.frame36.frame37}
set {symbolicName(optionFrame0)}   {.optionFr.styleFr}
set {symbolicName(optionFrame2)}   {.optionFr.gridFr}
set {symbolicName(optionFrame1)}   {.optionFr.alignFr}
set {symbolicName(optionFrame3)}   {.optionFr.fontFr}
set {symbolicName(optionFrame4)}   {.optionFr.latexFr}
set {symbolicName(optionFrame5)}   {.optionFr.imageFr}

################################################################
####		     Load libraries                         ####
################################################################

if {[catch {$env(TclLibDir)} TclLibDir]} {
  set TclLibDir {/u/gandalf/0/pastis/lib/tcl}
}

foreach file {
  picutil.tcl picbuild.tcl picconfig.tcl picmisc.tcl picproc.tcl picgeom.tcl \
    picobj.tcl pictext.tcl picimage.tcl piclatex.tcl
} {
  if {$Debug} {
    puts -nonewline "Sourcing $PicassoLib/$file..."
  }
  if {[catch {source $PicassoLib/$file} err]} {
    error "Error sourcing $file : $err"
  }
  if {$Debug} {
    puts "Done"
  }
}

################################################################
####	      initialize global variables                   ####
################################################################

global {xfWmSetPosition}
set {xfWmSetPosition} {}
global {xfWmSetSize}
set {xfWmSetSize} {.}
global {CurrentMode}
set CurrentMode SelectMode
global {minObjectSize}
set {minObjectSize} {3}
global {internalAliasList}
set {internalAliasList} {}
global xdragAnchor ydragAnchor
global xdragOrigin ydragOrigin dragDox dragDoy
global dragDistance

### global fsbox ####
global {fsBox}
set {fsBox(activeBackground)} {}
set {fsBox(activeForeground)} {}
set {fsBox(all)} {0}
set {fsBox(background)} {}
set {fsBox(button)} {0}
set {fsBox(extensions)} {0}
set {fsBox(font)} {}
set {fsBox(foreground)} {}
set {fsBox(internalPath)} {pwd}
set {fsBox(name)} {}
set {fsBox(path)} {pwd}
set {fsBox(pattern)} {*}
set {fsBox(scrollActiveForeground)} {}
set {fsBox(scrollBackground)} {}
set {fsBox(scrollForeground)} {}
set {fsBox(scrollSide)} {left}
set {fsBox(showPixmap)} {0}
global {fsBoxExtensions}
set {fsBoxExtensions} {0}

set vertAlignMode {none}
set horizAlignMode {none}

################################################################
####		     Build widgets                          ####
################################################################

ShowWindow.
update
waitCursor

# Scrollbar display management

lassign [.frame2.frame22.bottomSc get] tSize wSize x1 x2
if {$x2 - $x1 + 1 < $tSize} {
  pack .frame2.frame22.bottomSc \
    -before .frame2.frame22.canvas \
    -side bottom -fill x
}

update

lassign [.frame2.frame22.rightSc get] tSize wSize y1 y2
if {$y2 - $y1 + 1 < $tSize} {
  pack .frame2.frame22.rightSc \
    -before .frame2.frame22.canvas \
    -side right -fill y
}

##
##  Bindings
##

bind .frame2.frame22 <Configure> {
  update
  lassign [.frame2.frame22.bottomSc get] tSize wSize x1 x2
  if {$x2 - $x1 + 1 >= $tSize} {
    pack forget .frame2.frame22.bottomSc
  } else {
    pack .frame2.frame22.bottomSc \
      -before .frame2.frame22.canvas \
      -side bottom -fill x
  }
  update
  lassign [.frame2.frame22.rightSc get] tSize wSize y1 y2
  if {$y2 - $y1 + 1 >= $tSize} {
    pack forget .frame2.frame22.rightSc
  } else {
    pack .frame2.frame22.rightSc \
      -before .frame2.frame22.canvas \
      -side right -fill y
  }
}    
  
#  Redisplay options on resize  #
bind .optionFr <Configure> { optionViewHandle }

#  Load mouse bindings  #

mouseBind

####  Revision  ####
if {![catch {exec cat $PicassoLib/picrev} version]} {
  set date [lindex $version 1]
  set state [translit "_" "." [llast $version]]
  regsub {^V} $state {} state
  if {$state == "Exp"} {
    set state [lindex $version 0]
  }
  msg "Picasso Version $state  -  Help on mouse button 3"
  set PicassoVersion "$state $date"
} else {
  msg "Picasso - Help on mouse button 3"
  set PicassoVersion ""
}

# source auxiliary files
foreach file {picgrid picgroup picundo picio pichelp piccombine} {
  if {$Debug} {
    puts -nonewline "Sourcing $PicassoLib/$file.tcl..."
  }
  if {[catch {source $PicassoLib/$file.tcl} err]} {
    error "Error sourcing $file : $err"
  }
  if {$Debug} {
    puts "Done"
  }
}

# build canvas items .frame3.object
[st] create doval 11 11 35 59 \
  -tags {show}
[st] create dline 48 30 58 12 66 35 100 20 \
  -tags {show}

####  Build alignement item examples in st  ####
alignShowModeInit

####  Build option sets  ####
optionBuildText
optionBuildLatex
optionBuildImage

SetStyle lineColor black
SetStyle fillColor black
set currentFillColor black
SetStyle stipple   {}
SetStyle lineWidth     1
SetStyle arrow     none
SetStyle font $currentFont

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
  "[info procs XFShowHelp]" == ""} {
    source $env(XF_BIND_FILE)
  }

focus .
globalBindings
GridSetBindings

SetupEndHook

restoreCursor  
