/* fix.c

   Takes a postscript 2.0 file from standard input and hopefully
writes out a separate Postscript file for each page.  Assumes that the
header and trailer have already been extracted and saved as header.ps
and trailer.ps.

  Written Thursday May 20, 1993 by Joel F. Klein

*/

#include <stdio.h>
#include <strings.h>

#define WIDTH 4096

void main() {
   FILE *pf;                       /* page file */
   char done=0;
   char line[WIDTH+1];
   char *ending = "%%Trailer";
   char endinglength = strlen(ending);
   char filename[7+1];
   char opened=0;
   int pagenumber;

   while(!(done)){
      fgets(line, WIDTH, stdin);
      done = (!(strncasecmp(ending, line, endinglength))) ||  
(feof(stdin));
      if (!strncasecmp(line, "%%Page: ", 8)) {
	 if(opened)
	    fclose(pf);
	 sscanf(line+8, "%d", &pagenumber);
	 sprintf(filename, "p%d.ps", pagenumber);
	 strcpy(line, "%%Page: 1 1\n");      /* we have to renumber the  
page */
	 pf=fopen(filename, "w");
	 opened=!(0);
      }
      if((!done) && opened)
	 fprintf(pf, "%s", line);
   }
   fclose(pf);
}
