/*
 * linux/include/linux/double.h
 *
 * configuration for the double disk compression driver
 *
 * Copyright (C) 1994 Jean-Marc Verbavatz
 * January 1994
 */
#ifndef _DOUBLE_H_
#define _DOUBLE_H_

#include <sys/types.h>

#define DB_MAGIC		91262   /* An anniversary */
#define DB_MAXSZ		10240   /* Max size of clusters */
#define MAJOR_NR		19      /* Was unused */
#define MAX_DBLE		8	/* Max # of devices */
#define DB_NR_BH		40      /* # of disk buffer_heads */
#define DB_NR_VB		8	/* # of memory clusters */
#define DB_BMAP			1       /* For regular files */
/*
 *  IOCTL's
 */
#define DBLE_SET_FD		0x4400  /* for dbmount */
#define DBLE_CLR_FD		0x4401  /* for dbumount */
#define DBLE_SET_STATUS		0x4402  /* Change parameters */
#define DBLE_GET_STATUS		0x4403  /* Get parameters */
#define DBLE_FLUSH		0x4404	/* Flush buffers */
#define DBLE_DEBUG		0x4405  /* Change debug mode */
#define DBLE_STAT		0x4406  /* For performance study */

typedef u_char byte;    /* Both types for lzw.c */
typedef u_short code;

/* Block Allocation Table: each cluster is made of several physical
 * blocks (iblocks)
 */
struct BAT {
	short	type;           /* Compression mode */
	u_long  iblock;         /* physical blocks for cluster */
	/* other blocks are allocated dynamically (depending on ratio) */
};

/* Disk header created by mkdble */
extern struct db_header {
	u_long  Magic;
	u_long  iblocks, oblocks;       /* size of physical/virtual devices */
/* block number of bitmap, BAT and available blocks */
	u_long  addr_bitmap, addr_BAT, addr_blocks;
	u_short isize, osize;           /* size blocks/clusters in bytes */
	int     BATsize;                /* size of struct BAT */
	int     ratio;                  /* osize/isize */
	int	version;		/* Driver version */
	short   code;                   /* Default coding technique */
} db_header;

/* run-time structure for device */
struct dble_device { 
	u_long          iblocks, oblocks;
	u_long          addr_bitmap, addr_BAT, addr_blocks;
	long            bitmap_pos, BAT_pos; /* block currently loaded */
	struct inode    *db_inode;      /* inode of physical device */
	dev_t           db_device;      /* physical device */
	int             db_flags;       /* physical file mode */
	int             db_refcnt;      /* number of opens */
/* Memory buffers : */
	u_char          *bitmap, *BAT_block;
	long            *bmap0;
	u_short         isize, osize; 
	int             BATsize;
	int             ratio;
	u_short         code;                   /* Compression mode */
	u_char          bitmap_mod, BAT_mod;    /* uptodate ?? */
	u_char          db_number;
	u_char		db_mounted;
	u_char          debug;                  /* debug mode */
};

/* SET/GET status structure */
struct dble_info {
	dev_t           db_device;              /* GET status only */
	dev_t           db_rdevice;             /* GET status only */
	u_long          db_inode;               /* GET only */
	int             db_flags;               /* GET only */
	u_long          iblocks, oblocks;       /* GET only */
	u_short         isize, osize;           /* GET only */
	u_char  code;
};

struct db_stat {
	long	rphysical, rvirtual;
	long	wphysical, wvirtual;
	long	ihit, inohit;
	long	ohit, onohit;
	long	roblock, woblock;
} dble_stat;

extern struct buffer_head **db_bh;

extern u_long   get_newbit(struct dble_device *);
extern int WLZW(byte *, code *, int, int);
extern int RLZW(code *, byte *, int len);
extern void wlzrw2(byte *, int len, byte *, int *);
extern void rlzrw2(byte *, byte *, int);
extern void rpred(byte *, byte *, int);
extern void wpred(byte *, int, byte *, int *);
extern void wlzrw3a(byte *, int, byte *, int *);
extern void rlzrw3a(byte *, byte *, int);
extern void wlzrw3(byte *, int, byte *, int *);
extern void rlzrw3(byte *, byte *, int);
extern int db_rw_iblock(struct dble_device *, int, long, u_char *);
extern int read_oblock(struct dble_device *, long, u_char *);
extern int write_oblock(struct dble_device *, long, u_char *);
extern int db_rheader(struct dble_device *);
extern int db_flush(struct dble_device *);
#endif
