#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/fs.h>
#include <linux/hdreg.h>
#include <linux/errno.h>
#include <linux/proc_fs.h>
#include <linux/cdrom.h>

#include <asm/segment.h>

#include "../block/blk.h"
#include "scsi.h"
#include "scsi_ioctl.h"
#include "hosts.h"
#include "sd.h"

extern int revalidate_scsidisk(int, int);

char *scsiInd2Str( int index )
{	static char buf[10];
	if ((index&0xf) == 0)
		sprintf(buf, "sd%c", 'a'+((index>>4)&0xf));
	else
		sprintf(buf, "sd%c%x", 'a'+((index>>4)&0xf), index&0xf);
	return(buf);
} 

int sd_ioctl(struct inode * inode, struct file * file, unsigned int cmd, unsigned long arg)
{
	int dev = inode->i_rdev;
	int error;
	struct Scsi_Host * host;
	int diskinfo[4];
	struct hd_geometry *loc = (struct hd_geometry *) arg;

	if (PROC_DEV_NAME==cmd)
		if ((dev=PROC_DEV_MINOR(arg)) >= (NR_SD*16)) return -E2BIG;
		else if (rscsi_disks[dev>>4].device)
		{	strcpy((char*)arg, scsiInd2Str(dev));
			return 0;
		}
		else return -ENODEV;

	switch (cmd) {
         	case HDIO_REQ:   /* Return BIOS disk parameters */
			if (!loc)  return -EINVAL;
			error = verify_area(VERIFY_WRITE, loc, sizeof(*loc));
			if (error)
				return error;
			host = rscsi_disks[MINOR(dev) >> 4].device->host;
			diskinfo[0] = 0;
			diskinfo[1] = 0;
			diskinfo[2] = 0;
			diskinfo[3] = (int)rscsi_disks;
			if(host->hostt->bios_param != NULL)
			      host->hostt->bios_param(rscsi_disks[MINOR(dev) >> 4].capacity,
							  dev,
							  &diskinfo[0]);
			put_fs_byte(diskinfo[0],
				(char *) &loc->heads);
			put_fs_byte(diskinfo[1],
				(char *) &loc->sectors);
			put_fs_word(diskinfo[2],
				(short *) &loc->cylinders);
			put_fs_long(sd[MINOR(inode->i_rdev)].start_sect,
				(long *) &loc->start);
			return 0;
         	case BLKGETSIZE:   /* Return device size */
			if (!arg)  return -EINVAL;
			error = verify_area(VERIFY_WRITE, (long *) arg, sizeof(long));
			if (error)
				return error;
			put_fs_long(sd[MINOR(inode->i_rdev)].nr_sects,
				(long *) arg);
			return 0;
		case BLKFLSBUF:
			if(!suser())  return -EACCES;
			if(!inode->i_rdev) return -EINVAL;
 			fsync_dev(inode->i_rdev);
			invalidate_buffers(inode->i_rdev);
			return 0;

		case BLKRRPART: /* Re-read partition tables */
			return revalidate_scsidisk(dev, 1);
		case SCSI_IOCTL_REVALIDATE:
			return revalidate_scsidisk(dev, 0);
		case CDROMMEDIACHANGE:
			return check_scsidisk_media_change(dev,0);
		case SCSI_DISK_GET_DEVICE:
			return (int)(rscsi_disks[MINOR(dev)>>4].device);
		default:
			return scsi_ioctl(rscsi_disks[MINOR(dev) >> 4].device , cmd, (void *) arg);
	}
}
