/*
 *	hosts.c Copyright (C) 1992 Drew Eckhardt 
 *	mid to lowlevel SCSI driver interface by
 *		Drew Eckhardt 
 *
 *	<drew@colorado.edu>
 */


/*
 *	This file contains the medium level SCSI
 *	host interface initialization, as well as the scsi_hosts array of SCSI
 *	hosts currently present in the system. 
 */

#include <linux/config.h>
#include "../block/blk.h"
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/module.h>
#include "scsi.h"

#ifndef NULL 
#define NULL 0L
#endif

#define HOSTS_C

#include "hosts.h"

#ifdef CONFIG_SCSI_AHA152X
#include "aha152x.h"
#endif

#ifdef CONFIG_SCSI_AHA1542
#include "aha1542.h"
#endif

#ifdef CONFIG_SCSI_AHA1740
#include "aha1740.h"
#endif

#ifdef CONFIG_SCSI_FUTURE_DOMAIN
#include "fdomain.h"
#endif

#ifdef CONFIG_SCSI_GENERIC_NCR5380
#include "g_NCR5380.h"
#endif

#ifdef CONFIG_SCSI_PAS16
#include "pas16.h"
#endif

#ifdef CONFIG_SCSI_SEAGATE
#include "seagate.h"
#endif

#ifdef CONFIG_SCSI_T128
#include "t128.h"
#endif

#ifdef CONFIG_SCSI_ULTRASTOR
#include "ultrastor.h"
#endif

#ifdef CONFIG_SCSI_7000FASST
#include "wd7000.h"
#endif

#ifdef CONFIG_SCSI_DEBUG
#include "scsi_debug.h"
#endif

/*
static const char RCSid[] = "$Header: /usr/src/linux/kernel/blk_drv/scsi/RCS/hosts.c,v 1.3 1993/09/24 12:21:00 drew Exp drew $";
*/

/*
 *	The scsi host entries should be in the order you wish the 
 *	cards to be detected.  A driver may appear more than once IFF
 *	it can deal with being detected (and therefore initialized) 
 *	with more than one simulatenous host number, can handle being
 *	rentrant, etc.
 *
 *	They may appear in any order, as each SCSI host  is told which host number it is
 *	during detection.
 */

/* This is a placeholder for controllers that are not configured into
   the system - we do this to ensure that the controller numbering is
   always consistent, no matter how the kernel is configured. */

#define NO_CONTROLLER {NULL, NULL, NULL, NULL, NULL, NULL, NULL, \
	        NULL, NULL, 0, 0, 0, 0, 0, 0}

/*
 *	When figure is run, we don't want to link to any object code.  Since 
 *	the macro for each host will contain function pointers, we cannot 
 *	use it and instead must use a "blank" that does no such 
 *	idiocy.
 */

Scsi_Host_Template scsi_hosts[MAX_TEMPLATES] =
	{
#if CONFIG_SCSI_AHA152X
	AHA152X,
#endif
#if CONFIG_SCSI_AHA1542
	AHA1542,
#endif
#if CONFIG_SCSI_AHA1740
	AHA1740,
#endif
#if CONFIG_SCSI_FUTURE_DOMAIN
	FDOMAIN_16X0,
#endif
#if CONFIG_SCSI_GENERIC_NCR5380
        GENERIC_NCR5380,
#endif
#if CONFIG_SCSI_PAS16
	MV_PAS16,
#endif
#if CONFIG_SCSI_SEAGATE
	SEAGATE_ST0X,
#endif
#if CONFIG_SCSI_T128
        TRANTOR_T128,
#endif
#if CONFIG_SCSI_ULTRASTOR
	ULTRASTOR_14F,
#endif
#if CONFIG_SCSI_7000FASST
	WD7000,
#endif
#if CONFIG_SCSI_DEBUG
	SCSI_DEBUG,
#endif
	NO_CONTROLLER
	};

#define MAX_SCSI_HOSTS (sizeof(scsi_hosts) / sizeof(Scsi_Host_Template))

/*
 *	Our semaphores and timeout counters, where size depends on MAX_SCSI_HOSTS here. 
 */

struct Scsi_Host * scsi_hostlist = NULL;

static unsigned long scsi_init_memory_start = 0;

int max_scsi_hosts = 0;
static int next_host = 0;

void
scsi_unregister(struct Scsi_Host * sh, int j){
	struct Scsi_Host * shpnt;

	if (scsi_init_memory_start)
		if(((unsigned int) sh) + sizeof(struct Scsi_Host) + j != scsi_init_memory_start)
			panic("Unable to unregister scsi host");
	if(scsi_hostlist == sh)
		scsi_hostlist = NULL;
	else {
		shpnt = scsi_hostlist;
		while(shpnt->next != sh) shpnt = shpnt->next;
		shpnt->next = shpnt->next->next;

	};
	next_host--;
	dfree(sh, sizeof(struct Scsi_Host)+j, &scsi_init_memory_start);
}

/* We call this when we come across a new host adapter. We only do this
   once we are 100% sure that we want to use this host adapter -  it is a
   pain to reverse this, so we try and avoid it */

struct Scsi_Host * scsi_register(int i, int j){
	struct Scsi_Host * retval, *shpnt;
	retval = (struct Scsi_Host*) dmalloc( sizeof(struct Scsi_Host) + j,
		&scsi_init_memory_start);
	retval->host_busy = 0;
	retval->host_no = next_host++;
	retval->host_queue = NULL;	
	retval->host_wait = NULL;	
	retval->last_reset = 0;	
	retval->hostt = &scsi_hosts[i];	
	retval->next = NULL;
#ifdef DEBUG
	printk("Register %x %x: %d %d\n", retval, retval->hostt, i, j);
#endif

	/* The next three are the default values which can be overridden
	   if need be */
	retval->this_id = scsi_hosts[i].this_id;
	retval->sg_tablesize = scsi_hosts[i].sg_tablesize;
	retval->unchecked_isa_dma = scsi_hosts[i].unchecked_isa_dma;

	if(!scsi_hostlist)
		scsi_hostlist = retval;
	else
	{
		shpnt = scsi_hostlist;
		while(shpnt->next) shpnt = shpnt->next;
		shpnt->next = retval;
	}

	return retval;
}

void scsi_template_unregister( int num)
{
	if ((num<MAX_TEMPLATES) && (num>=0))
		scsi_hosts[num].command=0;
}

static int scsi_do_detect( int i )
{
	int j, count=max_scsi_hosts, pcount;

	pcount = next_host;
	if ((scsi_hosts[i].detect) && 
	    (scsi_hosts[i].present = 
	     scsi_hosts[i].detect(i)))
	{		
		scsi_hosts[i].detect=0;
		if(pcount == next_host) {
			if(scsi_hosts[i].present > 1)
			{	printk("Failure to register low-level scsi driver");
				return(-2);
			}
			/* The low-level driver failed to register a driver.  We
			   can do this now. */
			scsi_register(i,0);
		}
		for(j = 0; j < scsi_hosts[i].present; j++)
			printk ("scsi%d : %s\n",
				count++, scsi_hosts[i].name);
	}
	else
	{	scsi_hosts[i].detect=0;
		return(-1);
	}
	max_scsi_hosts=count;
	return 0;
}


int scsi_template_register( Scsi_Host_Template * template)
{
	int i;

	for (i=0; i<MAX_TEMPLATES; i++)
		if (!scsi_hosts[i].command)
		{	scsi_hosts[i] = *template;
			break;
		}
	if (i>=MAX_TEMPLATES)
	{	printk("scsi template table full\n");
		return(-1);
	}
	return scsi_do_detect(i);
}

unsigned int
scsi_init(unsigned long memory_start,unsigned long memory_end)
{
	static int called = 0;
	int i;

	if(called) return memory_start;

	scsi_init_memory_start = memory_start;
	called = 1;	
	for (i = 0; i < MAX_SCSI_HOSTS; ++i)
		scsi_do_detect(i);
	printk ("scsi : %d hosts.\n", max_scsi_hosts);
	
	return scsi_init_memory_start;
}
