/* Author : Ross Williams.                                                    */
/* Date   : December 1989.                                                    */
/* This header file and the C functions have been modified in order to        */
/* include them in the DouBle device driver by Jean-Marc Verbavatz, Feb 1994. */
/*                                                                            */
/* This header file defines the interface to a set of lzrw functions          */
/* each member of which implements a particular data compression              */
/* algorithm.                                                                 */
/*                                                                            */
/* Normally in C programming, for each .H file, there is a corresponding .C   */
/* file that implements the functions promised in the .H file.                */
/* Here, there are many .C files corresponding to this header file.           */
/* Each comforming implementation file contains a single function             */
/* called that implements a single data compression                           */
/* algorithm that conforms with the interface specified in this header file.  */
/*                                                                            */
/******************************************************************************/
/* See the formal C definition later for a description of the parameters.     */
/*                                                                            */
/* Although compression algorithms usually compress data, there will always   */
/* be data that a given compressor will expand (this can be proven).          */
/*                                                                            */
/* Unfortunately, in general, the only way to tell if an algorithm will       */
/* expand a particular block of data is to run the algorithm on the data.     */
/* If the algorithm does not continuously monitor how many output bytes it    */
/* has written, it might write an output block far larger than the input      */
/* block before realizing that it has done so.                                */
/* On the other hand, continuous checks on output length are inefficient.     */
/*                                                                            */
/* The problem does not arise for decompression.                              */
/*                                                                            */
/******************************************************************************/
/* Macro definitions and types that are likely to change between computers.   */
/*                                                                            */
#ifndef DONE_PORT       /* Only do this if not previously done.               */
   #ifndef TRUE
	#define TRUE 1
	#define FALSE 0
   #endif
   #ifndef UBYTE
      #define UBYTE unsigned char      /* Unsigned byte                       */
      #define UWORD unsigned int       /* Unsigned word (2 bytes)             */
      #define ULONG unsigned long      /* Unsigned word (4 bytes)             */
      #define BOOL  unsigned char      /* Boolean                             */
      #define REAL double              /* USed for floating point stuff.      */
  #endif

   #define DONE_PORT                   /* Don't do all this again.            */
   #define MALLOC_FAIL NULL            /* Failure status from malloc()        */
   #define LOCAL static                /* For non-exported routines.          */
   #define EXPORT                      /* Signals exported function.          */
   #define then                        /* Useful for aligning ifs.            */

#endif


ULONG  rlzrw2(        /* function for decompression algorithm. */
UBYTE   *src_adr,      /* Address of input  data.                             */
UBYTE   *dst_adr,      /* Address of output data.                             */
ULONG    dst_len       /* Length  of output data.                             */
);

void  wlzrw2(        /* function for compression algorithm. */
UBYTE   *src_adr,      /* Address of input  data.                             */
ULONG    src_len,      /* Length  of input  data.                             */
UBYTE   *dst_adr,      /* Address of output data.                             */
ULONG *p_dst_len       /* Pointer to a longword where routine will write:     */
                       /*    Length of output data. */
);

ULONG  rlzrw3(        /* function for decompression algorithm. */
UBYTE   *src_adr,      /* Address of input  data.                             */
UBYTE   *dst_adr,      /* Address of output data.                             */
ULONG    dst_len       /* Length  of output data.                             */
);

void  wlzrw3(        /* function for compression algorithm. */
UBYTE   *src_adr,      /* Address of input  data.                             */
ULONG    src_len,      /* Length  of input  data.                             */
UBYTE   *dst_adr,      /* Address of output data.                             */
ULONG *p_dst_len       /* Pointer to a longword where routine will write:     */
                       /*    Length of output data. */
);
/*
 * NOTE: lzrw3 is not implemented in the DouBle driver version 0.2
 */

ULONG  rlzrw3a(        /* function for decompression algorithm. */
UBYTE   *src_adr,      /* Address of input  data.                             */
UBYTE   *dst_adr,      /* Address of output data.                             */
ULONG    dst_len       /* Length  of output data.                             */
);

void  wlzrw3a(        /* function for compression algorithm. */
UBYTE   *src_adr,      /* Address of input  data.                             */
ULONG    src_len,      /* Length  of input  data.                             */
UBYTE   *dst_adr,      /* Address of output data.                             */
ULONG *p_dst_len       /* Pointer to a longword where routine will write:     */
                       /*    Length of output data. */
);

/******************************************************************************/
/*                             End of LZRW.H                                  */
/******************************************************************************/

