'\"
'\" Copyright 1993-1994 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Bgexec command created by George Howlett.
'\"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS blt_bgexec cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
blt_bgexec \- Run Unix commands in the background 
.SH SYNOPSIS
\fBblt_bgexec \fR?\fIswitches\fR? \fIvarname arg\fR ?\fIarg\fR ...?
.sp
\fBblt_bgexec \fR?\fIswitches\fR? \fIarg\fR ?\fIarg\fR ...?
.BE
.SH DESCRIPTION
.PP
This command executes one or more Unix
commands in the background as subprocesses, storing the output 
of the last subprocess in the variable \fIvarname\fR after it has completed.  
This allows Unix commands to be run in the background, while still collecting 
their output, to notify the Tcl interpreter when they terminate.
.PP
This command, used in conjunction with \fBtkwait\fR, is particularly useful 
for handling Tk events while waiting for a running UNIX program to finish.
.DS
\fBblt_bgexec \fIvarname command args\fR
.br
\fBtkwait variable\fR \fIvarname\fR
.DE
.PP
This allows expose events can be handled while waiting for one or more 
Unix commands to finish.  The program may also continue, possibly 
animating a busy 
cursor or icon, while waiting for the variable \fIvarname\fR to be set.
After all the subprocesses have completed, \fBblt_bgexec\fR will 
set \fIvarname\fR, triggering \fBtkwait\fR to return.
\fIVarname\fR will contain the output of the last subprocess.
.PP
If the initial arguments to \fBblt_bgexec\fR start with \fB\-\fR then
they are treated as command-line switches and are not part
of the variable name or pipeline specification.  The following 
switches are currently supported:
.TP 13
\fB\-keepnewline
Retains a trailing newline in the pipeline's output.
Normally a trailing newline will be deleted.  
.TP 13
\fB\-errorvar
Name of a variable to be set with the contents of standard error 
after the last subprocess has completed.
.TP 13
\fB\-outputvar
Name of a variable to be set with the contents of standard output
after the last subprocess has completed.  If \fIvarname\fR is not
specified, this switch must be set.
.TP 13
\fB\-updatevar
Name of a variable which be appended with the standard output of the 
last subprocess.  This variable is updated as data becomes available
(i.e. read from the pipeline), unlike \fIvarname\fR which is set \fBafter\fR
the last subprocess has completed.
.TP 13
\fB\-\|\-\fR
Marks the end of switches.  The argument following this one will
be treated as the output variable name \fIvarName\fR or the start of 
Unix command even if it starts with 
a \fB\-.
.PP
\fICommand\fR and \fIargs\fR may be in any form accepted by the Tcl \fBexec\fR
command.  However, if output is redirected, the variable \fIvarname\fR will be
updated (at the next idle point) to the empty string.  The command will 
still continue to completion.
.PP
You can also terminate to subprocesses by setting \fIvarname\fR before the 
last command has completed.  The remaining subprocesses will be killed.
.SH BUGS
Care must be taken to prevent an application from preempting itself
by further user-interactions (such as button clicks).  The \fBblt_busy\fR
command is very useful in these situations (see the \fBblt_busy\fR manual).
.PP
Unix commands (like compress) which close standard output prematurely
confuse \fBblt_bgexec\fR.  The workaround is to invoke the command through 
a Unix shell.
.DS 
\fCblt_bgexec output /bin/sh -c "compress $file"\fR
.DE
.SH KEYWORDS
exec, background
