/* SVGAlib, Copyright 1993 Harm Hanemaayer */
/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen */
/* Definitions shared by library modules */

extern int debug_regs;

static inline void port_out( int value, int port )
{
	__asm__ volatile ("outb %0,%1"
	: : "a" ((unsigned char)value), "d" ((unsigned short)port));
}

static inline void port_outw( int value, int port ) {
	__asm__ volatile("outw %0,%1"
	: : "a" ((unsigned short)value), "d" ((unsigned short)port));
}

static inline int port_in( int port )
{
	unsigned char value;
	__asm__ volatile ("inb %1,%0"
		: "=a" (value)
		: "d" ((unsigned short)port));
	return value;
}

#define inb port_in
#define outb(port, value) port_out(value, port)
#define outw(port, value) port_outw(value, port)


/* VGA index register ports */
#define CRT_IC  0x3D4   /* CRT Controller Index - color emulation */
#define CRT_IM  0x3B4   /* CRT Controller Index - mono emulation */
#define ATT_IW  0x3C0   /* Attribute Controller Index & Data Write Register */
#define GRA_I   0x3CE   /* Graphics Controller Index */
#define SEQ_I   0x3C4   /* Sequencer Index */
#define PEL_IW  0x3C8   /* PEL Write Index */
#define PEL_IR  0x3C7   /* PEL Read Index */

/* VGA data register ports */
#define CRT_DC  0x3D5   /* CRT Controller Data Register - color emulation */
#define CRT_DM  0x3B5   /* CRT Controller Data Register - mono emulation */
#define ATT_R   0x3C1   /* Attribute Controller Data Read Register */
#define GRA_D   0x3CF   /* Graphics Controller Data Register */
#define SEQ_D   0x3C5   /* Sequencer Data Register */
#define MIS_R   0x3CC   /* Misc Output Read Register */
#define MIS_W   0x3C2   /* Misc Output Write Register */
#define IS1_RC  0x3DA   /* Input Status Register 1 - color emulation */
#define IS1_RM  0x3BA   /* Input Status Register 1 - mono emulation */
#define PEL_D   0x3C9   /* PEL Data Register */

/* standard VGA indexes max counts */
#define CRT_C   24      /* 24 CRT Controller Registers */
#define ATT_C   21      /* 21 Attribute Controller Registers */
#define GRA_C   9       /* 9  Graphics Controller Registers */
#define SEQ_C   5       /* 5  Sequencer Registers */
#define MIS_C   1       /* 1  Misc Output Register */

/* VGA registers saving indexes */
#define CRT     0               /* CRT Controller Registers start */
#define ATT     CRT+CRT_C       /* Attribute Controller Registers start */
#define GRA     ATT+ATT_C       /* Graphics Controller Registers start */
#define SEQ     GRA+GRA_C       /* Sequencer Registers */
#define MIS     SEQ+SEQ_C       /* General Registers */
#define EXT     MIS+MIS_C       /* SVGA Extended Registers */

/* Chipset specific functions */

extern int (**chipsetfunctions)();
extern int (**chipsetfunctionslist[])();

#define chipset_saveregs chipsetfunctions[CHIPSET_SAVEREGS]
#define chipset_setregs chipsetfunctions[CHIPSET_SETREGS]
#define chipset_unlock chipsetfunctions[CHIPSET_UNLOCK]
#define chipset_test chipsetfunctions[CHIPSET_TEST]
#define chipset_setpage chipsetfunctions[CHIPSET_SETPAGE]
#define chipset_setmode chipsetfunctions[CHIPSET_SETMODE]
#define chipset_modeavailable chipsetfunctions[CHIPSET_MODEAVAILABLE]
#define chipset_getmodeinfo chipsetfunctions[CHIPSET_GETMODEINFO]

/* Chipset drivers */
/* vgadrv	Standard VGA (also used by drivers below) */
/* et4000	Tseng ET4000 (from original vgalib) */
/* cirrus	Cirrus Logic GD542x */
/* tvga8900     Trident TVGA 8900/9000 (derived from tvgalib) */
/* oak		Oak Technologies 037/067/077 */


/* Graphics information */
struct info {
	int xdim;
	int ydim;
	int colors;
	int xbytes;
};

extern int vga_setregs(unsigned char *);
extern int __vga_saveregs(unsigned char *);
extern int __vga_get_perm(void);

extern int __vga_cur_mode;
extern int __vga_cur_color;
extern struct info __vga_cur_info;
extern struct info __vga_infotable[];

#define STDVGAMODE(mode) (mode < G640x480x256 || mode == G720x350x16 || \
	mode == G720x480x16)
#define SVGAMODE(mode) (!(STDVGAMODE(mode)))
