
#include <stdlib.h>
#include <stdio.h>
#include <vga.h>
#include <vgagl.h>


int VGAMODE;
int VIRTUAL;

GraphicsContext backscreen;
GraphicsContext physicalscreen;


void test() {
	int i, j;
	char *bitmap;
	
	if (VIRTUAL)
		gl_setcontext(&backscreen);

	gl_clearscreen(0);
	for (i = 0; i < 5; i++) {
		gl_clearscreen(0);
		for (j = 0; j < 20000; j++)
			gl_setpixel(random() % WIDTH, random() % HEIGHT,
				random() % COLORS);
	}

	if (VIRTUAL)
		gl_copyscreen(&physicalscreen);

	gl_clearscreen(0);
	for (i = 0; i < 2000; i++) {
		int x, y;
		x = random() % (WIDTH - 1);
		y = random() % (HEIGHT - 1);
		gl_fillbox(x, y, random() % (WIDTH - x), random()
			% (HEIGHT - y),	random() % COLORS);
	}

	if (VIRTUAL)
		gl_copyscreen(&physicalscreen);

	gl_clearscreen(0);
	for (i = 0; i < 4000; i++)
		gl_line(random() % WIDTH, random() % HEIGHT,
			random() % WIDTH, random() % HEIGHT,
			random() % COLORS);

	if (VIRTUAL)
		gl_copyscreen(&physicalscreen);

	/* Create bitmap */
	bitmap = malloc(100 * 100 * BYTESPERPIXEL);
	for (i = 0; i < 100; i++)
		for (j = 0; j < 100 * BYTESPERPIXEL; j++)
			bitmap[i * 100 * BYTESPERPIXEL + j] = i * 2;

	gl_clearscreen(0);
	for (i = 0; i < 2000; i++) {
		int x, y;
		x = random() % (WIDTH - 100 + 1);
		y = random() % (HEIGHT - 100 + 1);
		gl_putbox(x, y, 100, 100, bitmap);
	}
	free(bitmap);

	if (VIRTUAL)
		gl_copyscreen(&physicalscreen);
}

void main() {
	VGAMODE = vga_getdefaultmode();
	if (VGAMODE == -1)
		VGAMODE = G320x200x256;
	
	if (!vga_hasmode(VGAMODE)) {
		printf("Mode not available.\n");
		exit(-1);
	}

	VIRTUAL = 0;

	if (VIRTUAL) {
		gl_setcontextvgavirtual(VGAMODE);
		gl_getcontext(&backscreen);
	}

	vga_setmode(VGAMODE);
	gl_setcontextvga(VGAMODE);
	gl_getcontext(&physicalscreen);

	test();
	
	gl_clearscreen(0);
	gl_setclippingwindow(WIDTH / 4, HEIGHT / 4, WIDTH - WIDTH / 4 - 1,
		HEIGHT - HEIGHT / 4 - 1);

	test();

	getchar();

	if (VIRTUAL)
		gl_freecontext(&backscreen);
	vga_setmode(TEXT);
	exit(0);
}
