
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <vga.h> 
#include <vgagl.h>


int VGAMODE;
GraphicsContext physicalscreen;
GraphicsContext backscreen;


void screen1() {
	int x, y;
	for (y = 0; y < HEIGHT; y++)
		for (x = 0; x < WIDTH; x++)
			switch (BYTESPERPIXEL) {
			case 1 :
				/* limited RGB palette in 256-color modes */
			case 2 :
				/* some color information is not used in */
				/* 15-bit color modes */
			case 3 :
				gl_setpixelrgb(x, y,
					x * 256 / WIDTH, 
					255 - x * 256 / WIDTH,
					y * 256 / HEIGHT);
				break;
			}
}


/* IF YOU PUT THIS LINE IN configure(), GCC 2.4.3 PRODUCES *BAD* CODE! */
/* (or the library messes thing up...) */
int allowed[GLASTMODE];

void configure() {

	for (;;) {
		int i;
		int m;
		for (i = G320x200x256; i <= GLASTMODE; i++) {
			allowed[i] = 0;
			if (vga_hasmode(i))
			if (vga_getmodeinfo(i)->bytesperpixel >= 1) {
				printf("%2d  %s\n", i, vga_getmodename(i));
				allowed[i] = 1;
			}
		}

		printf("\nWhich mode? ");
		scanf("%d", &m);
		getchar();
		printf("\n");
		if (m >= G320x200x256 && m <= GLASTMODE
		&& allowed[m]) {
			VGAMODE = m;
			break;
		}
	}

	vga_setmode(VGAMODE);
	gl_setcontextvga(VGAMODE);
	gl_getcontext(&physicalscreen);

/*	if (BYTESPERPIXEL == 1)
		setcustompalette(); */
}


void blit() {
	gl_clearscreen(0x86);
	vga_imageblt(backscreen.vbuf, 0, WIDTH - 128, HEIGHT - 128,
		WIDTH * BYTESPERPIXEL);
/*	vga_bitblt(0, 100 * WIDTH * BYTESPERPIXEL, 50, 50, WIDTH * BYTESPERPIXEL);
	vga_fillblt(100 * BYTESPERPIXEL, 50, 50, WIDTH * BYTESPERPIXEL, 0x86);
*/
}


void speed() {
	int i;
	int start_clock;
	int finish_clock;
	int diff_clock;

	if (VGAMODE != G320x200x256)
		vga_setpage(0);

	start_clock = clock();

	for (i = 0; i < 500; i++)
		memset(graph_mem, i & 255, 65536);
/*		memcpy(graph_mem, backscreen, 65536); */
/*		vga_imageblt(backscreen, 0, 256, 256, WIDTH); */
/*		vga_bitblt(WIDTH * BYTESPERPIXEL * 256 + (i & 63), 0, 256,
			256, WIDTH * BYTESPERPIXEL); */
/*		vga_fillblt(0, 256, 256, WIDTH * BYTESPERPIXEL, i & 255); */

	finish_clock = clock();

	diff_clock = finish_clock - start_clock;
	printf("Timing: %3d.%1ds, %dK/s\n", diff_clock / 100, 
		(diff_clock % 100) / 10, 3200000 / diff_clock);
}


main()
{
	printf("This is a video memory speed tester. Note that the first "
		"screen doesn't test\nanything (nor does the 3 second pause "
		"that follows).\n\n");

	configure();

	if (COLORS == 256)
		gl_setrgbpalette();	/* set RGB palette */

	screen1();
	sleep(2);

	speed();

   	vga_setmode(TEXT);
   	exit(0);
}
