/*
 * countblocks.c	- Computes blocks count on a device
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file is based on an mkefs extension written by Adam Richter
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from mke2fs
 */

#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include "e2fsprogs.h"

static long valid_offset (int fd, int offset)
{
	char ch;

	if (lseek (fd, offset, 0) < 0)
		return 0;
	if (read (fd, &ch, 1) < 1)
		return 0;
	return 1;
}

long count_blocks (const char * filename)
{
	unsigned long high, low;
	int fd;

	if ((fd = open (filename, O_RDONLY)) < 0)
	{
		perror (filename);
		exit (1);
	}
	low = 0;

	for (high = 1; valid_offset (fd, high); high *= 2)
		low = high;
	while (low < high - 1)
	{
		const int mid = (low + high) / 2;

		if (valid_offset (fd, mid))
			low = mid;
		else
			high = mid;
	}
	valid_offset (fd, 0);
	close (fd);
	return (low + 1) / 1024;
}
