/*
 * ckfunc.h		- Prototypes of global functions used by e2fsck
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from e2fsck
 */

/* badblocks1.c */
extern void	test_blocks	(int);
extern void	read_bad_blocks	(int);
extern void	read_bad_blocks_from_file
				(const char *);
extern void	display_bad_blocks
				(void);

/* cache.c */
extern void	cache_flush	(int);
extern void	read_inode	(int, unsigned long, struct ext2_inode *);
extern void	write_inode	(int, unsigned long, struct ext2_inode *);

/* e2fsck.c */
extern volatile void
		die		(const char *, int);
extern void	print_current_name
				(void);
extern int	ask		(const char *, int);
extern int	check_block_nr	(unsigned long *);

extern unsigned short
		check_file	(struct ext2_inode *, int *, unsigned int);

/* inode.c */
extern struct ext2_inode
		get_inode	(int, unsigned long);
extern int	add_block	(int, unsigned long *, int);
extern int	add_block_ind	(int, unsigned long *, int);
extern int	add_block_dind	(int, unsigned long *, int);
extern int	add_block_tind	(int, unsigned long *, int);
extern int	mapped_read_block
				(int, struct ext2_inode *, unsigned long,
				 char *);

/* lpf.c */
extern void	set_lost_dir_ent
				(int, unsigned long, int);
extern void	check_connectivity
				(int);

/* rdwr.c */
extern int	read_block	(int, unsigned long *, char *);
extern void	write_block	(int, unsigned long, char *);

/* tables1.c */
extern void	write_super_block
				(int);
extern void	write_tables	(int);
extern int	read_tables	(int, long);

/* truncate.c */
extern void	truncate_file	(int, struct ext2_inode *);
