PROCEDURE Install
*----------------------------------------------------------------------------
* NAME
*   Install - Installs the dBASE IV Productivity Pack
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
  SET TALK OFF
  SET ECHO OFF
  SET COLOR OF NORMAL      TO w+/bg
  SET COLOR OF HIGHLIGHT   TO rg+/w
  SET COLOR OF MESSAGES    TO w/b
  SET COLOR OF TITLES      TO n/bg
  SET COLOR OF BOX         TO W+/b
  SET COLOR OF INFORMATION TO bg+/b
  SET COLOR OF FIELDS      TO W+/n
  SET STATUS OFF
  SET BORDER TO NONE

  DEFINE WINDOW title FROM 8,16 TO 11, 62 COLOR n/w
  ACTIVATE WINDOW title
  @ 0,0 SAY "" COLOR n/w 
  @ 0,46 SAY "" COLOR w+/w 
  @ 1,0 SAY "" COLOR n/w 
  @ 1,3 SAY "Welcome to the dBASE IV Productivity Pack" 
  @ 1,46 SAY "" COLOR w+/w 
  @ 2,0 SAY "" COLOR n/w 
  @ 2,12 SAY "for dBASE IV version 2.0" 
  @ 2,46 SAY "" COLOR w+/w 
  @ 3,0 SAY "" COLOR n/w 
  @ 3,1 SAY "" COLOR w+/w 
  SAVE SCREEN TO title
  RELEASE WINDOW title
  RESTORE SCREEN FROM title

  SET EXACT ON
  SET EXCLUSIVE OFF
  SET SAFETY OFF

  cSampDir = "DB4PPSAM"
  cSrcDir  = "DB4PPSRC"

  cSEAHome = "DB4PP.EXE"                && Self-Extracting Archive for HOME()
  cSEASamp = "DB4PPSAM.EXE"             && Self-Extracting Archive for Samples
  cSEASrc  = "DB4PPSRC.EXE"             && Self-Extracting Archive for Source
  cSEAEd   = "DB4PPED.EXE"              && Self-Extracting Archive for dBEdit
  cSEAdC   = "DB4PPDC.EXE"              && Self-Extracting Archive for BdCDrive

  *------------------------------------------------------
  *-- Check the version of dBASE before going any further
  *------------------------------------------------------
  IF .NOT. ( "2.0" $ VERSION() )
    WAIT "This is not dBASE IV version 2.0!"
    QUIT WITH 1
  ENDIF

  cInstDrv = SET( "DIRECTORY" )
  IF RIGHT( cInstDrv, 1 ) <> "\"
    cInstDrv = cInstDrv + "\"
  ENDIF
  cSEAHome = cInstDrv + "DB4PP.EXE"
  cSEASamp = cInstDrv + "DB4PPSAM.EXE"
  cSEASrc  = cInstDrv + "DB4PPSRC.EXE"
  cSEAEd   = cInstDrv + cSEAEd
  cSEAdC   = cInstDrv + cSEAdC

  cHomePath = HOME()
  cHomeDir = LEFT( cHomePath, LEN( cHomePath ) - 1 )
  SET DIRECTORY TO &cHomeDir

  *-------------------------------------------
  *-- See if you have rights to this directory
  *-------------------------------------------
  ON ERROR lh = 0
  lh = 0
  lh = FCREATE( "CHECKIT.OUT" )
  IF lh = 0
    WAIT "You do not have rights to the dBASE home directory!"
    QUIT WITH 1
  ENDIF
  lOk = FCLOSE( lh )
  ERASE CHECKIT.OUT

  *--------------------------------------------------------
  *-- Create the source and sample subdirectories as needed
  *--------------------------------------------------------
  lh = 0
  lh = FCREATE( cSampDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    ! MD &cSampDir >nul
  ELSE
    lOk = FCLOSE( lh )
    ERASE ( cSampDir + "\" + "CHECKIT.OUT" )
  ENDIF

  lh = 0
  lh = FCREATE( cSrcDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    ! MD &cSrcDir >nul
  ELSE
    lOk = FCLOSE( lh )
    ERASE ( cSrcDir + "\" + "CHECKIT.OUT" )
  ENDIF

  lh = 0
  lh = FCREATE( cSampDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    WAIT "Cannot create samples directory: " + cHomePath + cSampDir
    QUIT WITH 1
  ENDIF
  lOk = FCLOSE( lh )
  ERASE ( cSampDir + "\" + "CHECKIT.OUT" )
  lh = 0
  lh = FCREATE( cSrcDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    WAIT "Cannot create source directory: " + cHomePath + cSrcDir
    QUIT WITH 1
  ENDIF
  lOk = FCLOSE( lh )
  ERASE ( cSrcDir + "\" + "CHECKIT.OUT" )

  *-------------------------
  *-- Start extracting files
  *-------------------------
  x = run( cSEAHome + " -o", .t. )
  x = run( cSEAEd + " -o", .t. )
  x = run( cSEAdC + " -o", .t. )

  SET DIRECTORY TO &cSampDir
  x = run( cSEASamp + " -o", .t. )

  SET DIRECTORY TO &cHomeDir
  SET DIRECTORY TO &cSrcDir
  x = run( cSEASrc + " -o", .t. )

  SET DIRECTORY TO &cHomeDir
  COPY FILE &cSrcDir.\readme. TO readme.dbb

  *-----------------------------------
  *-- Make the CONFIG.DBB startup file
  *-----------------------------------
  SET CONSOLE OFF
  SET ALTERNATE TO config.dbb
  SET ALTERNATE ON

TEXT
*
*       dBASE IV Productivity Pack Configuration File
ENDTEXT

? '*    Created on:', DATE()

TEXT
*
COLOR OF NORMAL      = w+/bg
COLOR OF HIGHLIGHT   = w+/g
COLOR OF MESSAGES    = w/b
COLOR OF TITLES      = n/bg
COLOR OF BOX         = W+/b
COLOR OF INFORMATION = bg+/b
COLOR OF FIELDS      = W+/n

LOCALSHARE           = OFF

ENDTEXT

? 'LIBRARY              =', cHomePath + "DBBDsgn"

TEXT
COMMAND              = ASSIST

PRGFORM              = _DLENTRY,_DLEXIT,_DLLAY,,_DLEXEC
PRGCC                = _DLCCENT, _DLCCEXT, _DLCCLAY

DBTRAP               = OFF
DEVELOPMENT          = ON
EXACT                = ON
EXCLUSIVE            = OFF
EXPSIZE              = 200
INSTRUCT             = OFF
MARGIN               = 5
MEMOWIDTH            = 65
MVBLKSIZE            = 60
MVMAXBLKS            = 16
PROMPT               = DBB->
RTBLKSIZE            = 60
RTMAXBLKS            = 16
STATUS               = ON
TABS                 = 5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80
TALK                 = OFF
TRAP                 = ON
TYPEAHEAD            = 400
HISTORY              = 50

* International
LDCHECK = OFF

* END: CONFIG.DBB

ENDTEXT
  
  SET ALTERNATE OFF
  SET ALTERNATE TO

  *-----------------------------------------------
  *-- Make DBB.BAT to start the Dialog Box Builder
  *-----------------------------------------------
  SET ALTERNATE TO dbb.bat
  SET ALTERNATE ON
  SET CONSOLE OFF

? '@ECHO OFF'
? 'GOTO start'
? '---------------------------------------------------------------'
? ' DBB.BAT - Starts dBASE with CONFIG.DBB'
? '---------------------------------------------------------------'
? ':start'
? '  ' + cHomePath + 'DBASE /c', cHomePath + 'config.dbb'
? ':end'
? 'REM END: DBB.BAT'
?

  SET ALTERNATE OFF
  SET ALTERNATE TO
  SET CONSOLE ON

  *--------------------------
  *-- Display the readme file
  *--------------------------
  ON ERROR
  SET DIRECTORY TO &cHomeDir
  COPY FILE &cInstDrv.readme. TO readme.dbb
  ! README readme.dbb

QUIT
*-- EOP: Install



