PROCEDURE Install
*----------------------------------------------------------------------------
* NAME
*   Install - Installs the dBASE IV Productivity Pack
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
  SET TALK OFF
  SET ECHO OFF
  SET COLOR OF NORMAL      TO w+/bg
  SET COLOR OF HIGHLIGHT   TO w+/g
  SET COLOR OF MESSAGES    TO w/b
  SET COLOR OF TITLES      TO n/bg
  SET COLOR OF BOX         TO W+/b
  SET COLOR OF INFORMATION TO bg+/b
  SET COLOR OF FIELDS      TO W+/n
  SET STATUS OFF
  SET BORDER TO NONE
  SET SCOREBOARD OFF

  DEFINE WINDOW title FROM 8,16 TO 11, 62 COLOR n/w
  ACTIVATE WINDOW title
  @ 0,0 SAY "" COLOR n/w 
  @ 0,46 SAY "" COLOR w+/w 
  @ 1,0 SAY "" COLOR n/w 
  @ 1,3 SAY "Welcome to the dBASE IV Productivity Pack" 
  @ 1,46 SAY "" COLOR w+/w 
  @ 2,0 SAY "" COLOR n/w 
  @ 2,12 SAY "for dBASE IV version 2.0" 
  @ 2,46 SAY "" COLOR w+/w 
  @ 3,0 SAY "" COLOR n/w 
  @ 3,1 SAY "" COLOR w+/w 
  SAVE SCREEN TO title
  RELEASE WINDOW title
  RESTORE SCREEN FROM title

  SET EXACT ON
  SET EXCLUSIVE OFF
  SET SAFETY OFF

  cSampDir = "MFFUSAMP"
  cSrcDir  = "MFFUSRC"

  cSEAHome = "MFFUROOT.EXE"            && Self-Extracting Archive for HOME()
  cSEASamp = "MFFUSAMP.EXE"            && Self-Extracting Archive for Samples
  cSEASrc1 = "MFFUSCRS.EXE"            && Self-Extracting Archive for Source
  cSEASrc2 = "MFFUPRGS.EXE"            && Self-Extracting Archive for Source
  cSEASrc3 = "PRGSPRGS.EXE"            && Self-Extracting Archive for Source
  cSEASrc4 = "PRGSSCRS.EXE"            && Self-Extracting Archive for Source
  cSEASrc5 = "MFFUGEN.EXE"             && Self-Extracting Archive for Source
  cSEACods = "MFFUCODS.EXE"            && Self-Extracting Archive for Source

  *------------------------------------------------------
  *-- Check the version of dBASE before going any further
  *------------------------------------------------------
  IF .NOT. ( "2.0" $ VERSION() )
    WAIT "This is not dBASE IV version 2.0!"
    QUIT WITH 1
  ENDIF

  cInstDrv = SET( "DIRECTORY" )
  IF RIGHT( cInstDrv, 1 ) <> "\"
    cInstDrv = cInstDrv + "\"
  ENDIF
  cSEAHome = cInstDrv + cSEAHome
  cSEASamp = cInstDrv + cSEASamp
  cSEASrc1 = cInstDrv + cSEASrc1
  cSEASrc2 = cInstDrv + cSEASrc2
  cSEASrc3 = cInstDrv + cSEASrc3
  cSEASrc4 = cInstDrv + cSEASrc4
  cSEASrc5 = cInstDrv + cSEASrc5
  cSEACods = cInstDrv + cSEACods

  cHomePath = HOME()
  cHomeDir = LEFT( cHomePath, LEN( cHomePath ) - 1 )
  SET DIRECTORY TO &cHomeDir

  *-------------------------------------------
  *-- See if you have rights to this directory
  *-------------------------------------------
  ON ERROR lh = 0
  lh = 0
  lh = FCREATE( "CHECKIT.OUT" )
  IF lh = 0
    WAIT "You do not have rights to the dBASE home directory!"
    QUIT WITH 1
  ENDIF
  lOk = FCLOSE( lh )
  ERASE CHECKIT.OUT

  *--------------------------------------------------------
  *-- Create the source and sample subdirectories as needed
  *--------------------------------------------------------
  lh = 0
  lh = FCREATE( cSampDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    ! MD &cSampDir >nul
  ELSE
    lOk = FCLOSE( lh )
    ERASE ( cSampDir + "\" + "CHECKIT.OUT" )
  ENDIF

  lh = 0
  lh = FCREATE( cSrcDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    ! MD &cSrcDir >nul
  ELSE
    lOk = FCLOSE( lh )
    ERASE ( cSrcDir + "\" + "CHECKIT.OUT" )
  ENDIF

  lh = 0
  lh = FCREATE( cSampDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    WAIT "Cannot create samples directory: " + cHomePath + cSampDir
    QUIT WITH 1
  ENDIF
  lOk = FCLOSE( lh )
  ERASE ( cSampDir + "\" + "CHECKIT.OUT" )
  lh = 0
  lh = FCREATE( cSrcDir + "\" + "CHECKIT.OUT" )
  IF lh = 0
    WAIT "Cannot create source directory: " + cHomePath + cSrcDir
    QUIT WITH 1
  ENDIF
  lOk = FCLOSE( lh )
  ERASE ( cSrcDir + "\" + "CHECKIT.OUT" )

  *-------------------------
  *-- Start extracting files
  *-------------------------
  x = run( cSEAHome + " -o", .t. )

  SET DIRECTORY TO &cSampDir
  x = run( cSEASamp + " -o", .t. )

  SET DIRECTORY TO &cHomeDir
  SET DIRECTORY TO &cSrcDir
  x = run( cSEASrc1 + " -o", .t. )
  x = run( cSEASrc2 + " -o", .t. )
  x = run( cSEASrc3 + " -o", .t. )
  x = run( cSEASrc4 + " -o", .t. )
  x = run( cSEASrc5 + " -o", .t. )
  x = run( cSEACods + " -o", .t. )

  SET DIRECTORY TO &cHomeDir

  *-----------------------------------
  *-- Make the CONFIG.DBB startup file
  *-----------------------------------
  SET CONSOLE OFF
  SET ALTERNATE TO config.mff
  SET ALTERNATE ON

TEXT
*
*       dBASE IV Productivity Pack (Multi-File Forms) Configuration File
ENDTEXT

? '*    Created on:', DATE()

TEXT
*
COLOR OF NORMAL      = w+/bg
COLOR OF HIGHLIGHT   = w+/g
COLOR OF MESSAGES    = w/b
COLOR OF TITLES      = n/bg
COLOR OF BOX         = W+/b
COLOR OF INFORMATION = bg+/b
COLOR OF FIELDS      = W+/n

LOCALSHARE           = OFF

ENDTEXT

? 'LIBRARY              =', cHomePath + "MFFUDsgn"

TEXT
COMMAND              = ASSIST

PRGFORM              = _FXEntry, _FXExit, _FXLay, _FXField, _FXExec
ENDTEXT

? 'PRGCC                =', cHomePath + "_FXCCEnt"

TEXT
PROMPT               = MFFU->
DBTRAP               = OFF
DEVELOPMENT          = ON
EXACT                = ON
EXCLUSIVE            = OFF
EXPSIZE              = 200
INSTRUCT             = OFF
MARGIN               = 5
MEMOWIDTH            = 65
MVBLKSIZE            = 60
MVMAXBLKS            = 16
RTBLKSIZE            = 60
RTMAXBLKS            = 16
STATUS               = ON
TABS                 = 5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80
TALK                 = OFF
TRAP                 = ON
TYPEAHEAD            = 400
HISTORY              = 50

* International
LDCHECK = OFF

* END: CONFIG.MFF

ENDTEXT
  
  SET ALTERNATE OFF
  SET ALTERNATE TO

  *-----------------------------------------------
  *-- Make MFFU.BAT to start the Dialog Box Builder
  *-----------------------------------------------
  SET ALTERNATE TO mffu.bat
  SET ALTERNATE ON
  SET CONSOLE OFF

? '@ECHO OFF'
? 'GOTO start'
? '---------------------------------------------------------------'
? ' MFFU.BAT - Starts dBASE with CONFIG.MFF'
? '---------------------------------------------------------------'
? ':start'
? '  ' + cHomePath + 'DBASE /c', cHomePath + 'config.mff'
? ':end'
? 'REM END: MFFU.BAT'
?

  SET ALTERNATE OFF
  SET ALTERNATE TO
  SET CONSOLE ON

  *--------------------------
  *-- Display the readme file
  *--------------------------

  ON ERROR
  SET DIRECTORY TO &cHomeDir
  COPY FILE &cInstDrv.readme. TO readme.mff
  ! README readme.mff

QUIT
*-- EOP: Install



