/* --- FONTX.C -- Compiles a subset of AutoCAD font files (*.SHP) into packed
 |	     binary format for faster loading and drawing.
 |     Compiled file fomat is totally incompatible from AutoCAD "*.SHX"
 |	     file format.  We don't know the format for "*.SHX" files.
 |     To acknowledge this difference, this program produces compiled
 |	     files with suffix ".XSH".
 |     Compiled fonts can be viewed using the accompanying program FONTDEMO.C.
 |     There is NO DOCUMENTATION for the format of our compiled font in "*.XSH"
 |	     files.  Please read FONTDEMO.C code for details.
 |     This program is hereby released into the public domain.
 |     This program has been developed to use Hershey Font in our locally
 |	     developed graphics package.
 |     This program supports only a subset of AutoCAD "*.SHP" font definitions.
 |	     Vertical text mode will be ignored, and "*.SHP" files containing
 |	     ARC commands cannot be compiled.
 |	     
 |     Author:     Wayne C. Crawford,   6-20-88 starting.
 *-------------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>

FILE *fpinp;
FILE *fpdataout;
unsigned int ptarray[128];
unsigned int fontarray[6000];
int junk, garbage;
int pendowner;
char string[128];
char readfile[80], *rfileptr;
char writefile[80], *wfileptr;
int count = 1;  		/* position of array that we are presently in */
int ignore = 0;
float xpos,ypos;
float fontscale;


/*------ mani() starts here -----------------------------------------------*/
main(argc,argv)
int argc;
char *argv[];
{
int inpnum;
char line[255];
register int i;
char *stringptr;

	if (argc != 2)
	{
		printf("Usage: FONTX FONTNAME.SHP (enter)\n\n");
		printf("	Compiles Hershey Font in AutoCAD SHP format into\n");
		printf("	packed binary format, and output results to\n");
		printf("	a file FONTNAME.XSH\n");
		exit(1);
	}

	strcpy( readfile, strupr(argv[1]) );
	strcpy( writefile, readfile);
	/* Check if filename is OK */
	stringptr = readfile;
	while ( *(++stringptr) != '\0' );
	--stringptr; --stringptr; --stringptr;
	if( strcmp( stringptr, "SHP") != 0 )
	{
		printf("Input file suffix must be .SHP\n");
		exit(2);
	}	

	if ((fpinp= fopen(argv[1],"r")) == NULL)
	{
		printf("Couldn't open file: %s\n",argv[1]);
		exit(2);
	}

	for( i = 0; i < 128; i++)
		ptarray[i] = 0;	      /* INITIALIZE POINTER ARRAY */
	
	fgets(line,80,fpinp);
	get_next_integer(&inpnum,&garbage);
	fontscale = 21./(float)inpnum;
	fgets(line,80,fpinp);
	printf("Fontscale = %.2f\n",fontscale);
	while ( inpnum != -1)
	{
		inpnum = get_one_command();
	}
	printf("count = %d\n",count);
	wrt_fontfile(writefile);
	fclose(fpinp); 
}	


get_one_command()
{
int inpnum,newinp;
int endof = 0;
	
	endof = get_next_integer(&inpnum,&newinp);
	if (endof == -1)
		return(-1);
	if (newinp)
	{
		ptarray[inpnum] = count;
		xpos = 20.;
		ypos = 20.; /* The "20"s are to offset the character box */
	}
	else
	{
	    switch(inpnum)
	    {
		case 0:	end_of_shape();
			break;
		case 1:	pendown(1);
			break;
		case 2: pendown(0);
			break;
		case 3:
		case 4:	if (!ignore)
				printf("Multiply/Divide Error\n");
			get_next_integer(&junk,&garbage);
			break;
		case 5:	
		case 6:	
		case 7:	
		case 10:	
		case 11:	
		case 12:	
		case 13: printf("TERMINAL Error!\n");
			return(-1);
			break;	
		case 8: convert_to_screen();
			break;	
		case 9: while (convert_to_screen());
			break;	
		case 14: ignore = 1;
			get_one_command();
			ignore = 0;
			break;	
		default: convert_to_xy(inpnum);
			break;	
	    }
	}
	return(inpnum);
}	


get_next_integer(number, newone)
int *number, *newone;
{
int c;

	c = getc(fpinp);
	while ( ((c > '9') || (c < '0')) && ((c != '*') && (c != '-')) && (c != -1) )
		c = getc(fpinp);
	if (c == -1)
		return (-1);
	else if (c == '*')
	{
		c = getc(fpinp);	/* ADVANCE STREAM POINTER BY ONE */
		*number = grabnum(c);
	        fgets(string,80,fpinp);
		*newone = 1;
	}
	else
	{
		*number = grabnum(c);
		*newone = 0;
	}
	return(0);
}


grabnum(c)
int c;
{
int value;

 	if (c == '0') /* GET HEXIDECIMAL NUMBER */
	{
		value = decodedhex(c);
		while ( decodedhex(c = getc(fpinp)) >= 0 )
		{
			value = value*16 + decodedhex(c);
		}
	}
	else if (c == '-')  /* negative value */
	{
		value = getc(fpinp) - '0';
		c = getc(fpinp);
		while ( (c >= '0') && (c <= '9') )
		{
			value = value*10 + c - '0';
			c = getc(fpinp);
		}
		value *= -1;
	}
	else 		  	/* positive integer */
	{
		value = c - '0';
		c = getc(fpinp);
		while ( (c >= '0') && (c <= '9') )
		{
			value = value*10 + c - '0';
			c = getc(fpinp);
		}
	}
	return(value);
}


decodedhex(c)
int c;
{
	int value;

	if ( (c >= 'a')&&(c <= 'f') )
		value = 10 + c - 'a';
	else if ( (c >= 'A')&&(c <= 'F') )
		value = 10 + c - 'A';
	else if ( (c >= '0')&&(c <= '9') )
		value = c - '0';
	else value = -1;
	return(value);
}


/****************************************************************************/
/******************** NOW FOR THE COMMAND HANDLING PART *********************/
/****************************************************************************/

end_of_shape()
{ 
	if (!ignore)
	{
		fontarray[count++] = 0x4000;
	}
	return(0);
}

pendown(penval)
int penval;
{
	if (!ignore)
	{
		fontarray[count++] = 0x2000 + penval*0x1000;
	}
	return(0);
}

convert_to_screen()
{
int x,y,junk;

	get_next_integer(&x,&junk);
	get_next_integer(&y,&junk);
	if (!ignore)
	{
		if ((x == 0) && (y == 0))
			return(0); 
		xpos += (float)x*fontscale;
		ypos += (float)y*fontscale;
		fontarray[count++]
		  = (((int)(xpos+0.1) & 0x3f) << 6) + ((int)(ypos+0.1) & 0x3f);
	}
	return(1);
}

convert_to_xy(hexnum)
int hexnum;
{
float xtimes,ytimes;
unsigned int dirhex, maghex;

	if (!ignore)
	{
	    dirhex = hexnum & 0x0f;
	    maghex = (hexnum & 0xf0) >> 4;
	    switch (dirhex)
	    {
	    	case 0:	xtimes = 1.; ytimes = 0.;
			break;
	    	case 1:	xtimes = 1.; ytimes = .5;
			break;
	    	case 2:	xtimes = 1.; ytimes = 1.;
			break;
	    	case 3:	xtimes = .5; ytimes = 1.;
			break;
	    	case 4:	xtimes = 0.; ytimes = 1.;
			break;
	    	case 5:	xtimes = -.5; ytimes = 1.;
			break;
	    	case 6:	xtimes = -1.; ytimes = 1.;
			break;
	    	case 7:	xtimes = -1.; ytimes = .5;
			break;
	    	case 8:	xtimes = -1.; ytimes = 0.;
			break;
	    	case 9:	xtimes = -1.; ytimes = -.5;
			break;
	    	case 10:xtimes = -1.; ytimes = -1.;
			break;
	    	case 11:xtimes = -.5; ytimes = -1.;
			break;
	    	case 12:xtimes = 0.; ytimes = -1.;
			break;
	    	case 13:xtimes = .5; ytimes = -1.;
			break;
	    	case 14:xtimes = 1.; ytimes = -1.;
			break;
	    	case 15:xtimes = 1.; ytimes = -.5;
			break;
		default:printf("BIG Direction mistake\n");
			break;
	    }
	    xpos += maghex*xtimes*fontscale;
	    ypos += maghex*ytimes*fontscale;
       	    fontarray[count++]
		= (((int)(xpos+0.1) & 0x3f) << 6) + ((int)(ypos+0.1) & 0x3f);
	}
	return(0);
}

/****************************************************************************/

/* ----- Write compiled font file ---------------------------------- */
wrt_fontfile(wfilename)
char *wfilename;
{
int it;
int numwritten;
int *fontptr;
char *stringptr;

	stringptr = wfilename;
	while ( *(++stringptr) != '\0' );	/* change suffix to XSH */
	*(--stringptr) = 'H';
	*(--stringptr) = 'S';
	*(--stringptr) = 'X';

	fpdataout = fopen(wfilename, "wb");
	if (fpdataout == NULL)
	{
		printf("Compiled font file: %s cannot be opened.\n",writefile);
		return(1);
	}
	/* OK file opened, write the size of the font array*/
        numwritten = fwrite( (char *)&count, sizeof(unsigned), 1, fpdataout);
        numwritten = fwrite( (char *)ptarray, sizeof(unsigned), 128, fpdataout);
	numwritten = fwrite( (char *)fontarray, sizeof(unsigned), count+2, fpdataout);
	if( numwritten != (count+ 2))
	{
	    printf("Can't write compiled font file fully.\n");
	}
	fclose(fpdataout);
}

