/*****************************************************************************/
/*	Title	:   CXYIBMPC.C					   	     */
/*	C Graphic Functions for CGA/EGA via slooow BIOS			     */
/*****************************************************************************/
/*						   			     */
/*       Jul. 14, 1988         I. Ohzawa		 		     */
/*****************************************************************************/

#include <stdio.h>
#include <dos.h>
#define BIOS_VIDEO  0x10

static union REGS inregs, outregs;
static int xcurr, ycurr;		/* current x,y */

/*********--------------------------------------------------------------******/
/*	Function:   cxy_videomode(mode)					     */
/*	  changes the current mode of ncolor display to mode specified	     */
/*		mode ; --- refer to the Function to_color(mode)		     */
/*			= 0   40 (columns) x 25 (lines) Black & White	     */
/*			= 1   40 x 25 Color				     */
/*			= 2   80 x 25 Black & White			     */
/*			= 3   80 x 25 Color				     */
/*			= 4   320 x 200 (dots) Color			     */
/*			= 5   320 x 200 Black & White			     */
/*			= 6   640 x 200 Black & White			     */
/*			= 16  640 x 350 EGA graphics mode          	     */
/*	return value	; NULL if safely selected			     */
/*			; -1 if error occured				     */
/********---------------------------------------------------------------******/
cxy_videomode(mode)
int mode;
{
/*	union REGS inregs, outregs;	 */
	inregs.h.ah = 0;  	/* set mode (AL) contains mode value */
	inregs.h.al = mode;
	int86(BIOS_VIDEO, &inregs, &outregs);
	return(NULL);
}

/* ------------------------------------------------------------------------*/
/* Function:   cxy_color(bakgnd, palette)				   */
/*    sets background color and palette   				   */
/*    bakgnd  -- background color					   */
/*    palette -- palette selection					   */
/*-------------------------------------------------------------------------*/

cxy_color(bakgnd, palette)
int bakgnd, palette;
{
	inregs.h.bh = 0;		/* ID for background */
	inregs.h.ah = 11;		/* palette select    */
	inregs.h.bl = bakgnd;	/* color for bakgnd  */
	int86(BIOS_VIDEO, &inregs, &outregs);

	inregs.h.bh = 1;		/* ID for palette */
	inregs.h.ah = 11;		/* to be sure	*/
	inregs.h.bl = palette;	/* palette code   */
	int86(BIOS_VIDEO, &inregs, &outregs);
	return(NULL);
}

/* ------------------------------------------------------------*/
/* Function: cxy_move(xpos, ypos)			       */
/*  preset current position to (xpos,ypos)   		       */
/*-------------------------------------------------------------*/
cxy_move(xpos,ypos)
int xpos,ypos;
{
	xcurr = xpos;
	ycurr = ypos;
	return(NULL);
}


/* ------------------------------------------------------------*/
/* Function:  cxy_lineto(xpos, ypos, color)		       */
/*   draws a line of color from current x,y to xpos, ypos      */
/* ------------------------------------------------------------*/
cxy_lineto(xpos, ypos, color)
int xpos, ypos, color;
{
	cxy_line(xcurr,ycurr,xpos,ypos,color);
	return;
}

/* ----------------------------------------------------------------*/
/* Function:  cxy_line(x1, y1, x2, y2, color)			   */
/*   draws a line of color from x1,y1 to x2, y2			   */
/*   calls assembly language function cxy_dot(xpos, ypos, color)   */
/* ----------------------------------------------------------------*/
cxy_line(x1, y1, x2, y2, color)
int x1, y1;		/* starting point */
int x2, y2;		/* ending point   */
int color;		/* color of line  */
{
					/* use static vars for fastest access */
	static int lg_delta, sh_delta;	/* distance of long, short axis */
	static int lg_step, sh_step;		/* 0, 1, or -1 */
	static int cycle;			/* decision variable */
	static int temp;			/* swapping variable */

	xcurr = x2;				/* update current pos */
	ycurr = y2;
	lg_delta = x2 - x1;		/* get travel along x-axis */
	if (lg_delta >= 0)
		lg_step = 1;
	else
	{
		lg_delta = -lg_delta;		/* get abs value */
		lg_step  = -1;			/* reverse direction */
	}

	sh_delta = y2 - y1;		/* get travel along y axis */
	if (sh_delta >= 0)
		sh_step = 1;
	else
	{
		sh_delta = -sh_delta;		/* get abs value */
		sh_step  = -1;
	}

	if (sh_delta > lg_delta)     /* is y-axis travel is longer, swap */
	{
		cycle = sh_delta >> 1;			/* devide by 2 */
		temp = lg_delta; lg_delta = sh_delta; sh_delta = temp;
		temp = lg_step;  lg_step  = sh_step;  sh_step  = temp;

		while (y1 != y2)		/* loop for vertical line */
		{
		   cxy_dot(x1, y1, color);
		   y1 += lg_step;		/* always bump line pointer */
		   cycle += sh_delta;	/* bump decision variable */
		   if(cycle >= lg_delta)	/* pase decision threshold? */
			{
			  cycle -= lg_delta; /* reset for next decision cycle */
			  x1 += sh_step;	/* bump column pointer */
			}
		}
	}

	else
	{			/* if x-axis travel is longer, no swap */
		cycle = lg_delta >> 1;			/* divide by 2 */
		while (x1 != x2)
		{			/* loop for horizontal line */
		    cxy_dot(x1, y1, color);
		    x1 += lg_step;
		    cycle += sh_delta;
		    if( cycle >= lg_delta)
			{
			   cycle -= lg_delta;
			   y1 += sh_step;
			}
		}
	}

}		/* end of line  */

/* ---- Sloooow function cxy_dot via BIOS --------------------------------- */

cxy_dot( xpos, ypos, color)
int xpos, ypos, color;
{
/*	union REGS inregs, outregs;*/
	inregs.x.dx = ypos;
	inregs.x.cx = xpos;
	inregs.h.ah = 12;
	inregs.h.al = color;
	int86 (BIOS_VIDEO, &inregs, &outregs);
}

