/* CLIDEMO is a simple program demonstrating how to establish a DDE
   connection with WorldView and use it to send CLI commands.  It
   is provided purely as programming example, not as a supported
   product. */

#include <windows.h>
#include <ddeml.h>
#include <string.h>
#include "clidemo.h"

long FAR PASCAL WndProc(HWND, WORD, WORD, LONG);
long FAR PASCAL EditProc(HWND, WORD, WORD, LONG);
HDDEDATA EXPENTRY 
DdeCallback(WORD, WORD, HCONV, HSZ, HSZ, HDDEDATA, DWORD, DWORD);

DWORD idInst = 0L;
HSZ hszServerName;
HSZ hszTopic;
HSZ hszResult;
HCONV hConversation;
FARPROC	lpfnOldEditProc;
FARPROC lpfnEditProc;
HWND hwndMain;

/* Free up the DDE strings we declared. */
void FreeStrings()
{
	DdeFreeStringHandle(idInst, hszServerName);
	DdeFreeStringHandle(idInst, hszTopic);
	DdeFreeStringHandle(idInst, hszResult);
	DdeUninitialize(idInst);
}


/* Because results from CLI contain LFs (Unix standard) instead 
   of CR/LFs (DOS standard), we have to filter the result while 
   sending it to the control. */

void SendTextToEditControl(HWND hwnd, LPSTR szText)
{
	SendMessage(hwnd, WM_SETTEXT, 0, (LPARAM) (LPSTR) "");
	
	for(szText = _fstrtok(szText, "\n");
	    szText != NULL;
	    szText = _fstrtok(NULL, "\n"))
	{
		SendMessage(hwnd, EM_SETSEL, 0, MAKELONG(-1, -1));
		SendMessage(hwnd, EM_REPLACESEL, 0, (LPARAM)(LPSTR) szText);  
		SendMessage(hwnd, EM_SETSEL, 0, MAKELONG(-1, -1));
		SendMessage(hwnd, EM_REPLACESEL, 0, (LPARAM)(LPSTR) "\r\n");
	}
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
LPSTR lpszCmdLine, int nCmdShow)
{
	static char szAppName[] = "CliDemo";
	MSG		msg;
	WNDCLASS	wndclass;
	FARPROC lpDdeProc;
	HWND hwndCommand;
	
	if(!hPrevInstance)
	{
		wndclass.style		= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra	= 0;
		wndclass.cbWndExtra	= DLGWINDOWEXTRA;
		wndclass.hInstance	= hInstance;
		wndclass.hIcon		= LoadIcon(hInstance, szAppName);
		wndclass.hCursor	= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= COLOR_WINDOW+1;
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= szAppName;
		
		RegisterClass(&wndclass);
	}

	lpDdeProc = MakeProcInstance((FARPROC) DdeCallback, hInstance);

	lpfnEditProc = 
		MakeProcInstance((FARPROC) EditProc, hInstance);
	
	
	
	/* Initialize DDE, create the strings, and connect with WorldView. */
	if(DdeInitialize(&idInst,
		(PFNCALLBACK) lpDdeProc,
		CBF_FAIL_EXECUTES | CBF_FAIL_POKES,
		0L))
			return(NULL);
		
	hszServerName = 
		DdeCreateStringHandle(idInst, "WorldView", CP_WINANSI);
	
	hszTopic = 
		DdeCreateStringHandle(idInst, "CLI", CP_WINANSI);
	
	hszResult =
		DdeCreateStringHandle(idInst, "Result", CP_WINANSI);
	
	if((NULL == (hConversation = DdeConnect(idInst, hszServerName, 
				hszTopic, (PCONVCONTEXT) NULL))) &&
	   ((WinExec("iview.exe", SW_SHOWNORMAL) < 32) ||
	   (NULL == (hConversation = DdeConnect(idInst, hszServerName,
				hszTopic, (PCONVCONTEXT) NULL)))))
	{
		MessageBox(NULL, "Unable to start and/or connect with WorldView.\nMake sure a CLI-capable version of WorldView in on PATH.", "Error", MB_OK);
		FreeStrings();
		return(NULL);
	}
	
	
	
	hwndMain = CreateDialog(hInstance, szAppName, 0, NULL);

	
	/* Replace the edit control's prodedure with our own (which calls
	   the original procedure).  This allows us to catch the ENTER
	   key and respond to it. */
	hwndCommand = GetDlgItem(hwndMain, ID_COMMAND);
	
	lpfnOldEditProc = 
		(FARPROC) GetWindowLong(hwndCommand, GWL_WNDPROC);
	SetWindowLong(hwndCommand, GWL_WNDPROC, (LONG) lpfnEditProc);

	
	ShowWindow(hwndMain, nCmdShow);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	
	if(hConversation != NULL)
		DdeDisconnect(hConversation);
	FreeStrings();
	return(msg.wParam);
}


/* Since the client initiates most of the DDE exchange, the callback
   function can be simple. */
HDDEDATA EXPENTRY DdeCallback(WORD wType, WORD wFmt, HCONV hConv,
		HSZ hsz1, HSZ hsz2, HDDEDATA hData, 
		DWORD dwData1, DWORD dwData2)
{
	switch(wType)
	{
	case XTYP_DISCONNECT :
		/* If WorldView disconnects (because it exits), we'll
	           exit too. */
		hConversation = NULL;
		DestroyWindow(hwndMain);
		return((HDDEDATA) NULL);
			
	default:
		return((HDDEDATA) NULL);
	}
			
}

#define MAX_COMMAND 1024

long FAR PASCAL WndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	DWORD dwResult;
	int iLen;
	char szBuffer[MAX_COMMAND+1];
	HDDEDATA hResult;

	switch(message)
	{
	case WM_CREATE :
		return(0);

		
	case WM_COMMAND :
		switch(wParam)
		{
			
		case ID_EXECUTE :
			/* Get text from edit control. */
			iLen = GetDlgItemText(hwnd, ID_COMMAND,
				szBuffer, MAX_COMMAND);
			SetDlgItemText(hwnd, ID_RECENT, szBuffer);
			
			/* Send command to WorldView */
			DdeClientTransaction(szBuffer, strlen(szBuffer)+1,
				hConversation, NULL, CF_TEXT, 
				XTYP_EXECUTE, 10000, &dwResult);
			
			/* Get result from WorldView */
			hResult = DdeClientTransaction(NULL, 0, hConversation,
				hszResult, CF_TEXT, XTYP_REQUEST, 
				10000, &dwResult);
			if(hResult != NULL)
			{
				char FAR * szResult = DdeAccessData(hResult, 
					NULL);
				SendTextToEditControl(
					GetDlgItem(hwnd, ID_RESULT),
					szResult);
				DdeUnaccessData(hResult);
			}
			SetDlgItemText(hwnd, ID_COMMAND, "");
			SetFocus(GetDlgItem(hwnd, ID_COMMAND));
			return(0);
			
		case ID_COMMAND :
			return(0);
			
		case ID_RESULT :
			return(0);	
		}
		
	case WM_SETFOCUS :
		SetFocus(GetDlgItem(hwnd, ID_COMMAND));
		return(0);

	
	case WM_DESTROY :
		PostQuitMessage(0);
		return(0);
	}
	return(DefWindowProc(hwnd, message, wParam, lParam));
}

/* If the message involves the ENTER key, we execute the command; otherwise
   pass it on to the normal edit procedure */
long FAR PASCAL EditProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	switch(message)
	{
	case WM_KEYDOWN :
		if(wParam == VK_RETURN)
		{	PostMessage(hwndMain, WM_COMMAND, ID_EXECUTE, 0L);
			return(0);
		}
		
	case WM_KEYUP :
	case WM_CHAR :
		if(wParam == VK_RETURN)
			return(0);
	
	}
	
	return(CallWindowProc(lpfnOldEditProc, hwnd, 
				message, wParam, lParam));
}