#!/bin/sh
# RE_SID: @(%)/tmp_mnt/vol/dosnfs/shades_SCCS/unix/tools/SCCS/s.dorfcmsg.sh 1.4 93/01/08 17:15:48 SMI
#
#  @(#)dorfcmsg.sh	1.4	1/8/93
#
# dorfcmsg.sh
#
# This script will unpack the console messaging server/client sources.
# It does NOT make the server and client components.  This must be
# done manually.
# The console messaging client/server programs are based on the
# Message Send Protocol 2, described in RFC1312.
#
# To use this script you must first have copied the following files 
# from the PC-NFS distribution diskette:
#		dorfcmsg.sh   ( this file )
#		rfcmsg.taz    ( compressed tar file )
# to some place on the system you are going to perform the install.  
# Usually /usr/tmp is a good place.  This script does not take any 
# arguments.
#

RFCMSG=rfcmsg

fatalerror ( )   # handle fatal errors
{
    echo " " ; echo "*** FATAL ERROR: $@" 1>&2 ; exit 1
}

if [ $# != 0 ]
then
	fatalerror "   Usage: dorfcmsg"
fi

echo " "
echo "Unpack MSGSERV shell script"
echo " "

if [ ! -f $RFCMSG.taz ]
then
    fatalerror "The compressed tar file $RFCMSG.taz is missing." 
fi

#FILE=`file $RFCMSG.taz | awk '{print $2}'`
#
#
# skip this test 'cos Solaris 2.x doesn't say it's compressed!
#
#if [ $FILE = "compressed" ]
#then
#	echo " "
#	echo "Uncompressing the $RFCMSG.taz file..."
#	mv -f $RFCMSG.taz $RFCMSG.tar.Z
#	uncompress -v $RFCMSG.tar.Z
#	if [ $? != 0 ] ; then
#		fatalerror "Uncompresing $RFCMSG.taz failed."
#	fi
#fi

echo " "
echo "Uncompressing the $RFCMSG.taz file..."
mv -f $RFCMSG.taz $RFCMSG.tar.Z
uncompress -v $RFCMSG.tar.Z
if [ $? != 0 ] ; then
	fatalerror "Uncompresing $RFCMSG.taz failed."
fi

echo " "
echo "Unpacking the $RFCMSG.tar file..."
tar -xvf $RFCMSG.tar
if [ $? != 0 ] ; then
	fatalerror "Extracting files from $RFCMSG.tar failed."
fi

echo " "
echo "Unpack RFCMSG script completed."
echo " "
echo "You can build the server and client components by running"
echo "the makefiles provided."
echo "Pre-compiled versions of the server and client programs"
echo "are included in this distribution."
echo " "
echo "The Console Messaging server and client programs are based"
echo "on the Message Send Protocol 2 which is described in RFC1312."
echo " "
echo "Refer to the PC-NFS Administration Guide for details."
echo " "
echo " "


