/*
 * Mapname.c : display mapping between NetBIOS names and RFC-encoding
 *
 * 12/10/90 hj  initial version
 *
 */
#include <stdio.h>
#include <ctype.h>

#define NAMELEN 16

#define FIRST_ENC(c)  ((((c) >> 4) & 0xf) + 'A')
#define SECOND_ENC(c) (((c) & 0xf) + 'A')
#define DECODE(cp)    ((*(cp) - 'A') << 4 | (*((cp) + 1) - 'A'))

#define byte    unsigned char

static char copyright[] =
   "\r\nCopyright (c) 1990 by Syntax, Inc\r\nAll rights reserved\r\n";

static char inbuf[256];


static int
unhex(x)
char x;
{
  if ((x >= 'a') && (x <= 'f')) return x - 'a' + 10;
  if ((x >= 'A') && (x <= 'F')) return x - 'A' + 10;
  if ((x >= '0') && (x <= '9')) return x - '0';
  return -1;
}

static
getoct(s)
char *s;
{
int n;

  if ((*s < '0') || (*s > '3')) return -1;
  n = 64 * (*s++ - '0');
  if ((*s < '0') || (*s > '7')) return -1;
  n += 8 * (*s++ - '0');
  if ((*s < '0') || (*s > '7')) return -1;
  n += *s++ - '0';
  return n;
}

char *
nbname(s)
register char *s;
{
static byte buf[17];
int i = 0,n;

  memset(buf,0,16);
  while (*s && i < 16) {
    if (*s == '\\') {
      switch(*++s) {
        case '\\' : buf[i++] = '\\'; ++s; break;
        case 'a'  : buf[i++] = '\a'; ++s; break;
        case 'b'  : buf[i++] = '\b'; ++s; break;
        case 'n'  : buf[i++] = '\n'; ++s; break;
        case 'r'  : buf[i++] = '\r'; ++s; break;
        case 't'  : buf[i++] = '\t'; ++s; break;
        case 'x'  :
          if (!isxdigit(s[1]) || !isxdigit(s[2])) buf[i++] = '\\';
          else {
            s++;
            buf[i++] = unhex(s[0]) * 16 + unhex(s[1]);
            s += 2;
          }
          break;
        case '0': case '1': case '2': case '3':
          if ((n = getoct(s)) < 0) buf[i++] = '\\';
          else {
            buf[i++] = n;
            s += 3;
          }
          break;
        default: buf[i++] = *s++; break;
      }
    }
    else buf[i++] = *s++;
  }
  buf[16] = 0;
  return buf;
}

static
n_encode(crypt,clear)
byte *crypt,*clear;
{
int i;

  for (i = 0; i < NAMELEN; i++) {
    *crypt++ = FIRST_ENC(clear[i]);
    *crypt++ = SECOND_ENC(clear[i]);
  }

  *crypt = '\0';
}

static
n_decode(clear,crypt)
byte *clear,*crypt;
{
int i;

  for (i = 0; i < NAMELEN; i++) {
    *clear++ = DECODE(crypt);
    crypt += 2;
  }
  *clear = '\0';
}

static char *
asc(s,l)
byte *s;
int l;
{
static byte buf[64],*bp;

  bp = buf;
  while (l--) { *(bp++) = isprint(*s) ? *s : '.'; s++; }
  *bp = 0;
  return buf;
}

static char *
hexnm(nbn)
byte *nbn;
{
int i;
static char hex[64];
register char *h;

  for (h=hex,i=0; i<16; i++) { sprintf(h,"%02.2x ",*(nbn++)); h += strlen(h); }
  *(h-1) = 0;
  return hex;
}

static
show(rfc,clear)
char *rfc,*clear;
{
  printf("NetBIOS    : [%s] %s\n",asc(clear,16),hexnm(clear));
  printf("RFC encoded: %s\n",rfc);
}

main()
{
char rfcname[68],clearnm[68],*ascii,x[68];
int i;

  printf("Name types:\n\n"
         "R == RFC encoded (converted to NetBIOS)\n"
         "N == NetBIOS     (converted to RFC encoded)\n\n"
         "RFC encoded names consist of letters A through P only.\n"
         "NetBIOS names consist of any ASCII characters.\n\n"
         "Enter non-printable ASCII characters using the \"C\" \"\\xxx\" conventions.\n\n");

  for (;;) {
    printf("\nName type? R(FC) or N(etBIOS) : ");
    if (!gets(x)) break;
    memset(rfcname,0,68);
    memset(clearnm,0,68);
    memset(inbuf,0,256);
    switch(x[0]) {
      case 'r' : case 'R' :
        printf("RFC encoded: ");
        if (!gets(inbuf)) break;
        strncpy(rfcname,inbuf,33);
        rfcname[32] = 0;
        for (i=0; i<strlen(rfcname); i++)
          rfcname[i] = toupper(rfcname[i]);
        if ((i=strspn(rfcname,"ABCDEFGHIJKLMNOP")) < strlen(rfcname)) {
          printf("The '%c' in %s is illegal; legal characters are A - P\n",
            rfcname[i],rfcname);
          break;
        }
        memset(rfcname+strlen(rfcname),'A',32-strlen(rfcname));
        n_decode(clearnm,rfcname);
        n_encode(rfcname,clearnm);
        show(rfcname,clearnm);
        break;

      case 'n' : case 'N' :
        printf("NetBIOS    : ");
        if (!gets(inbuf)) break;
        strncpy(clearnm,inbuf,68);
        clearnm[64] = 0;
        n_encode(rfcname,ascii=nbname(clearnm));
        n_decode(ascii,rfcname);
        show(rfcname,ascii);
        break;

      default :
        break;
    }
  }
}
