; This program uses the KB and VGA50 libs.

        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include vga50.inc
include kb.inc

public  _main

;
; DATA
;

msg0            db      'Press any key to go on.',0
msg1            db      'Press and release keys, and watch the contents of _kbtbl0.',0
msg2            db      'ESC to exit.',0
msg3            db      'Any key to exit to DOS.',0

textboxborders  db      'ĳڿ '

;
; CODE
;

;
_main:
        sti

        call _initkb                    ; init KB handler
        call _initvga50                 ; init VGA 80x50 text mode

        mov al,''                      ; box filled with  character
        mov ah,8                        ; grey on black
        mov bl,0                        ; at X=0
        mov bh,0                        ; and Y=0
        mov cl,80                       ; width 80
        mov ch,50                       ; height 50
        call _textbox0                  ; put text box

        mov bl,0
        mov bh,0
        mov cl,80
        mov ch,1
        call _pushtext                  ; save area of 80x1 at 0,0

        mov ah,15                       ; bright white on black
        mov edx,offset msg0
        call _putstr                    ; put string at 0,0

        call _getch                     ; wait for a keypress

        mov ah,15                       ; bright white on black
        mov edx,offset msg1
        call _putstr                    ; put new string there

        mov bl,10                       ; X=10
        mov bh,13                       ; Y=13
        mov cl,22                       ; width 22
        mov ch,15                       ; height 14
        call _pushtext                  ; save this area

        mov ah,7
        mov edx,offset textboxborders
        call _textbox1                  ; put text box with borders

        mov ah,14                       ; yellow on black
        add bl,2                        ; X=X+2 (10+2)
        add bh,1                        ; Y=Y+2 (13+2)
        mov edx,offset msg2
        call _putstr                    ; put string there

        mov ah,7
        add bh,2
        mov cl,18
        mov ch,10
        mov edx,offset textboxborders
        call _textbox1                  ; put text box with borders

; now continuously update the 16x8 area at 13,17 with the contents of _kbtbl0.

ml0:
        mov edi,0b8000h+160*17+2*13     ; get ptr to screen at 13,17
        sub edi,_code32a

        mov esi,offset _kbtbl0          ; get ptr to _kbtbl0

        mov bh,8                        ; first loop counter, 8 repetitions
ml1:
        mov bl,16                       ; second loop counter
ml2:
        mov al,' '                      ; store a blank space by default
        cmp byte ptr [esi],0            ; is key depressed?
        je short ml2f0
        mov al,''                      ; yes, so store a  instead
ml2f0:
        mov [edi],al                    ; put it to vidmem

        inc esi                         ; increment loc in _kbtbl0 and vidmem
        add edi,2

        dec bl                          ; dec loop counter and loop if needed
        jnz ml2

        add edi,2*(80-16)               ; adjust to next position in vidmem
        dec bh                          ; dec loop counter and loop if needed
        jnz ml1

        cmp _kbhit,0                    ; a valid key hit?
        je ml0

        call _getch                     ; get it
        cmp al,14                       ; loop if not an ESC
        jne ml0

        call _poptext                   ; restore 22x14 area at 10,13
        call _poptext                   ; restore 80x1 area at 0,0

        mov ah,15
        mov bl,0
        mov bh,20
        mov edx,offset msg3
        call _putstr                    ; put last message at 0,20

        call _getch                     ; wait for keypress

        mov v86r_ax,3                   ; return to normal text mode 3
        mov al,10h
        int 33h

        call _resetkb                   ; reset KB handler

        jmp _exit

code32  ends
        end

