/* Rexx procedure to install the OS/2 Service Pack Display Driver   */
/* diskettes in the Remote IPL directory tree.                      */
/*                                                                  */
/* Note: The OS/2 Service Pack must have already been installed     */
/*       in the Remote IPL directory tree.                          */
/*                                                                  */

Parse Arg  p1 p2 .
/* Check for help request (p1 = ? or /h or /H) */
If p1 = '?' | p1 = '/h' | p1 = '/H' Then Call Syntax_Help

parm.1 = p1
parm.2 = p2
drive = 'A'
userrplr = ''

num_ds_diskettes = 2
ds1_match = 'PSXGA32'
ds2_match = 'PSCGA16'

Do i = 1 to 2
   If parm.i = '' Then Leave
   parmtype = translate(substr(parm.i,1,2))
   select
      when parmtype = '/D' Then Do
         if substr(parm.i, 3, 1) = ':' Then drive = substr(parm.i, 4, 1)
         else drive = substr(parm.i, 4, 1)
         drive = translate(drive)
      end

      when parmtype = '/O' Then Do
         if substr(parm.i, 3, 1) = ':' Then userrplr = substr(parm.i, 4)
         else userrplr = substr(parm.i, 3)
      end

      otherwise Do
        Say 'The option 'parm.i' is not a valid option.'
        exit
      end
   end
end

/* ensure that the REXXUTIL functions are registered. */
Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

If userrplr <> '' Then riplroot = userrplr
else Do
   /* get RIPLINST root directory */
   riplroot = SysIni(SYSTEM, 'RIPLInstall', 'RIPLInstallTarget')
   if riplroot = 'ERROR:' Then Do
      Say 'OS2SYS.INI does not contain the parameter specifying the default'
      Say 'directory used by RIPLINST to install the OS/2 2.0 code in the'
      Say 'Remote IPL directory tree.  If the OS/2 2.0 code was installed in'
      Say 'the Remote IPL directory tree by some other means, rerun this '
      Say 'procedure and use the /O option to specify the directory path for'
      Say 'the OS/2 2.0 code.  For example:'
      Say '   RPLSPDDI /O:C:\IBMLAN\RPL\OS2.2O'
      exit
   end
end

/* verify that the OS/2 Service Pack has been installed by reading the */
/* first 60 bytes of SYSLEVEL.OS2 and checking the current OS/2 level*/
filename = riplroot'\OS2\INSTALL\SYSLEVEL.OS2'
syslevel = ''
Do i = 1 to 60
   syslevel = syslevel || charin(filename)
end
Call Charout filename

/*Defect 60489 - the following 3 lines have been modified to make NLS independent */

verp = pos('XR', syslevel)
version = substr(syslevel, verp+3, 4)
If version < '6050' Then Do
   Say 'The OS/2 Service Pack has not been installed in the 'riplroot
   Say 'directory.  Install the OS/2 Service Pack prior to running RPLSPDDI.'
   exit
end

/* Original RIPLINST install put the DISPLAY.DLL file in the wrong */
/* directory.  Copy the updated DISPLAY.DLL to the correct directory. */
cmdline = '@COPY 'riplroot'\OS2\INSTALL\DISPLAY.DLL' riplroot'\OS2\DLL\'
address CMD cmdline

Do disk = 1 to num_ds_diskettes
   Do forever
      Say 'Insert the OS/2 Service Pack Display Driver diskette 'disk' into drive 'drive'.'
      Say 'Press Enter to continue..'
      Beep(440, 250)
      Pull dummy
      /* set up filename match to check for correct diskette */
      Select
         when disk = 1 Then match = ds1_match
         when disk = 2 Then match = ds2_match
         otherwise;
      end
      filename = drive':\'match'.DSP'
      If chars(filename) <> 0 Then Do
         /* file exists, exit insert diskette loop */
         Call Charout filename  /* close file */
         Leave
      end
   end
   /* If ds1, create special XGA directory */
   If disk = 1 Then Call sysMkDir riplroot'\XGA$DMQS'

   Call Unpack_diskette
end

rplsetd_msg:
Say 'The OS/2 Service Pack Display Driver files have been installed in the '
Say 'Remote IPL directory tree.  Before any remote IPL workstations can be'
Say 'booted using the new display drivers, the rexx procedure RPLSETD.CMD'
Say 'must be used to update the remote IPL workstation definitions to use'
Say 'the new display drivers.'

exit
/* end main function */


Unpack_diskette:
/* create file containing list of files on diskette (and where they go) */
Say 'Please wait while the diskette is checked for installable files.'
tmpfile = SysTempFileName(RPLSPDDX.???)
cmdline = '@UNPACK 'drive':\ /SHOW > 'tmpfile
address CMD cmdline

Do While lines(tmpfile)
   data = translate(linein(tmpfile))
   if substr(data, 1, 2) = drive':' Then Do
      packedpfn = data
      packedfn = translate(filespec("name", data))
   end
   else If substr(data, 1, 2) = '->' Then Do
      tempdata = substr(data, 3)
      pathinfo = filespec("path", tempdata)
      tgtfilename = translate(filespec("name", tempdata))
      ibmdev32 = 0
      ibmvga32 = 0
      If tgtfilename = 'IBMDEV32.DLL' Then Do
         /* IBMDEV32.DLL is a special case.  A number of files get renamed */
         /* to IBMDEV32.DLL, we must preserve the original name. */
         Select
            When packedfn = 'SPEED480.DL_' Then ibmdev32 = 1
            When packedfn = 'TSENG480.DL_' Then ibmdev32 = 1
            When packedfn = 'TSENG600.DL_' Then ibmdev32 = 1
            When packedfn = 'TSENG768.DL_' Then ibmdev32 = 1
            Otherwise;
         end
      end
      else If tgtfilename = 'IBMVGA32.DLL' Then Do
         /* there are 2 versions of IBMVGA32.DLL, VGA type and SVGA type */
         /* handle SVGA type special */
         If packedfn = 'IBMSVGA.DL_' Then ibmvga32 = 1
      end
      If ibmdev32 = 1 | ibmvga32 = 1 Then Do
         /* special processing for duplicate IBMDEV32.DLL/IBMVGA32.DLL named files */
         originalname = substr(packedfn, 1, length(packedfn) - 1)||'L'

         /* delete original (if it exists) to prevent rename error */
         Call SysFileDelete riplroot || pathinfo || originalname

         If ibmdev32 = 1 Then Do
            /* set up IBMDEV32.DLL save/restore names */
            srcfn = riplroot || pathinfo'IBMDEV32.DLL'
            trgfn = ' IBMDEV32.BAK'
            srcfn2 = riplroot || pathinfo'IBMDEV32.BAK'
            trgfn2 = ' IBMDEV32.DLL'
         end
         else Do
            /* set up IBMVGA32.DLL save/restore names */
            srcfn = riplroot || pathinfo'IBMVGA32.DLL'
            trgfn = ' IBMVGA32.BAK'
            srcfn2 = riplroot || pathinfo'IBMVGA32.BAK'
            trgfn2 = ' IBMVGA32.DLL'
         end

         /* if duplicate name already exist, rename it temporarily */
         Call SysFileTree srcfn, 'filelst', 'F'
         If filelst.0 <> 0 Then Do
            /* rename existing version of IBMDEV32.DLL/IBMVGA32.DLL */
            cmdline = '@RENAME ' srcfn trgfn
            address CMD cmdline
            rename = 1
         end
         else rename = 0

         /* unpack file to IBMDEV32.DLL or IBMVGA32.DLL.  Unpack won't let */
         /* us rename on the fly so we have to do it after the fact. */
         Say 'Unpacking 'riplroot||pathinfo||originalname
         cmdline = '@UNPACK 'packedpfn'  'riplroot || pathinfo' /N:'tgtfilename'  > nul'
         address CMD cmdline

         /* rename IBMDEV32.DLL/IBMVGA32.DLL to it's packed name */
         cmdline = '@RENAME 'riplroot || pathinfo ||tgtfilename' 'originalname
         address CMD cmdline

         If rename = 1 Then Do
            /* rename IBMDEV32.BAK/IBMVGA32.BAK back to */
            /* IBMDEV32.DLL/IBMVGA32.DLL */
            cmdline = '@RENAME 'srcfn2 trgfn2
            address CMD cmdline
         end
      end
      else Do
         Say 'Unpacking 'riplroot||pathinfo||tgtfilename
         cmdline = '@UNPACK 'packedpfn'  'riplroot || pathinfo' /N:'tgtfilename'  > nul'
         address CMD cmdline
      end
      if chars() Then dummy = charin()
   end
end
Call Lineout tmpfile   /* close file */
Call SysFileDelete tmpfile
Say '  '
return



Syntax_Help:
   Say ' RPLSPDDI [/H]  [/D:drive_id]  [/O:OS2_root_directory]'
   Say ' '
   Say '     /H is a request for this syntax help information.  If specified,'
   Say '        it must be first and is the only parameter checked.'
   Say ' '
   Say '     /D:drive_id is the diskette drive id to use.  The default is A.'
   Say ' '
   Say '     /O:OS2_root_directory is the root Remote IPL directory in which'
   Say '                           the OS/2 2.0 code is installed.  If this'
   Say '                           parameter is not specified, the path saved'
   Say '                           in OS2SYS.INI by RIPLINST is used.'
   Say ' '
   exit
