unit	APIUNIT;
interface
{* Edit maxlength to allow up to 65K for buffer space *}

const	maxlength = 256;

type
	buffer = array[0..maxlength] of char;
	info_array = array[0..35] of integer;
	stat_array = array[0..21] of integer;
	ukey = record
		ukey_attr      : byte;
		ukey_lablen    : byte;
		ukey_deflen    : byte;
		ukey_reserved  : integer;
		ukey_text      : array[0..159] of char;
	end;
	ukeytype = ukey;
	softkey = record
		action	     : byte;
		label_length : byte;
		label_text   : array[0..7] of char;
		defn_length  : byte;
		defn_text    : array[0..79] of char;
	end;
	udk = record
		udk_length : byte;
		udk_text : array[0..254] of char;
	end;


function API_Rcheck						: integer;
function API_InstChk(var s:string )				: integer;
function API_Open						: integer;
function API_Close						: integer;
function API_GetInfo(i:integer; var x:info_array)		: integer;
function API_GetStatus(i:integer; var x:stat_array)		: integer;
function API_StartCommands					: integer;
function API_DoCommand(var x: string)				: integer;
function API_getvar(i:integer; var x:string)			: integer;
function API_setvar(i:integer; var x:string)			: integer;
function API_Found						: integer;
function API_EndCommands					: integer;
function API_ScreenRead(length,column,row:integer;var x:buffer) : integer;
function API_KeyStatus						: integer;
function API_QKeys(var keys:string)				: integer;
function API_ClrKeybd						: integer;
function API_CmdStatus						: integer;
function API_QCmd(var cmd:string)				: integer;
function API_ClrCmdQ						: integer;
function API_ReleaseDC						: integer;
function API_AssertDC						: integer;
function API_PopUP						: integer;
function API_Reset						: integer;
function API_GetFkey(k:integer; var fkey:ukeytype)		: integer;
function API_SetFkey(k:integer; var fkey:ukeytype)		: integer;
function API_OfferBuf(typ,buflen:integer;var x:buffer)		: integer;
function API_CancelBuf						: integer;
function API_Wait						: integer;
function API_Block						: integer;
function API_AtrbScreen(length,col,row:integer;var x:buffer)	: integer;
function API_SearchScreen(var col, row:integer;var x:string )	: integer;
function API_Rdchar(var x:integer)				: integer;
function API_Writeasync(c:integer )				: integer;
function API_Xmitstatus						: integer;
procedure RFreadkeybd(length:integer; var x:string );
function API_NdcPopup						: integer;
function API_SetGetIntState(state:integer)			: integer;
implementation
{$L P_APILIB}

function API_Rcheck;		external;
function API_InstChk;		external;
function API_Open;		external;
function API_Close;		external;
function API_GetInfo;		external;
function API_GetStatus;		external;
function API_StartCommands;	external;
function API_DoCommand;		external;
function API_getvar;		external;
function API_setvar;		external;
function API_Found;		external;
function API_EndCommands;	external;
function API_ScreenRead;	external;
function API_KeyStatus;		external;
function API_QKeys;		external;
function API_ClrKeybd;		external;
function API_CmdStatus;		external;
function API_QCmd;		external;
function API_ClrCmdQ;		external;
function API_ReleaseDC;		external;
function API_AssertDC;		external;
function API_PopUP;		external;
function API_Reset;		external;
function API_GetFkey;		external;
function API_SetFkey;		external;
function API_OfferBuf;		external;
function API_CancelBuf;		external;
function API_Wait;		external;
function API_Block;		external;
function API_AtrbScreen;	external;
function API_SearchScreen;	external;
function API_Rdchar;		external;
function API_Writeasync;	external;
function API_Xmitstatus;	external;
procedure RFreadkeybd;		external;
function API_NdcPopup;		external;
function API_SetGetIntState;	external;
end.
