/*
*
*		API.H	Copyright Walker Richer & Quinn  1989
*
*/
#define NoError				0
#define NotAvailable		256
#define OpenForSynch		257
#define ServiceNotOpen		258
#define IllegalFncCall		259
#define QueueFull			260
#define BadKey				261
#define BadLength			262
#define NotFound				265
#define BadVarNo				266
#define Uninstalled			-1


struct api_statstruc	{
   int	      apistat_pagetop_row;
   int	      apistat_cursor_row;
   int	      apistat_cursor_col;
   int	      apistat_left_border;
   int	      apistat_cursor_physrow;
   int	      apistat_cursor_physcol;
   int	      apistat_kb_lock_sw;
   int	      apistat_batch_flag;
   int	      apistat_datacomm_error_flag;	/* HP */
   int	      apistat_host_prompt_received;	/* HP */
   int	      apistat_xfer_pending_sw;		/* HP */
};
struct api_infostruc {
	int	      apiinfo_apiversion;
	int	      apiinfo_function_key_mode;
	int	      apiinfo_local_echo;
	int	      apiinfo_remote_mode;
	int	      apiinfo_caps_lock;
	int	      apiinfo_display_functions;
	int	      apiinfo_auto_linefeed;
	int	      apiinfo_right_margin;
	int	      apiinfo_phys_screen_width;
	int	      apiinfo_memory_response;	     /* HP */
	int	      apiinfo_xmit_functions;	     /* HP */
	int	      apiinfo_spow_strap;	     /* HP */
	int	      apiinfo_inheolwrp;	     /* HP */
	int	      apiinfo_line_page_mode;	     /* HP */
	int	      apiinfo_inhhndshk;	     /* HP */
	int	      apiinfo_inhdc2;		     /* HP */
	int	      apiinfo_block_mode;	     /* HP */
	int	      apiinfo_format_mode;	     /* HP */
	int	      apiinfo_memory_lock;	     /* HP */
	int	      apiinfo_type_ahead;	     /* HP */
	int	      apiinfo_normal_cursor_key_mode;/* DEC */
	int	      apiinfo_numeric_keypad_mode;   /* DEC */
	int	      apiinfo_multipage_mode;	     /* DEC */
	int	      apiinfo_user_features_locked;  /* DEC */
	int	      apiinfo_udks_locked;	     /* DEC */
};


/*
*
*HP Userkey label structure	 R1/R7
*
*/
struct	ukey	{
    char    unsigned   ukey_attr;   /* 0=normal, 1=local only, 2=transmit only*/
    char    unsigned   ukey_lablen; /* length of the label  */
    char    unsigned   ukey_deflen; /* length of the definition string */
    int		       ukey_reserved;
    char	    ukey_text[160]; /*label string followed by definition*/
};

/*
*
*DEC Softkey structure	   R2/R4
*
*
*/
struct softkey	{
	char	unsigned   action;	/* 0 = normal, 1 = local only */
	char	unsigned   label_length;
	char	label_text[8];
	char	unsigned   defn_length;
	char	defn_text[80];
};

/*
*
*DEC User Defined Key (UDK) structure	R2 / R4
*
*/
struct udk {
	char	unsigned	udk_length;
	char			udk_text[255];
};


/*	API Function Prototypes		*/



int	api_rcheck( void );
int	api_instchk(char *);
int	api_open( void );
int	api_close( void );
int	api_getinfo( struct api_infostruc *, int );
int	api_getstatus( struct api_statstruc *, int );
int	api_startcommands( void );
int	api_docommand( char * );
int	api_getvar( char *, int, int *);
int	api_setvar( char *, int, int );
int	api_found( void );
int	api_endcommands( void );
int	api_screenread( char *, int, int, int );
int	api_keystatus( void );
int	api_qkeys( char * );
int	api_clrkeybd ( void );
int	api_cmdstatus( void );
int	api_qcmd( char * );
int	api_clrcmdq( void );
int	api_releasedc( void );
int	api_assertdc( void );
int	api_popup( void );
int	api_reset( void );
int	api_getfkey( void * , int);
int	api_setfkey( void * , int);
int	api_offerbuf( char far *, int, int );
int	api_cancelbuf( void );
int	api_wait( void );
int	api_block( void );
int	api_searchscreen( char *, int * , int * );
int	api_rdchar( char * );
int	api_writeasync( int );
int	api_xmitstatus( void );
int	api_setgetintstate( int );
int	api_ndcpopup( void );
