/*
 * doapi.c  Send a command to reflection in background either queued or
 *          immediate.  Return error-code to DOS errorlevel
 *
 * Revision history - shipped with version 3.40 (plus only)
 *
 *          1.00     6/27/89  DI
 */
#include "api.h"
#include <string.h>
char    combuffer[160];
int  checkforapi( void );
main( int argc, char * argv[] )
{
	int     i;     
	int     type = '?';
	combuffer[0] =  '\0';
	if ( argc == 1 )
		usage();
	if( * argv[1] == '/' )
	{
		if (argc ==2 )
			usage();
		switch (toupper( *(argv[1]+1)))
		{
			case 'Q' :
				type = 'Q';
				break;
			case 'I' :
				type = 'I';
				break;
			default:
				usage();
		}
		for ( i = 2 ; i <= argc ; i++ )
		{
			strcat(combuffer, argv[i] );
			strcat(combuffer, " " );
		}
	}
	else              /* no method switch provided - default to I */
	{
		type = 'I';
		for ( i = 1 ; i <= argc ; i++ )
		{
			strcat(combuffer, argv[i] );
			strcat(combuffer, " " );
		}
	}
   if((i = checkforapi()) != 0 )
      exit(i);
   exit(process_api_command( combuffer, type ));
}

usage()
{
printf ("Usage:\n\n");
printf ("DOAPI  [/method] <Reflection command> [arg1, arg2, ... ]\n\n");
printf ("DOAPI passes a command to a background copy of Reflection for\n");
printf ("either Immediate (while you wait) or Queued (while you do    \n");
printf ("something else) processing. Reflection version 3.40 or above \n");
printf ("is Required.  Start Reflection from DOS with the /W switch to\n");
printf ("utilize this feature:                                        \n");
printf ("                                                             \n");
printf ("method = [I]mmediate (default) or [Q]ueued.                  \n");
printf ("                                                             \n");
printf ("Example DOAPI /Q SEND SALES.DOC TO MASTER.SALES ASCII        \n");
printf ("(queues send command for processing in background)           \n");
printf ("                                                             \n");
printf ("ERRORLEVEL                                                   \n");
printf ("   0     Command executed correctly or first in queue.       \n");
printf ("   1     Command put at end of queue (Queued command only).  \n");
printf ("   1-254 Normal error-code returned by Reflection command    \n");
printf ("         language.  See command language reference for cause.\n");
printf ("   255   Serious error encountered - queue full, Reflection  \n");
printf ("         not in terminal mode or usage error.                \n");
printf ("Note: Double quotes are removed from DOS command line.  Use  \n");
printf ("single quotes to pass quote marks to Reflection.\n");
	checkforapi();
   exit(255);
}



int checkforapi()
{
   char serialbuf[33];
   if (api_rcheck())
      {
         printf("     <<<<No Reflection Present in Background>>>>\n");
         return(255);
      }

   if (api_instchk( serialbuf ))
      {
 printf("<<<<Please restart Reflection with /W switch for API support>>>>\n");
         return(255);
      }
   return(0);
}
   



int process_api_command( char * buf, int type )
{
   int   i;
   if ( type == 'I' )
      {
      
         if (api_startcommands())
            {
            printf ("Reflection busy or not in terminal mode.\n");
            return(255);
            }
         if ((i=api_docommand( buf ))!= 0 )
            printf( "Error (%d) performing command.", i );
         api_endcommands();
         return(i);
      }
   else
      {
      i = api_block();
      if ( api_qcmd( buf ))
         {
         if (api_cmdstatus() > (strlen( buf )+1))
            printf("Error queuing command.\n");
         else
            printf("Queue Full\n");
         return(255);
         }
      if ( i )  /* If reflection already busy with something */
         {
         printf("Command placed at end of queue.\n");
         return(1);
         }
      }
}



      
