UNIT P3User;
{==========}


INTERFACE
{=======}

USES
   WinTypes;


   PROCEDURE SystemError (szErrorText : PChar); EXPORT;

   PROCEDURE SystemWarning (ErrorText : String);

   PROCEDURE DatabaseWarning (Warning : PChar); EXPORT;

   PROCEDURE CreateDisplayWindow (hOwner : HWnd; VAR hWindow : HWnd; szTitle : Pchar);

   PROCEDURE RunReport (hReport     : THandle;
                        hReportWnd,
                        hDisplayWnd : HWnd);


IMPLEMENTATION
{============}

USES
   DBTypes,
   DBProcs,
   RPTypes,
   RPProcs,
   Strings,
   WinProcs;

CONST
   IDB_NEXT  = 1;
   IDB_CLOSE = 2;

   RIBBON_HEIGHT   = 27;               {Pixel height of standard ribbons  }
   RBN_BTN_HEIGHT  = RIBBON_HEIGHT - 7; {Bottom line of buttons on ribbons}
   RBN_BTN_WIDTH   = 70;               {Width of normal button on ribbons }

   RPT_NEXTPAGE = WM_USER + 100;

VAR
   sz300 : Array [0..300] OF Char; {global - avoid large v'bles on the stack}

   hRibbonWnd,
   hDisplayWnd,
   hNextBtn,
   hCloseBtn     : Hwnd;
   PaintMode     : (Rpt_Page, Rpt_Refresh);
   FirstPaint,
   FirstPageDone : Boolean;

   RP_Pointer    : Pointer;
   cxChar,
   cyChar        : Integer;
   DB_WasOpen    : Boolean;

   hReportTemp   : THandle;
   hDisplayTemp  : HWnd;

{====================================================================}
PROCEDURE DatabaseWarning (Warning : PChar);
CONST
   CRLF = #13 + #10;

VAR
   szText  : PChar;
   memSize : Word;

BEGIN
   MessageBeep(0);

   memSize := StrLen (Warning) + 100;
   GetMem (szText, memSize);
   StrCopy (szText, 'Note - this warning is in USER.PAS. You can replace it with your own code.');
   StrCat (szText, CRLF);
   StrCat (szText, CRLF);
   StrCat (szText, Warning);

   MessageBox (0, szText, 'Database Warning', MB_OK or MB_TASKMODAL);
END;


{====================================================================}
PROCEDURE SystemError (szErrorText : PChar);
{*
 *  This procedure is called by a Phase3-generated program whenever a
 *  fatal error occurs that requires the program to terminate.
 *
 *  This procedure can be modified in any way as long as a system
 *  termination is executed at the end of the procedure.
 *}
BEGIN
   MessageBeep(0);
   MessageBox (0, szErrorText, 'System Error', MB_ICONSTOP or MB_TASKMODAL);
   Halt;
END;


{====================================================================}
PROCEDURE SystemWarning (ErrorText : String);
{*
 *  This procedure is called by a Phase3-generated program whenever a
 *  situation occurs that requires a warning to the user without halting the
 *  system.
 *
 *  This procedure can be modified in any way. 
 *}
BEGIN
   MessageBeep(0);
   StrPCopy (sz300, ErrorText);
   MessageBox (0, sz300, 'System Error', MB_ICONSTOP or MB_TASKMODAL);
END;


{==========================================================================}
FUNCTION ReportWndProc (hWindow   : HWnd;
                        wMessage,
                        wParam    : Word;
                        lParam    : Longint) : LONGINT; EXPORT;
{*
 *  This window proc handles the messages for the report preview display
 *  window.
 *}
CONST
   BtnWidth   = 60;
   BtnHeight  = 24;

   ID_NextBtn = 1;

VAR
   hReport   : THandle;
   hChildWnd,
   hNextBtn  : HWnd;
   rect      : TRect;
   x, y      : Integer;

BEGIN
   ReportWndProc := 0;

   CASE wMessage of

      WM_CREATE :
         BEGIN
         SetWindowWord (hWindow, 0, 0);
         SetWindowWord (hWindow, 2, 0);

         hNextBtn := CreateWindow(
            'BUTTON',
            'Next',
            WS_CHILD or WS_VISIBLE or WS_TABSTOP,
            0,0,0,0,
            hWindow,
            ID_NextBtn,
            hInstance,
            nil);
         SetWindowWord (hWindow, 4, hNextBtn);
         SetWindowWord (hWindow, 6, 0);   {first-time flag}
         Exit;
         END;

      WM_SIZE :
         BEGIN
         hChildWnd := GetWindowWord (hWindow, 0);
         IF hChildWnd <> 0 THEN
            BEGIN
            hReport := GetWindowWord (hWindow, 2);
            hNextBtn := GetWindowWord (hWindow, 4);
            GetClientRect (hWindow, rect);
            WITH rect DO
               BEGIN
               MoveWindow (hChildWnd, Left, Top, Right, Bottom - 30, TRUE);
               x := Left + 10;
               y := Bottom - 27;
               MoveWindow (hNextBtn,  x, y, BtnWidth, BtnHeight, TRUE);
               END;
            IF GetWindowWord (hWindow, 6) = 0 THEN
               BEGIN
               SendMessage (hWindow, WM_COMMAND, ID_NextBtn, 0);
               SetWindowWord (hWindow, 6, 1);
               END;
            END;
         Exit;
         END;

      WM_COMMAND :
         CASE wParam OF
            ID_NextBtn :
               BEGIN
               hReport := GetWindowWord (hWindow, 2);
               hNextBtn := GetWindowWord (hWindow, 4);
               RP_NextPage (hReport);
               IF RP_EndOfReport (hReport) THEN
                  EnableWindow (hNextBtn, FALSE);
               Exit;
               END;
            END;

      WM_DESTROY :
         BEGIN
         RP_DropTable (GetWindowWord (hWindow, 2));
         RP_CloseCatalog (GetWindowWord (hWindow, 2));
         RP_ExitDatabase (GetWindowWord (hWindow, 2));
         RP_Destroy (GetWindowWord (hWindow, 2));
         Exit;
         END;
      END;

   ReportWndProc := DefWindowProc(hWindow, wMessage, WParam, LParam);
END;


{====================================================================}
PROCEDURE CreateDisplayWindow (hOwner : HWnd; VAR hWindow : HWnd; szTitle : Pchar);
BEGIN
   hWindow := CreateWindow(
      'Report Screen Display Class',
      szTitle,
      WS_OVERLAPPED or WS_CAPTION or WS_BORDER or WS_THICKFRAME or WS_SYSMENU or
      WS_MINIMIZEBOX or WS_MAXIMIZEBOX ,
      0,0,0,0,
      hOwner,
      0,
      hInstance,
      nil);

   IF hWindow = 0 THEN
      SystemError ('Could not create report display window.');

END;


{====================================================================}
PROCEDURE RunReport (hReport     : THandle;
                     hReportWnd,
                     hDisplayWnd : HWnd);
VAR
   hOldCurs : hCursor;

BEGIN
   SetWindowWord (hReportWnd, 0, hDisplayWnd);
   SetWindowWord (hReportWnd, 2, hReport);

   IF RP_IsToPrinter (hReport) THEN
      BEGIN
      hOldCurs := SetCursor (LoadCursor (0, IDC_WAIT));
      WHILE RP_NextPage (hReport) DO
         BEGIN
         { nothing }
         END;            
      DestroyWindow (hReportWnd);
      SetCursor (hOldCurs);
      END
   ELSE   {* to screen *}
      BEGIN
      MoveWindow (hReportWnd, 50, 50, 500, 300, TRUE);
      ShowWindow (hReportWnd, SW_NORMAL);
      END;
END;


{=====================================================================}
PROCEDURE RegisterWindows;
VAR
   WinClass   : TWndClass;

BEGIN
   WinClass.style         := CS_HREDRAW or CS_VREDRAW;
   WinClass.lpfnWndProc   := @ReportWndProc;
   WinClass.cbClsExtra    := 0;
   WinClass.cbWndExtra    := 20;
   WinClass.hInstance     := hInstance;
   WinClass.hIcon         := 0;
   WinClass.hCursor       := 0;
   WinClass.hbrBackground := COLOR_WINDOW + 1;     {Use Windows colour }
   WinClass.lpszMenuName  := NIL;
   WinClass.lpszClassName := 'Report Screen Display Class';
   IF not RegisterClass (WinClass) THEN
      BEGIN
      SystemError ('Cannot register report display window.');
      Halt;
      END;
END;  {RegisterAPIWindows}





{ Unit Initialisation }
{=====================}

BEGIN
   RegisterWindows;
END.
