/* OS/2 Image Support Version 1.1                                            */
/* 49F4608  (C)Copyright IBM Corporation. 1990                               */
/* Licensed Material - Program Property of IBM.                              */
/*                                                                           */
/*                                                                           */
/* Sample REXX program to show how to close OIS-REXX interface and drop      */
/* OIS-REXX functions from Application Functions Table (AFT).                */
/*                                                                           */
/* Command syntax:                                                           */
/*                                                                           */
/*    RXCLOS                                                                 */
/*                                                                           */
/*                                                                           */
/* Purpose: Closes OIS-REXX queue and the interface. Drops OIS-REXX          */
/*          functions registered in the Application Functions Table (AFT).   */
/*                                                                           */

signal on error
signal on failure
signal on halt

/* To finish up processing, you should call OisEnd to terminate              */
/* OISRXLNK, tidy up resources, and then un-register the                     */
/* OIS functions.                                                            */
say 'start'
start OISRXLNK.EXE

say 'register funcs'
rc=Rxfuncdrop('OISOPEN')
If Rxfuncquery('OISOPEN') = 1 Then
   rcy = Rxfuncadd('OISOPEN', 'OISRX', 'OisOpen')

rc=Rxfuncdrop('OISSAVEAS')
If Rxfuncquery('OISSAVEAS') = 1 Then
   rcy = Rxfuncadd('OISSAVEAS', 'OISRX', 'OisSaveAs')

rc=Rxfuncdrop('OISCLOSE')
If Rxfuncquery('OISCLOSE') = 1 Then
   rcy = Rxfuncadd('OISCLOSE', 'OISRX', 'OisClose')

rc=Rxfuncdrop('OISTEST')
If Rxfuncquery('OISTEST') = 1 Then
   rcy = Rxfuncadd('OISTEST', 'OISRX', 'OisTest')

rc=Rxfuncdrop('OISBEGIN')
If Rxfuncquery('OISBEGIN') = 1 Then
   rcy = Rxfuncadd('OISBEGIN', 'OISRX', 'OisBegin')

rc=Rxfuncdrop('OISEND')
If Rxfuncquery('OISEND') = 1 Then
   rcy = Rxfuncadd('OISEND', 'OISRX', 'OisEnd')

rc=Rxfuncdrop('OISQUERY')
If Rxfuncquery('OISQUERY') = 1 Then
   rcy = Rxfuncadd('OISQUERY', 'OISRX', 'OisQuery')

rc=Rxfuncdrop('OISSETCREATIONVISIBILITY')
If Rxfuncquery('OISSETCREATIONVISIBILITY') = 1 Then
   rcy = Rxfuncadd('OISSETCREATIONVISIBILITY', 'OISRX', 'OisSetCreationVisibility')


say     'Waiting for OISRXLNK application.'

CALL OISBEGIN '10'
if result = 0 then
   say     'OIS-REXX queue is operational.'
else do
   say     'Fail to start OIS-REXX queue. Can not continue.'
   call 'RXCLOS.CMD'
   exit 10
end

/* Test the communication path with the next call.                           */

CALL OISTEST
if result = 0  then
   say     'Test was successful.'
else do
   say     'Fail to start OIS-REXX queue. Can not continue.'
   call 'RXCLOS.CMD'
   exit 10
end

call OisSetCreationVisibility off
if result = 0 then
   say     'Visibility turned off successfully.'

say 'open test.mdi'
call OisOpen 'c:\test.mdi'
select
   when result = 0 then
      say     'Image opened successfully.'
   when result = 1 then do
      say     'Image is a document, so let us open first image.'
      CALL OISQUERY 'names.'
      if names.0 > 0 then do
         say 'The document contains 'names.0' images.'
         do imgnum = 1 to names.0
            CALL OISOPEN imgnum
            if result = 0 then
               say     'First image of the document opened successfully.'
            else call cleanup
            LEAVE    /*  Forcing leave after opening first image, as this do    */
                     /*  loop is only for showing you how to open all images    */
                     /*  from a document.                                       */
         end /*  end for  */
      end
      else do
         say 'No images in the document. Terminating the program.'
         call cleanup
      end  /*  endif  */
   end
   otherwise do
      say 'Fail to open input image file.'
      call cleanup
   end
end   /*  end select  */

say 'save pcx'
call OisSaveAs 'c:\image.pcx', PCX, off
if result = 0 then
   say     'Saved the processed image successfully.'

call cleanup
exit




cleanup: procedure

call OisClose
if result = 0 then
   say     'closed the processed image successfully.'

call    oisend

exit
