/* This file is RSX.C
** contains :
**
**      - get options
**      - switch protected mode
**      - check copro, install emu
**      - load first a.out prg
**
** Copyright (c) Rainer Schnitker '92 '93
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <ctype.h>
#include "DPMI.H"
#include "DPMIDOS.H"
#include "PROCESS.H"
#include "START32.H"
#include "LOADPRG.H"
#include "FPU.H"
#include "RSX.H"
#include "DOSERRNO.H"

char version[] = "RSX dpmi-extender v0.71 (c) Rainer Schnitker '93 '94";

/* command-line options */
char copro = 1;			/* prg need 387 : 0=no 1=yes 3=emulate */
char opt_printall = 0;		/* show all information */
char opt_print_syscalls = 0;	/* show every sys_call */
char opt_memaccess = 0;		/* allows memaccess */
char opt_stack = 0;		/* allow stack touch bss */
char opt_version = 0;		/* print rsx version */
char rsx387_in_dosmem = 1;	/* rsx387 in dos memory */
int opt_stackval = 0;		/* stack size in KB */
char opt_allow = 0;		/* allow execute stack */

int kread;			/* keyboard read */
int kready;			/* keyboard check */
char **org_env;			/* org. environment to rsx */
int org_envc;			/* org. env items */
WORD emu_sel = 0;		/* emu data-sel */
DWORD copro_struct;		/* address of soft-387 struct */
POINTER16_32 emu_entry;		/* entry address emu (for init) */

/* load emu & init */
static int emu387(char *filename)
{
    puts("load rsx387");

    if (load_protected_program(filename, npz))
	return -1;

    /* init some emu vars for long-jmp, emu data selector access */
    emu_sel = npz->data32sel;
    emu_entry.off = npz->entry;
    emu_entry.sel = npz->code32sel;

    LockLinRegion(npz->memaddress, npz->membytes);

    /* emu_init call emulator to install exception handler */
    copro_struct = emu_init();
    /* return the 387-register struct, need for switching prgs */

    return 0;
}

static int emxl_psp = 0;
static char cline[128];

/* convert PSP to command line */
static void get_emxl_psp(void)
{
    int z, env_seg;
    char far *cmdl;

    /* get envoronment segment from PSP */
    env_seg = *(int far *) ((DWORD) emxl_psp << 16 | 0x2c);

    /* build far pointer to environment */
    cmdl = (char far *) ((DWORD) env_seg << 16);

    /* skip env-strings ; last have to 0-bytes */
    for (; cmdl++;)
	if (*cmdl == '\0' && *(cmdl + 1) == '\0')
	    break;

    cmdl += 4;
    /* copy arg0 */
    for (z = 0; *cmdl != '\0'; cmdl++, z++)
	cline[z] = *cmdl;
    cline[z++] = ' ';

    /* build cmdline far pointer from PSP */
    cmdl = (char far *) ((DWORD) emxl_psp << 16 | 0x81);

    /* copy arg1,arg2,... */
    for (;; cmdl++, z++) {
	cline[z] = *cmdl;
	if (cline[z] == 13)
	    break;
    }
    cline[z] = '\0';
}

/* get one options for rsx */
/* return last read char pos, if successful */
static char *scan_for_option(char *s)
{
    int z;

    switch (*s) {
    case 'a':			/* DOS features */
	for (++s; *s > ' '; ++s) {
	    if (*s == 'm')
		opt_memaccess = 1;
	    else if (*s == 'c')
		opt_allow = 1;
	    else if (*s == 's')
		opt_stack = 1;
	    else if (*s == 'i' || *s == 'w')
		continue;
	    else
		return NULL;
	}
	if (*(--s) == 'a')
	    return NULL;
	else
	    break;

    case 'c':			/* core */
	break;

    case 'e':			/* assume no 387 used */
	copro = 0;
	break;

    case 's':			/* stack size */
	if (!isdigit(*(++s)))
	    return NULL;
	sscanf(s, "%d%n", &opt_stackval, &z);
	return s + z;

    case 'o':			/* print messages to stdout */
	break;

    case 'p':                   /* don't use lower DOS mem (for rsx387) */
	rsx387_in_dosmem = 0;
	break;

    case 'V':                   /* version print */
	opt_version = 1;
	break;

    case 'P':			/* print syscalls */
	opt_printall = 1;
	break;

    case 'I':			/* print syscalls */
	opt_print_syscalls = 1;
	break;

    case '/':			/* emx0.8g command line */
	if (*(s + 5) != '/') {
	    printf("error: not a valid PSP option -/xxxx/\n");
	    return NULL;
	} else
	    *(s + 5) = '\0';
	sscanf(++s, "%X", &emxl_psp);
	get_emxl_psp();

	s += 5;
	break;

    default:
	return NULL;
    }

    return s;
}

static void get_keyboard_type(void)
{
    if ((*(unsigned char _far *) 0x00400096) & 0x10) {
	kread = 0x10;		/* services for enhanced keyboards */
	kready = 0x11;
    } else {
	kread = 0;		/* services for other keyboards */
	kready = 1;
    }
}

#ifdef __TURBOC__

int _bios_keybrd(int mode)
{
    _AH = (char) mode;
    asm mov dl, ah;
    asm and dl, 0x0F;
    asm int 0x16;
    asm jne L1;
    asm cmp dl, 0x01;
    asm jne L1;
    asm xor ax, ax;
    asm jmp L2;
  L1:
    asm cmp dl, 0x02;
    asm je L2;
    asm or ax, ax;
    asm jne L2;
    asm dec ax;
  L2:
    return _AX;
}

unsigned int _stklen = 8192;

#endif

static char *argvec[50];
static char rsx387_default[] = "\\RSX\\FPU-EMU\\RSX387";

void main(int argc, char **argv, char **env)
{
    int i;
    char *s;
    static char *emu_name;
    static char exefile[128];

    /* save environment, env-size */
    for (org_envc = 0; env[org_envc] != NULL; org_envc++);
    org_env = env;

    /* get enviroment options */
    s = getenv("RSXOPT");
    if (s != NULL) {
	for (; *s != '\0'; ++s) {
	    while (*s == ' ')
		++s;
	    if (*s == '-') {
		s = scan_for_option(++s);
		if (s == NULL) {
		    puts("error in RSXOPT");
		    exit(1);
		}
	    } else
		break;
	}
    }
    for (i = 1; i < argc; i++) {
	s = argv[i];
	if (*s == '-') {
	    s = scan_for_option(++s);
	    if (s == NULL) {
		printf("bad option: %s\n", argv[i]);
		exit(1);
	    }
	} else
	    break;
    }

    /* commandline from psp */
    if (emxl_psp != 0) {
	/* make command string to argv */
	argvec[0] = cline;
	argc = 1;
	for (i = 0; cline[i] != 0; i++)
	    if (cline[i] == ' ') {
		cline[i] = 0;
		if (cline[i + 1] == ' ')
		    continue;
		if (cline[i + 1] == 0)
		    break;
		argvec[argc++] = cline + i + 1;
	    }
	argvec[argc] = 0;
	i = 0;
	argv = &(argvec[0]);
    }

    if (argc > 1 && strcmp(argv[1], "!proxy") == 0) {
	int segm, off;
	int far *old_argv;
	char far *old_argi;
	sscanf(argv[2], "%x", &argc);
	sscanf(argv[3], "%x", &segm);
	sscanf(argv[4], "%x", &off);
	old_argv = (int far *) MK_FP(segm, off);
	argvec[0] = cline;
	for (i = 0; i < argc; i++) {
	    old_argi = (char far *) MK_FP(segm, (old_argv[i]));
	    _fstrcpy((char far *) (argvec[i]), old_argi);
	    argvec[i + 1] = argvec[i] + (strlen(argvec[i]) + 1);
	}
	argvec[argc] = 0;
	argv = &(argvec[0]);
	i = 0;
	emxl_psp = 1;		/* dont't print version */
    }

    /* print version, if rsx running from prompt */
    if (emxl_psp == 0 || opt_version == 1)
	puts(version);

    /* check filename */
    if (argc <= i) {
	WORD DPMIflags, DPMIversion;
	BYTE cpu;
	DWORD lP;
	WORD wP;
	if (!GetDpmiEntryPoint(&lP, &wP, &DPMIflags, &DPMIversion, &cpu))
	    printf("running under DPMI %d,%d\n", DPMIversion >> 8, DPMIversion & 0xff);
	puts("no filename defined");
	exit(1);
    }
    strcpy(exefile, argv[i]);
    if (access(exefile, 0) < 0) {
	strcat(exefile, ".exe");
	if (access(exefile, 0) < 0) {
	    printf("file not found: %s\n", argv[i]);
	    exit(1);
	}
    }
    get_keyboard_type();
    if (!getenv("TZ"))
	putenv("TZ=GMT+0MEZ");

    /* copro required, 387 there ? */
    if (copro && !npx_installed()) {
	copro = 3;
	emu_name = getenv("RSX387");
	if (emu_name == NULL) {
	    if (access(rsx387_default, 0)) {
		puts("Can't find RSX387");
		exit(2);
	    }
	    else
		emu_name = rsx387_default;
	}
    }
    fflush(stdin);
    fflush(stdout);
    _fmode = O_BINARY;

    if (real_to_protected(1))
	exit(1);

    /* now protected mode! */

    if (hangin_extender()) {
	puts("ERROR: can't hang in extensions");
	protected_to_real(1);
    }
    /* init process-tables */
    init_this_process();

    /* hang in emulation */
    if (copro == 3) {
	if (emu387(emu_name) == -1) {
	    printf("Can't load emu: %s\n", emu_name);
	    shut_down(2);
	}
    }
    i = exec32(P_WAIT, exefile, argc - i, argv + i, org_envc, org_env);

    if (i == EMX_ENOEXEC)
	printf("%s: not a valid a.out format\n",exefile);
    else
	puts(strerror(i));

    shut_down(1);
    /* never reached */
}
