/* This file is MEMORY.C
**
** demo allocating memory in the DPMI-enviroment
*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "DPMI.H"
#include "START16.H"

typedef struct node {
		unsigned long 	num;
        void far        *data ;
		struct node far	*next ;
		} NODE ;


void protected_program()
{
    FREEMEMINFO free;
    NODE far *p,far *q;
    unsigned long allocsize,nodes=0;
    unsigned long nodesize ;
    time_t t1,t2;
    int s;

    GetFreeMemInfo(&free);
    printf("\n");
    PrintFreeMemInfo(&free);

	printf("Set NodeSize (try 4092) : ");
    scanf("%lu",&nodesize);

    printf("\n 0=all  1=XMS  2=LOCKED memory\n");
    printf("Set stategy (0,1,2) : ");
    scanf("%i",&s);

    if (s>=2) s=2;
    set_memory_type(s);

    allocsize=nodesize+sizeof(NODE);

    time(&t1);

	for (q= NULL ;;q->next =p) {
        p=q ;
        if ((q=extmalloc(sizeof(NODE)))== NULL)
            break;
        if ((q->data=extmalloc((DWORD)nodesize))==NULL) {
            extfree(q);
            break;
            }
        q->num=nodes++;
        }

    printf("\n%lu nodes ; %lu seconds\n",nodes,time(&t2)-t1);
    printf("Allocated %lu KB\n", nodes * allocsize >> 10 );

    GetFreeMemInfo(&free);
    printf("\n");
    PrintFreeMemInfo(&free);

    printf("\nFree descriptor..\n");

    time(&t1);
    for (;p!=NULL; p=q) {
        q=p->next;
        if (p->num != --nodes) {
            printf("list corrupt: nodes=%lu num=%lu\n",nodes,p->num);
            return;
            }
        extfree(p->data);
        extfree(p);
        }
    time(&t2);
    printf("..end\n");
    printf("%lu seconds\n",t2-t1);
}

void main()
{
    if (real_to_protected(0))
        exit(1);
    if (hangin_extender()) {
        fprintf(stderr,"ERROR: can't hang in extensions\n");
        protected_to_real(1);
        }
    protected_program();
    protected_to_real(0);
}
