#include <stdio.h>
#include "DPMI.H"
#include "DPMI10.H"
#include "START16.H"

void protected_program()
{
    FREEMEMINFO freeinfo;
    DPMICAP cap;
    char hostbuf[128];
    int i;

    printf("DPMI 0.9 INFO\n");
    GetFreeMemInfo(&freeinfo);
    PrintFreeMemInfo(&freeinfo);

    if (!GetDPMICapabilities(&cap, hostbuf)) {
	printf("host %s %d,%d\n", hostbuf+2, hostbuf[0], hostbuf[1]);
	for (i=0;i<=6;++i)
	    printf("bit %d = %d \n", i, (cap.bits & (1<<i)) ? 1 : 0);
    }
}

void main(int argc)
{
    if (real_to_protected(0))
        exit(1);
    if (hangin_extender()) {
        fprintf(stderr,"ERROR: can't hang in extensions\n");
        protected_to_real(1);
        }
    protected_program();
    protected_to_real(0);
}
