/*****************************************************************************
** ORDER.PRG
**
** ProVision:Windows v1.20 Order form sample
**
** by J. David Reynolds
**
** I apologize for the terrible code block abuse contained herein.  This was
** a fairly quick (< 1 day) example of a complex entry form.
**
** Many features still need to be added, such as integration with a customer
** file and accounting system, lookup of states and counties, and save and
** print capability.  However, this program may give you some ideas about
** entry forms in an event-driven environment.
**
** Compile with:  CLIPPER order /n /w
**
** Link with:     RTLINK FI order SEA pwfuncs LIB pwkernel
**                BLINKER FI order SEA pwfuncs LIB pwkernel /q
**                WARPLINK order,,,pwfuncs pwkernel
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"
#include "setcurs.ch"


#define PROD_NONE                      0
#define PROD_OV                        1
#define PROD_OVUP                      2
#define PROD_PP                        3
#define PROD_PPUP                      4
#define PROD_PV                        5
#define PROD_PVUP                      6

#define SHIPVIA_LEN                    10


STATIC   aDemo[6], ; // array of checkboxes (only in elements 1, 3, and 5)
         aEach[6], ; // array of textfields for price each
         aProd[6]    // array of textfields for qty

STATIC   aZones   := {  { "AUSTRALIA",          927, 627 }, ;  // UPS zone numbers
                        { "AUSTRIA",            924, 624 }, ;
                        { "BELGIUM",            921, 621 }, ;
                        { "BRAZIL",             930, 0 }, ;
                        { "CZECHOSLOVAKIA",     931, 0 }, ;
                        { "DENMARK",            926, 626 }, ;
                        { "ENGLAND",            921, 621 }, ;
                        { "FINLAND",            926, 626 }, ;
                        { "FRANCE",             925, 625 }, ;
                        { "GERMANY",            921, 621 }, ;
                        { "HONG KONG",          923, 622 }, ;
                        { "IRELAND",            926, 623 }, ;
                        { "ISRAEL",             930, 0 }, ;
                        { "ITALY",              925, 625 }, ;
                        { "JAMAICA",            928, 0 }, ;
                        { "JAPAN",              927, 627 }, ;
                        { "MALAYSIA",           927, 627 }, ;
                        { "MEXICO",             924, 0 }, ;
                        { "NETHERLANDS",        921, 621 }, ;
                        { "NEW ZEALAND",        931, 0 }, ;
                        { "NORTHERN IRELAND",   925, 625 }, ;
                        { "NORWAY",             926, 626 }, ;
                        { "POLAND",             931, 0 }, ;
                        { "PORTUGAL",           930, 0 }, ;
                        { "SCOTLAND",           925, 625 }, ;
                        { "SOUTH AFRICA",       932, 0 }, ;
                        { "SPAIN",              926, 626 }, ;
                        { "SWEDEN",             926, 626 }, ;
                        { "SWITZERLAND",        926, 626 }, ;
                        { "TAIWAN",             927, 627 }, ;
                        { "UNIFIED SOVIET",     931, 0 }, ;
                        { "WALES",              925, 625 }, ;
                        { "YUGOSLAVIA",         932, 0 } }, ;
         aRates   := {  { 621, 46.00 }, ; // UPS rates for zones
                        { 622, 46.00 }, ;
                        { 623, 46.00 }, ;
                        { 624, 50.00 }, ;
                        { 625, 50.00 }, ;
                        { 626, 73.00 }, ;
                        { 627, 73.00 }, ;
                        { 921, 51.00 }, ;
                        { 922, 51.00 }, ;
                        { 923, 51.00 }, ;
                        { 924, 56.00 }, ;
                        { 925, 56.00 }, ;
                        { 926, 81.00 }, ;
                        { 927, 81.00 }, ;
                        { 928, 51.00 }, ;
                        { 929, 56.00 }, ;
                        { 930, 73.00 }, ;
                        { 931, 85.00 }, ;
                        { 932, 108.00 } }

STATIC   nTaxRate := 0.00  // sales tax rate

STATIC   oCardDate, ;      // expiration date of credit card
         oCardName, ;      // name on credit card
         oCardNo, ;        // credit card account number
         oCountry, ;       // country
         oManual, ;        // checkbox for ProPick upgrade manual
         oOVforC, ;        // checkbox for OverView for C
         oOVUPforC, ;      // checkbox for OverView for C upgrade
         oPayment, ;       // payment method
         oRef, ;           // "How did you hear about...?"
         oRefOther, ;      // other field for oRef
         oShip, ;          // Ship via...
         oShipCharge, ;    // shipping charge
         oShipOther, ;     // other field for oShip
         oState, ;         // state or province
         oWnd              // the main window



/*****************************************************************************
** Main( cParam1, cParam2 ) --> NIL
**
** initializes ProVision:Windows, draws wallpaper, calls the main window,
** activates, then deinitializes; allows command line params of:
**    /43   switch to 43-line mode on EGA or VGA
**    /50   switch to 50-line mode on VGA
**    /STD  use standard (non-TMR) mode
**
*****************************************************************************/
FUNCTION Main( cParam1, cParam2 )

   LOCAL xMouseCursor


   // Validate the command line parameters, if any.
   IIF(cParam1 == NIL, cParam1 := "", )
   IIF(cParam2 == NIL, cParam2 := "", )
   cParam1  := UPPER(cParam1 + cParam2)

   // Switch video modes if requested and supported.
   IF "/43" $ cParam1
      SETMODE(43, 80)
   END IF // "/43" $ cParam1
   IF "/50" $ cParam1
      SETMODE(50, 80)
   END IF // "/50" $ cParam1

   // Init ProVision:Windows.
   IF "/STD" $ cParam1
      INIT WINDOWS ;
         STANDARD MOUSE ;
         STANDARD BORDERS ;
         STANDARD CONTROLS ;
         SETBLINK .T.
   ELSE
      INIT WINDOWS ;
         GRAPHIC MOUSE ;
         GRAPHIC BORDERS ;
         GRAPHIC CONTROLS
   END IF // "/STD" $ cParam1

   IF pw():isTMR(PWTMR_BORDERS)
      // Load new wallpaper.
      IF (pwMaxRow() == 42) .OR. (pwMaxRow() == 49)
         pw():wallpaper(PWWP_GRID, "W/*N")
      ELSE
         pw():wallpaper(PWWP_RINGS, IIF(ISCOLOR(), "W/*N", "W/N"))
      END IF // (pwMaxRow() == 42) .OR. (pwMaxRow() == 49)
   ELSE
      // Clear the screen.
      SETCOLOR("+W/N")
      CLEAR SCREEN
   END IF // pw():isTMR(PWTMR_BORDERS)

   // change mouse cursor to an hourglass
   xMouseCursor   := pw():mouseCursor(PMCURSOR_HOUR)

   // Open the main window.
   OrderWnd()

   // get rid of the hourglass
   pw():mouseCursor(xMouseCursor)

   // what it says
   ACTIVATE WINDOWS

   // deinit the system
   DEINIT WINDOWS

   RETURN(NIL)
   // END Main( cParam1, cParam2 )



/*****************************************************************************
** STATIC OrderWnd() --> oWnd
**
** creates and opens the main window
**
*****************************************************************************/
STATIC FUNCTION OrderWnd()

   LOCAL GetList  := {}

   LOCAL oMenu, ;
         oOK


   IF oWnd == NIL

      // create the window
      CREATE WINDOW oWnd ;
         AT 00, 00 ;
         SIZE MIN(40, pwMaxRow() + 1), 64 ;
         VIRTUAL SIZE MAX(37, pwMaxRow() - 2), MAX(61, pwMaxCol() - ;
            IIF(pwMaxRow() > 40, 3, 2)) ;
         STYLE PWSTYLE_PRIMARY ;
         TITLE "Order Form" ;
         WINDOW HANDLER { | idMsg, xParam1, xParam2, xParam3 | ;
            OrderWndHandler(idMsg, xParam1, xParam2, xParam3) }

      // turn on autoscrolling and hotscrolling
      oWnd:autoScroll(.T.)
      oWnd:hotScroll(.T.)

      // create the controls

      @ 01, 02 GET AS TEXTFIELD ;
         PROMPT "Order date: " ;
         INITIAL DATE()

      @ 01, 24 GET AS TEXTFIELD ;
         PROMPT "by: " ;
         PICTURE "@!" ;
         INITIAL "   "

      @ 01, 43 GET AS TEXTFIELD ;
         PROMPT "Order #: " ;
         PICTURE "9999999" ;
         INITIAL 0

      DISPBOX(02, 01, 10, 59)
      @ 02, 02 SAY " Customer "

      @ 03, 03 GET AS TEXTFIELD ;
         PROMPT "         Name: " ;
         INITIAL SPACE(40)

      @ 04, 03 GET AS TEXTFIELD ;
         PROMPT "      Company: " ;
         INITIAL SPACE(40)

      @ 05, 03 GET AS TEXTFIELD ;
         PROMPT "      Address: " ;
         INITIAL SPACE(40)

      @ 06, 03 GET AS TEXTFIELD ;
         PROMPT "      Address: " ;
         INITIAL SPACE(40)

      @ 07, 03 GET AS TEXTFIELD ;
         PROMPT "         City: " ;
         INITIAL SPACE(15)

      @ 07, 34 GET AS TEXTFIELD oState ;
         PROMPT "ST/Prov: " ;
         PICTURE "@!" ;
         INITIAL SPACE(15) ;
         VALID { || IIF(LEFT(oState:getValue(), 2) == "TX", ;
            nTaxRate := 0.0825, nTaxRate := 0.00), ;
            PriceCalc(PROD_NONE) }

      @ 08, 03 GET AS TEXTFIELD ;
         PROMPT "Zip/Post code: " ;
         INITIAL SPACE(15)

      @ 08, 34 GET AS TEXTFIELD oCountry ;
         PROMPT "Country: " ;
         PICTURE "@!" ;
         INITIAL SPACE(15) ;
         VALID { || ;
            IIF("CANADA" $ oCountry:getValue(), oShip:setValue(4), ), ;
            IIF((.NOT. EMPTY(oCountry:getValue())) .AND. ;
               (ASCAN(aZones, { | e | LEFT(e[1], ;
               LEN(ALLTRIM(oCountry:getValue()))) == ;
               ALLTRIM(oCountry:getValue()) }) != 0), oShip:setValue(7), ), ;
            IIF(.NOT. EMPTY(oCountry:getValue()), PriceCalc(PROD_NONE), ), ;
            .T. }

      @ 09, 03 GET AS TEXTFIELD ;
         PROMPT "        Phone: " ;
         INITIAL SPACE(15)

      @ 11, 02 GET AS COMBOBOX oRef ;
         PROMPT ABOVE "Reference:" ;
         USING {  "Magazine ad", ;
                  "Magazine review", ;
                  "Users' Group", ;
                  "Other" } ;
         ACTION { || IIF(oRef:getValue() == 4, ;
            oRefOther:enable(), oRefOther:disable()) }

      @ 13, 02 GET AS TEXTFIELD oRefOther ;
         INITIAL SPACE(24)
      oRefOther:disable()

      @ 11, 32 GET AS COMBOBOX oShip ;
         PROMPT ABOVE "Ship via:" ;
         USING {  "UPS ground USA", ;
                  "UPS blue USA", ;
                  "UPS red USA", ;
                  "US Mail Canada", ;
                  "UPS ground Canada", ;
                  "Fed Ex Canada", ;
                  "Air Mail Int'l", ;
                  "UPS Int'l 1 week", ;
                  "UPS Int'l 2-3 day", ;
                  "Other" } ;
         VALID { || PriceCalc(PROD_NONE) } ;
         ACTION { || IIF(oShip:getValue() == SHIPVIA_LEN, ;
            oShipOther:enable(), oShipOther:disable()) }

      @ 13, 32 GET AS TEXTFIELD oShipOther ;
         INITIAL SPACE(24)
      oShipOther:disable()

//                           1           2       3         4         5
//                  12345678901234567890123456789012345678901234567890123456789
      @ 14, 01 SAY "Ŀ"
      @ 15, 01 SAY "QtyDemoDescription                $ Ea  Extended $   "
      @ 16, 01 SAY "Ĵ"
      @ 17, 01 SAY "       OverView (DOS)                                "
      @ 18, 01 SAY "       OverView upgr.                                "
      @ 19, 01 SAY "       ProPick (DOS)                                 "
      @ 20, 01 SAY "       ProPick upgr.                                 "
      @ 21, 01 SAY "       ProVender (Win)                               "
      @ 22, 01 SAY "       ProVender upgr.                               "
      @ 23, 01 SAY "Ĵ"
      @ 24, 01 SAY "                                   Subtotal              "
      @ 25, 01 SAY "                                  Sales tax              "
      @ 26, 01 SAY "                            Shipping charge              "
      @ 27, 01 SAY "                                           Ĵ"
      @ 28, 01 SAY "                                      Total              "
      @ 29, 01 SAY "                                           "

      @ 17, 02 GET AS TEXTFIELD aProd[PROD_OV] ;
         PICTURE "999" ;
         VALID { || PriceCalc(PROD_OV) }
      @ 17, 07 GET AS CHECKBOX aDemo[PROD_OV] ;
         ACTION { || aProd[PROD_OV]:setValue(1), PriceCalc(PROD_OV) }
      @ 17, 27 GET AS CHECKBOX oOVforC ;
         PROMPT "for 'C'"
      oOVforC:disable()
      @ 17, 38 GET AS TEXTFIELD aEach[PROD_OV] ;
         PICTURE "999.99" ;
         VALID { || PriceCalc(PROD_NONE) }
      aEach[PROD_OV]:disable()

      @ 18, 02 GET AS TEXTFIELD aProd[PROD_OVUP] ;
         PICTURE "999" ;
         VALID { || PriceCalc(PROD_OVUP) }
      @ 18, 27 GET AS CHECKBOX oOVUPforC ;
         PROMPT "for 'C'"
      oOVUPforC:disable()
      @ 18, 38 GET AS TEXTFIELD aEach[PROD_OVUP] ;
         PICTURE "999.99" ;
         VALID { || PriceCalc(PROD_NONE) }
      aEach[PROD_OVUP]:disable()

      @ 19, 02 GET AS TEXTFIELD aProd[PROD_PP] ;
         PICTURE "999" ;
         VALID { || PriceCalc(PROD_PP) }
      @ 19, 07 GET AS CHECKBOX aDemo[PROD_PP] ;
         ACTION { || aProd[PROD_PP]:setValue(1), PriceCalc(PROD_PP) }
      @ 19, 38 GET AS TEXTFIELD aEach[PROD_PP] ;
         PICTURE "999.99" ;
         VALID { || PriceCalc(PROD_NONE) }
      aEach[PROD_PP]:disable()

      @ 20, 02 GET AS TEXTFIELD aProd[PROD_PPUP] ;
         PICTURE "999" ;
         VALID { || PriceCalc(PROD_PPUP) }
      @ 20, 27 GET AS CHECKBOX oManual ;
         PROMPT "manual"
      oManual:disable()
      @ 20, 38 GET AS TEXTFIELD aEach[PROD_PPUP] ;
         PICTURE "999.99" ;
         VALID { || PriceCalc(PROD_NONE) }
      aEach[PROD_PPUP]:disable()

      @ 21, 02 GET AS TEXTFIELD aProd[PROD_PV] ;
         PICTURE "999" ;
         VALID { || PriceCalc(PROD_PV) }
      @ 21, 07 GET AS CHECKBOX aDemo[PROD_PV] ;
         ACTION { || aProd[PROD_PV]:setValue(1), PriceCalc(PROD_PV) }
      @ 21, 38 GET AS TEXTFIELD aEach[PROD_PV] ;
         PICTURE "999.99" ;
         VALID { || PriceCalc(PROD_NONE) }
      aEach[PROD_PV]:disable()

      @ 22, 02 GET AS TEXTFIELD aProd[PROD_PVUP] ;
         PICTURE "999" ;
         VALID { || PriceCalc(PROD_PVUP) }
      @ 22, 38 GET AS TEXTFIELD aEach[PROD_PVUP] ;
         PICTURE "999.99" ;
         VALID { || PriceCalc(PROD_NONE) }
      aEach[PROD_PVUP]:disable()

      @ 26, 48 GET AS TEXTFIELD oShipCharge ;
         PICTURE "9,999.99" ;
         INITIAL 0.00 ;
         VALID { || PriceCalc(PROD_NONE) }

      @ 26, 02 SAY "Preferred media:"

      PriceCalc(PROD_NONE)

      @ 27, 05 GET AS RADIOBUTTONS ;
         PROMPT { "3-inch", "5-inch" }

      @ 30, 02 GET AS COMBOBOX oPayment ;
         PROMPT "Payment method: " ;
         USING {  "Check or money order", ;
                  "COD", ;
                  "Net", ;
                  "MasterCard", ;
                  "VISA", ;
                  "American Express" } ;
         VALID { || PriceCalc(PROD_NONE) } ;
         ACTION { || IIF(oPayment:getValue() > 3, ;
            (oCardNo:enable(), oCardDate:enable, oCardName:enable), ;
            (oCardNo:disable(), oCardDate:disable, oCardName:disable)) }

      @ 31, 02 GET AS TEXTFIELD oCardNo ;
         PROMPT "   Card number: " ;
         PICTURE "9999999999999999" ;
         INITIAL SPACE(16)
      oCardNo:disable()

      @ 31, 36 GET AS TEXTFIELD oCardDate ;
         PROMPT "Expiration date: " ;
         INITIAL SPACE(5)
      oCardDate:disable()

      @ 32, 02 GET AS TEXTFIELD oCardName ;
         PROMPT "  Name on card: " ;
         INITIAL SPACE(40)
      oCardName:disable()


      @ 34, 27 GET AS PUSHBUTTON oOK ;
         PROMPT "  OK  " ;
         ACTION { || oWnd:close() }


      // attach the controls to the window
      ATTACH CONTROLS TO oWnd // DEFAULT ACTION oOK

      // create a menu for the window
      MENU oMenu

         POPUP PROMPT "~File" DISABLED
            MENUITEM PROMPT "~New"
            MENUITEM PROMPT "~Save"
            SEPARATOR
            MENUITEM PROMPT "~Print..."
            MENUITEM PROMPT "Print set~up..."
            SEPARATOR
            MENUITEM PROMPT "E~xit\tAlt+F4" ;
               ACTION { || oWnd:close() }
         END POPUP // File

         MENUITEM PROMPT "\tF1=help" DISABLED

      END MENU // oMenu

      // attach the menu to the window
      ATTACH MENU oMenu TO oWnd

   END IF // oWnd == NIL

   OPEN WINDOW oWnd

   RETURN(oWnd)
   // END OrderWnd()



/*****************************************************************************
** STATIC OrderWndHandler( idMsg, xParam1, xParam2, xParam3 ) --> lHandled
**
** adds or removes a horizontal scrollbar as necessary when the window is
** sized
**
*****************************************************************************/
STATIC FUNCTION OrderWndHandler( idMsg, xParam1, xParam2, xParam3 )

   LOCAL lHandled := .T.

   LOCAL nViewWidth, ;
         nVirtWidth

   LOCAL oWnd


   DO CASE
   CASE idMsg == PWMSG_SIZE
      oWnd  := pw():curFocus()
      oWnd:getViewSize(, @nViewWidth)
      oWnd:getVirtSize(, @nVirtWidth)
      IF nViewWidth == nVirtWidth
         oWnd:setScrollbars(.F., )
      ELSE
         oWnd:setScrollbars(.T., )
      END IF // nViewWidth == nVirtWidth

   END CASE

   RETURN(lHandled)
   // END OrderWndHandler( idMsg, xParam1, xParam2, xParam3 )



/*****************************************************************************
** STATIC PriceCalc( idProd ) --> .T.
**
** called often to recalculate and display the extended and total prices;
** returns .T. for easy use in VALID clauses
**
*****************************************************************************/
STATIC FUNCTION PriceCalc( idProd )

   STATIC   lInProcess  := .F.   // necessary to handle recursion

   LOCAL i, ;
         nCol, ;
         nExt, ;
         nQty, ;
         nRow, ;
         nShip, ;
         nShipCharge := 0.00, ;
         nTotal      := 0.00

   LOCAL xCursor


   IF .NOT. lInProcess

      lInProcess  := .T.

      IF idProd != PROD_NONE
         nQty  := aProd[idProd]:getValue()
      END IF // idProd != PROD_NONE

      DO CASE
      CASE idProd == PROD_OV
         IF nQty == 0
            aDemo[idProd]:setValue(.F.)
            oOVforC:setValue(.F.)
            oOVforC:disable()
            aEach[idProd]:setValue(0.00)
            aEach[idProd]:disable()
         ELSE
            IF aDemo[idProd]:getValue()
               aEach[idProd]:setValue(0.00)
            ELSEIF oRef:getValue() == 3 // users' group discount
               aEach[idProd]:setValue(149.00)
            ELSEIF nQty == 1
               aEach[idProd]:setValue(169.00)
            ELSEIF (nQty >= 2) .AND. (nQty <= 10)
               aEach[idProd]:setValue(139.00)
            ELSEIF (nQty >= 11) .AND. (nQty <= 24)
               aEach[idProd]:setValue(129.00)
            ELSEIF nQty >= 25
               aEach[idProd]:setValue(119.00)
            END IF // aDemo[idProd]:getValue()
            oOVforC:enable()
            aEach[idProd]:enable()
         END IF // nQty == 0

      CASE idProd == PROD_OVUP
         IF nQty == 0
            oOVUPforC:setValue(.F.)
            oOVUPforC:disable()
            aEach[idProd]:setValue(0.00)
            aEach[idProd]:disable()
         ELSE
            oOVUPforC:enable()
            aEach[idProd]:setValue(39.95)
            aEach[idProd]:enable()
         END IF // nQty == 0

      CASE idProd == PROD_PP
         IF nQty == 0
            aDemo[idProd]:setValue(.F.)
            aEach[idProd]:setValue(0.00)
            aEach[idProd]:disable()
         ELSE
            IF aDemo[idProd]:getValue()
               aEach[idProd]:setValue(0.00)
            ELSEIF oRef:getValue() == 3 // users' group discount
               aEach[idProd]:setValue(149.00)
            ELSEIF nQty == 1
               aEach[idProd]:setValue(179.00)
            ELSEIF nQty >= 2
               aEach[idProd]:setValue(119.00)
            END IF // aDemo[idProd]:getValue()
            aEach[idProd]:enable()
         END IF // nQty == 0

      CASE idProd == PROD_PPUP
         IF nQty == 0
            oManual:setValue(.F.)
            oManual:disable()
            aEach[idProd]:setValue(0.00)
            aEach[idProd]:disable()
         ELSE
            oManual:enable()
            aEach[idProd]:setValue(49.95)
            aEach[idProd]:enable()
         END IF // nQty == 0

      CASE idProd == PROD_PV
         IF nQty == 0
            aDemo[idProd]:setValue(.F.)
            aEach[idProd]:setValue(0.00)
            aEach[idProd]:disable()
         ELSE
            IF aDemo[idProd]:getValue()
               aEach[idProd]:setValue(0.00)
            ELSEIF oRef:getValue() == 3 // users' group discount
               aEach[idProd]:setValue(219.00)
            ELSEIF nQty == 1
               aEach[idProd]:setValue(269.00)
            ELSEIF (nQty >= 2) .AND. (nQty <= 10)
               aEach[idProd]:setValue(209.00)
            ELSEIF (nQty >= 11) .AND. (nQty <= 24)
               aEach[idProd]:setValue(199.00)
            ELSEIF (nQty >= 25) .AND. (nQty <= 99)
               aEach[idProd]:setValue(189.00)
            ELSEIF nQty >= 100
               aEach[idProd]:setValue(169.00)
            END IF // aDemo[idProd]:getValue()
            aEach[idProd]:enable()
         END IF // nQty == 0

      CASE idProd == PROD_PVUP
         IF nQty == 0
            aEach[idProd]:setValue(0.00)
            aEach[idProd]:disable()
         ELSE
            aEach[idProd]:setValue(59.95)
            aEach[idProd]:enable()
         END IF // nQty == 0

      END CASE

      // This monster of an IF just makes sure that the shipping charges
      // get set to 0.00 if the only things ordered are demos.
      IF ((aProd[PROD_OV]:getValue() == 0) .OR. ;
            ((aProd[PROD_OV]:getValue() != 0) .AND. ;
            aDemo[PROD_OV]:getValue())) .AND. ;
            ((aProd[PROD_PP]:getValue() == 0) .OR. ;
            ((aProd[PROD_PP]:getValue() != 0) .AND. ;
            aDemo[PROD_PP]:getValue())) .AND. ;
            ((aProd[PROD_PV]:getValue() == 0) .OR. ;
            ((aProd[PROD_PV]:getValue() != 0) .AND. ;
            aDemo[PROD_PV]:getValue())) .AND. ;
            (aProd[PROD_OVUP]:getValue() == 0) .AND. ;
            (aProd[PROD_PPUP]:getValue() == 0) .AND. ;
            (aProd[PROD_PVUP]:getValue() == 0)

         nShipCharge := 0.00

      ELSEIF oShip:getValue() == (SHIPVIA_LEN - 2)

         // cheapest int'l
         nShip := ASCAN(aZones, { | e | LEFT(e[1], ;
            LEN(ALLTRIM(oCountry:getValue()))) == ;
            ALLTRIM(oCountry:getValue()) })
         IF nShip != 0
            nShip := ASCAN(aRates, { | e | e[1] == aZones[nShip, 3] })
            IF nShip == 0
               nShip := ASCAN(aZones, { | e | LEFT(e[1], ;
                  LEN(ALLTRIM(oCountry:getValue()))) == ;
                  ALLTRIM(oCountry:getValue()) })
               nShip := ASCAN(aRates, { | e | e[1] == aZones[nShip, 2] })
            END IF // nShip == 0
            IF nShip != 0
               nShipCharge := aRates[nShip, 2]
            END IF // nShip != 0
         END IF // nShip != 0

      ELSEIF oShip:getValue() == (SHIPVIA_LEN - 1)

         // fastest int'l
         nShip := ASCAN(aZones, { | e | LEFT(e[1], ;
            LEN(ALLTRIM(oCountry:getValue()))) == ;
            ALLTRIM(oCountry:getValue()) })
         IF nShip != 0
            nShip := ASCAN(aRates, { | e | e[1] == aZones[nShip, 2] })
            IF nShip != 0
               nShipCharge := aRates[nShip, 2]
            END IF // nShip != 0
         END IF // nShip != 0

      ELSEIF oShip:getValue() != SHIPVIA_LEN

         nShipCharge := { 6.00, 10.00, 20.00, 6.00, 12.00, 50.00, ;
            25.00, 0.00, 0.00 }[oShip:getValue()]

      END IF // ((aProd[PROD_OV]:getValue() == 0) .OR. ...

      // test for a COD order
      IF nShipCharge > 0.00
         nShipCharge += IIF(oPayment:getValue() == 2, 4.00, 0.00)
      END IF // nShipCharge > 0.00

      // actually set the value of the textfield now
      oShipCharge:setValue(nShipCharge)

      // display the totals
      nRow     := ROW()
      nCol     := COL()
      xCursor  := SETCURSOR(SC_NONE)

      FOR i := 1 TO 6
         nExt     := aProd[i]:getValue() * aEach[i]:getValue()
         nTotal   += nExt
         @ 16 + i, 48 SAY nExt ;
            PICTURE "9,999.99"
      NEXT i 

      @ 24, 48 SAY nTotal ;
         PICTURE "9,999.99"
      @ 25, 48 SAY nTotal * nTaxRate ;
         PICTURE "9,999.99"
      @ 28, 48 SAY nTotal + (nTotal * nTaxRate) + oShipCharge:getValue() ;
         PICTURE "9,999.99"

      SETPOS(nRow, nCol)
      SETCURSOR(xCursor)

      lInProcess  := .F.

   END IF // .NOT. lInProcess

   RETURN(.T.)
   // END PriceCalc( idProd )

