//
// You can use this function, TestListbox(), in the filter of a listbox
// or browsebox to determine if a doubleclick occured within the
// interior of the box.
//
// Here's how you might use TestListbox() from within the filter:
//
//   .
//   .
//   .
//   CASE (idMsg == PWMSG_MOUSEDOUBLE) .AND. (xParam1 == PMBUTTON_LEFT)
//      // Was the doubleclick on an item?
//      IF TestListbox(oListbox, xParam2, xParam3)
//
//         //
//         // Do whatever you need to do for a doubleclick.
//         //
//
//
//         // Signal message handled.
//         idMsg := PWMSG_NONE
//
//      END IF // TestListbox(oListbox, xParam2, xParam3)
//   .
//   .
//   .
//



/*****************************************************************************
** TestListbox( oListbox, nScreenRow, nScreenCol ) --> lOnTopOf
**
** This will determine if screen coordinates (as passed with mouse messages)
** are in the "items" area of a listbox.
**
*****************************************************************************/
FUNCTION TestListbox( oListbox, nScreenRow, nScreenCol )

   LOCAL lOnTopOf := .F.

   LOCAL nCol, ;
         nRow, ;
         nWndCol, ;
         nWndRow

   LOCAL oCtrlRef


   // Convert screen coordinates to window coordinates.
   oListbox:wnd:screenToWnd(nScreenRow, nScreenCol, @nWndRow, @nWndCol)

   // Get the input control at those window coordinates.
   oCtrlRef := oListbox:wnd:ctrlAtPos(nWndRow, nWndCol)

   // Are the coordinates on the listbox?
   IF oCtrlRef == oListbox

      // Convert window coordinates to control coordinates.
      oListbox:wndToCtrl(nWndRow, nWndCol, @nRow, @nCol)

      // Are the coordinates in the "items" area?
      IF (nCol < (oListbox:width - 3)) .AND. (nRow > 1) .AND. ;
            (nRow <= (oListbox:height - 2))
         lOnTopOf := .T.
      END IF // (nCol < (oListbox:width - 3)) .AND. (nRow > 1) .AN...

   END IF // oCtrlRef == oListbox

   // lOnTopOf will be .T. if the screen position nScreenRow, nScreenCol
   // is in the "items" area of oListbox.
   RETURN(lOnTopOf)
   // END TestListbox( oListbox, nScreenRow, nScreenCol )

