/*****************************************************************************
** PWWINDOW.CH
**
** ProVision:Windows
** windows header file
**
** Copyright 1991-1993 SofDesign International, Inc.
** All rights reserved
**
** v1.24 	03/05/93		full 5.2 compatibility and bug fixes
** v1.23 	01/18/93		first source code license version
**
**	tab spacing = 3
**
*****************************************************************************/

#ifndef _PWWINDOW_CH
#define _PWWINDOW_CH


// activate the event system
#xcommand	ACTIVATE WINDOWS ;
				=> ;
				pw():activate( NIL )

#xcommand	ACTIVATE WINDOWS ;
					INITIAL <oWnd> ;
				=> ;
				pw():activate( <oWnd> )


// attach a TBROWSE to a window
#xcommand	ATTACH TBROWSE <oTB> TO <oWnd> ;
				=> ;
				<oWnd>:setTBROWSE( <oTB> )


// deinitialize ProVision:Windows
#xcommand	DEINIT WINDOWS ;
				=> ;
				pwDeinit()


// initialize ProVision:Window
#xcommand	INIT WINDOWS ;
					[ <idMouse: GRAPHIC, STANDARD> MOUSE ] ;
					[ <idBorders: GRAPHIC, STANDARD> BORDERS ] ;
					[ <idControls: GRAPHIC, STANDARD> CONTROLS ] ;
					[ SETBLINK <lSetBlink> ] ;
					[ LOAD8PIXEL <lLoad8> ] ;
					[ SET8PIXEL <lSet8> ] ;
					[ VIDEO <cVideo> ] ;
				=> ;
				pwInit( <lSetBlink>, <"idMouse">, <"idBorders">, ;
					<"idControls">, <lLoad8>, <lSet8>, <"cVideo"> )


// deregister and hide a window
#xcommand	CLOSE WINDOW <oWnd> ;
				=> ;
				<oWnd>:close()

// create a window but don't register it or show it
#xcommand	CREATE WINDOW <oWnd> ;
					[ AT <nRow>, <nCol> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ STYLE <idStyle> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ TITLE <cTitle> ] ;
					[ ICON TITLE <cIconTitle> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ WINDOW HANDLER <bWindowHandler> ] ;
					[ EVENT HANDLER <bEventHandler> ] ;
					[ VIRTUAL OFFSET <nVRow>, <nVCol> ] ;
					[ VIRTUAL SIZE <nVHeight>, <nVWidth> ] ;
					[ <lShadow: SHADOW> ] ;
					[ BORDERS <idBorders> ] ;
					[ PARENT <oParent> ] ;
				=> ;
				<oWnd> := pwWindow():new( <nRow>, <nCol>, <nHeight>, ;
					<nWidth>, <idStyle>, <cColor>, <cTitle>, <cIconTitle>, ;
					<cHelpLine>, <bWindowHandler>, <bEventHandler>, <nVRow>, ;
					<nVCol>, <nVHeight>, <nVWidth>, <.lShadow.>, <idBorders>, ;
					<oParent> )

#xcommand	CREATE WINDOW <oWnd> ;
					<x: CENTERED, CENTRED> ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ <*clauses*> ] ;
				=> ;
				CREATE WINDOW <oWnd> ;
					AT (pwMaxRow() - (<nHeight>) + 1) / 2, ;
						(pwMaxCol() - (<nWidth>) + 1) / 2 ;
					SIZE <nHeight>, <nWidth> ;
					<clauses>

// create a tbrowse window but don't register it or show it
#xcommand	CREATE TBROWSE WINDOW <oWnd> ;
					[ AT <nRow>, <nCol> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ STYLE <idStyle> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ TITLE <cTitle> ] ;
					[ ICON TITLE <cIconTitle> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ WINDOW HANDLER <bWindowHandler> ] ;
					[ EVENT HANDLER <bEventHandler> ] ;
					[ VIRTUAL OFFSET <nVRow>, <nVCol> ] ;
					[ VIRTUAL SIZE <nVHeight>, <nVWidth> ] ;
					[ <lShadow: SHADOW> ] ;
					[ BORDERS <idBorders> ] ;
					[ PARENT <oParent> ] ;
					[ USING <oTB> ] ;
				=> ;
				<oWnd> := pwTBWnd():new( <nRow>, <nCol>, <nHeight>, ;
					<nWidth>, <idStyle>, <cColor>, <cTitle>, <cIconTitle>, ;
					<cHelpLine>, <bWindowHandler>, <bEventHandler>, <nVRow>, ;
					<nVCol>, <nVHeight>, <nVWidth>, <.lShadow.>, <idBorders>, ;
					<oParent>, <oTB> )

#xcommand	CREATE TBROWSE WINDOW <oWnd> ;
					<x: CENTERED, CENTRED> ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ <*clauses*> ] ;
				=> ;
				CREATE TBROWSE WINDOW <oWnd> ;
					AT (pwMaxRow() - (<nHeight>) + 1) / 2, ;
						(pwMaxCol() - (<nWidth>) + 1) / 2 ;
					SIZE <nHeight>, <nWidth> ;
					<clauses>

// create a notepad window but don't register it or show it
#xcommand	CREATE NOTEPAD WINDOW <oWnd> ;
					[ AT <nRow>, <nCol> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ BUFFERSIZE <nMaxBuffSize> ] ;
					[ MAXLINES <nMaxLines> ] ;
					[ LINELENGTH <nLineLength> ] ;
					[ TABSIZE <nTabSize> ] ;
					[ <ro: READONLY > ] ;
					[ STYLE <idStyle> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ TITLE <cTitle> ] ;
					[ ICON TITLE <cIconTitle> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ WINDOW HANDLER <bWindowHandler> ] ;
					[ EVENT HANDLER <bEventHandler> ] ;
					[ VIRTUAL SIZE <nVHeight>, <nVWidth> ] ;
					[ <lShadow: SHADOW> ] ;
					[ BORDERS <idBorders> ] ;
					[ PARENT <oParent> ] ;
				=> ;
				<oWnd> := pwNoteWnd():new( <nRow>, <nCol>, <nHeight>, ;
					<nWidth>, <idStyle>, <cColor>, <cTitle>, <cIconTitle>, ;
					<cHelpLine>, <bWindowHandler>, <bEventHandler>, ;
					<nVHeight>, <nVWidth>, <.lShadow.>, <idBorders>, <oParent>, ;
					<nMaxBuffSize>, <nMaxLines>, <nLineLength>, <nTabSize>, ;
					<.ro.> )

#xcommand	CREATE NOTEPAD WINDOW <oWnd> ;
					<x: CENTERED, CENTRED> ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ <*clauses*> ] ;
				=> ;
				CREATE NOTEPAD WINDOW <oWnd> ;
					AT (pwMaxRow() - (<nHeight>) + 1) / 2, ;
						(pwMaxCol() - (<nWidth>) + 1) / 2 ;
					SIZE <nHeight>, <nWidth> ;
					<clauses>

// close if open and destroy a window
#xcommand	DESTROY WINDOW <oWnd> ;
				=> ;
				<oWnd>:destroy()

// deregister a window but don't hide it
#xcommand	DISABLE WINDOW <oWnd> ;
				=> ;
				pw():deregister( <oWnd> )

// register a window but don't re-show it
#xcommand	ENABLE WINDOW <oWnd> ;
				=> ;
				pw():register( <oWnd> )

// register and show a window
#xcommand	OPEN WINDOW <oWnd> ;
					[ [ STATE ] <cState: MINIMIZED, MAXIMIZED> ] ;
					[ <lBack: BACK> ] ;
					[ <lModal: MODAL> ] ;
				=> ;
				<oWnd>:open( <"cState">, <.lBack.>, <.lModal.> )

// attempt to give input focus to a particular window
#xcommand	SELECT WINDOW <oWnd> ;
				=> ;
				pw():select( <oWnd> )


#endif

