/*****************************************************************************
** PWMISC.CH
**
** ProVision:Windows
** miscellaneous header file
**
** Copyright 1991-1993 SofDesign International, Inc.
** All rights reserved
**
** v1.24 	03/05/93		full 5.2 compatibility and bug fixes
** v1.23 	01/18/93		first source code license version
**
**	tab spacing = 3
**
*****************************************************************************/

#ifndef _PWMISC_CH
#define _PWMISC_CH


// extra key definitions
#define K_NONE									0
//#define K_SPACE								32
#define K_UNDO									270

#define K_SH_UP								517
#define K_SH_DOWN								536
#define K_SH_LEFT								531
#define K_SH_RIGHT							516
#define K_SH_SPACE							544
#define K_SH_INS								534
#define K_SH_DEL								519
#define K_SH_PGUP								530
#define K_SH_PGDN								515
#define K_SH_HOME								513
#define K_SH_END								518
#define K_SH_ENTER							525
#define K_SH_BS								520
//#define K_SH_TAB								271
#define K_SH_ESC								539

//#define K_CTRL_UP								397
//#define K_CTRL_DOWN							401
//#define K_CTRL_LEFT							26
//#define K_CTRL_RIGHT							2
#define K_CTRL_SPACE							1056
//#define K_CTRL_INS							402
//#define K_CTRL_DEL							403
//#define K_CTRL_PGUP							31
//#define K_CTRL_PGDN							30
//#define K_CTRL_HOME							29
//#define K_CTRL_END							23
//#define K_CTRL_ENTER							10
//#define K_CTRL_BS								127
//#define K_CTRL_TAB							404
#define K_CTRL_ESC							1051

//#define K_ALT_UP								408
//#define K_ALT_DOWN							416
//#define K_ALT_LEFT							411
//#define K_ALT_RIGHT							413
#define K_ALT_SPACE							2080
//#define K_ALT_INS								418
//#define K_ALT_DEL								419
//#define K_ALT_PGUP							409
//#define K_ALT_PGDN							417
//#define K_ALT_HOME							407
//#define K_ALT_END								415
//#define K_ALT_ENTER							284
//#define K_ALT_BS								270
//#define K_ALT_TAB								421
//#define K_ALT_ESC								257

#define K_SH_CTRL_LEFT						1562
#define K_SH_CTRL_RIGHT						1538
#define K_SH_CTRL_PGUP						1567
#define K_SH_CTRL_PGDN						1566
#define K_SH_CTRL_HOME						1565
#define K_SH_CTRL_END						1559


// standard code blocks (very useful)
#define bNIL									{ || NIL }
#define bTRUE									{ || .T. }
#define bFALSE									{ || .F. }
#xtranslate	bVAR() ;
				=> ;
				bNIL
#xtranslate	bVAR( <var> ) ;
				=> ;
				{ | _1 | IIF(PCOUNT() == 0, <var>, <var> := _1) }


// buffer size for WINDOW:saveWindow()
#define PW_WNDBUFSIZE						370


// constants for pw():isTMR()
#define PWTMR_BORDERS						0
#define PWTMR_CONTROLS						1
#define PWTMR_MOUSE							2


// timer types
#define PWTIMER_COUNTDOWN					1
#define PWTIMER_PERIODIC					2


// output destinations
#define PWOUTPUT_WALLPAPER					NIL
#define PWOUTPUT_SCREEN						255


// various wallpapers
#define PWWP_BRICKS		{ | _1, _2 | pwWPBricks(_1, _2) }
#define PWWP_CHRISTMAS	{ | _1, _2 | pwWPChristmas(_1, _2) }
#define PWWP_DEFAULT		{ | _1, _2 | pwWPDefault(_1, _2) }
#define PWWP_DIAMOND		{ | _1, _2 | pwWPDiamond(_1, _2) }
#define PWWP_GRID			{ | _1, _2 | pwWPGrid(_1, _2) }
#define PWWP_RINGS		{ | _1, _2 | pwWPRings(_1, _2) }
#define PWWP_SNAKE		{ | _1, _2 | pwWPSnake(_1, _2) }
#define PWWP_SQUARE		{ | _1, _2 | pwWPSquare(_1, _2) }
#define PWWP_STRIPES		{ | _1, _2 | pwWPStripes(_1, _2) }
#define PWWP_WEAVE		{ | _1, _2 | pwWPWeave(_1, _2) }
#define PWWP_ZIGZAG		{ | _1, _2 | pwWPZigZag(_1, _2) }


// notepad defines
#define PWNP_VERBATIM						0
#define PWNP_NOWRAP							1
#define PWNP_WRAP								2


// low-level output types
#define PWRW_TEXT								0
#define PWRW_TEXTATTR						1
#define PWRW_VIDEO							2
#define PWRW_ATTR								3


// scrollbar orientations
#define PWSCROLL_VERTICAL					1
#define PWSCROLL_HORIZONTAL				2


// standard window styles
#define PWSTYLE_THIN							pvBin2Num("000010000000000") // virtual buffer only
#define PWSTYLE_DIALOG						pvBin2Num("000110000000011") // title bar, system menu, virtual buffer, movable
#define PWSTYLE_ERROR						pvBin2Num("000010000000010") // title bar, virtual buffer
#define PWSTYLE_MDIPRIMARY					pvBin2Num("010100011111111") // keep scrollbars, no virtual buffer
#define PWSTYLE_MDISECONDARY				pvBin2Num("100110011101111") // keep scrollbars, no menu
#define PWSTYLE_MESSAGE						pvBin2Num("000010000000011") // title bar, system menu, virtual buffer
#define PWSTYLE_PRIMARY						pvBin2Num("000110011111111") // keep scrollbars
#define PWSTYLE_SECONDARY					pvBin2Num("000110011111011") // keep scrollbars, no minimize
															//	  |||||||||||||||
// window style bit definitions					//	  |||||||||||||||
#define PWSTYLEINFO_MDISECONDARY			16384	// --'||||||||||||||
#define PWSTYLEINFO_MDIPRIMARY			8192	// ---'|||||||||||||
#define PWSTYLEINFO_HELPLINE				4096	// ----'||||||||||||
#define PWSTYLEINFO_MOVABLE				2048	// -----'|||||||||||
#define PWSTYLEINFO_VIRTUAL				1024	// ------'||||||||||
#define PWSTYLEINFO_KEEPHSCROLLBAR		512	// -------'|||||||||
#define PWSTYLEINFO_KEEPVSCROLLBAR		256	// --------'||||||||
#define PWSTYLEINFO_HSCROLLBAR			128	// ---------'|||||||
#define PWSTYLEINFO_VSCROLLBAR			64		// ----------'||||||
#define PWSTYLEINFO_SIZING					32		// -----------'|||||
#define PWSTYLEINFO_MENU					16		// ------------'||||
#define PWSTYLEINFO_MAXIMIZE				8		// -------------'|||
#define PWSTYLEINFO_MINIMIZE				4		// --------------'||
#define PWSTYLEINFO_TITLEBAR				2		// ---------------'|
#define PWSTYLEINFO_SYSTEMMENU			1		// ----------------'

// get style info
#xtranslate	_pwGetStyleInfo( <idStyle>, <idOption> ) ;
				=> ;
				(pvBitAND( <idStyle>, <idOption> ) != 0)

// window border bit flags
#define PWBORDER_L							pvBin2Num("1000") // left
#define PWBORDER_B							pvBin2Num("0100") // bottom
#define PWBORDER_R							pvBin2Num("0010") // right
#define PWBORDER_T							pvBin2Num("0001") // top
														//		  ||||
// window style bit definitions				//		  ||||
#define PWBORDERINFO_L						3	// -----'|||
#define PWBORDERINFO_B						2	// ------'||
#define PWBORDERINFO_R						1	// -------'|
#define PWBORDERINFO_T						0	// --------'

// window state bit definitions
#define PWSTATE_MINIMIZED	  				0
#define PWSTATE_MAXIMIZED	  				1
#define PWSTATE_HASBEENMINIMIZED			2
#define PWSTATE_OPEN							3
#define PWSTATE_ENABLED						4

// get state info
#xtranslate	_pwGetStateInfo( <idState>, <idOption> ) ;
				=> ;
				pvGetBit( <idState>, <idOption> )


#endif

