/*****************************************************************************
** PWMENU.CH
**
** ProVision:Windows
** menus header file
**
** Copyright 1991-1993 SofDesign International, Inc.
** All rights reserved
**
** v1.24 	03/05/93		full 5.2 compatibility and bug fixes
** v1.23 	01/18/93		first source code license version
**
**	tab spacing = 3
**
*****************************************************************************/

#ifndef _PWMENU_CH
#define _PWMENU_CH


// define a menu object
// The compiler will optimize out the IF .T./END IF.  It is used only to
// detect mismatched MENU/END MENU pairs and may be safely omitted.
#xcommand	MENU <oMenu> ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
				=> ;
				<oMenu> := pwBegMenu( <cColor> ) ;;
				IF .T.

#xcommand	END MENU ;
				=> ;
				END IF ;; // .T.
				pwEndMenu()

#xcommand	ENDMENU ;
				=> ;
				END MENU


// define a popup object
// The compiler will optimize out the IF .T./END IF.  It is used only to
// detect mismatched POPUP/END POPUP pairs and may be safely omitted.
#xcommand	POPUP [ <oPopup> ] ;
					[ <idPrompt: PROMPT, TITLE> <cPrompt> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ <cEnabled: ENABLED, DISABLED> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ INSERT INTO <oMenuOrPopup> ] ;
					[ BEFORE <oBefore> ] ;
					[ AFTER <oAfter> ] ;
					[ AT <nPos> ] ;
				=> ;
				[ <oPopup> := ] pwBegPopup( <cPrompt>, <cColor>, <"cEnabled">, ;
					<cHelpLine>, <oMenuOrPopup>, <oBefore>, <oAfter>, <nPos> ) ;;
				IF .T.

#xcommand	END POPUP ;
				=> ;
				END IF ;; // .T.
				pwEndPopup()

#xcommand	ENDPOPUP ;
				=> ;
				END POPUP


// define a menuitem object
#xcommand	MENUITEM [ <oItem> ] ;
					[ PROMPT <cPrompt> ] ;
					[ ACTION <bAction> ] ;
					[ <cCheck: CHECKED, UNCHECKED> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ <cEnabled: ENABLED, DISABLED> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ INSERT INTO <oMenuOrPopup> ] ;
					[ BEFORE <oBefore> ] ;
					[ AFTER <oAfter> ] ;
					[ AT <nPos> ] ;
				=> ;
				[ <oItem> := ] pwDefMenuitem( <cPrompt>, <bAction>, ;
					<"cCheck">, <cColor>, <"cEnabled">, <cHelpLine>, ;
					<oMenuOrPopup>, <oBefore>, <oAfter>, <nPos> )


// define a separator line
#xcommand	SEPARATOR ;
					[ INSERT INTO <oPopup> ] ;
					[ BEFORE <oBefore> ] ;
					[ AFTER <oAfter> ] ;
					[ AT <nPos> ] ;
				=> ;
				pwDefSeparator( <oPopup>, <oBefore>, <oAfter>, <nPos> )


// remove a menuitem or popup from a popup or menu
#xcommand	DELETE <x: MENUITEM, POPUP> [ AT ] <oRefOrnPos> ;
					FROM <oMenuOroPopup> ;
				=> ;
				pwDelMenu( <oRefOrnPos>, <oMenuOroPopup> )


// attach a menu to a window
#xcommand	ATTACH MENU <oMenu> TO <oWnd> ;
				=> ;
				<oWnd>:attachMenu( <oMenu> )


#endif

