/*****************************************************************************
** PWCTRL.CH
**
** ProVision:Windows
** controls header file
**
** Copyright 1991-1993 SofDesign International, Inc.
** All rights reserved
**
** v1.24 	03/05/93		full 5.2 compatibility and bug fixes
** v1.23 	01/18/93		first source code license version
**
**	tab spacing = 3
**
*****************************************************************************/

#ifndef _PWCTRL_CH
#define _PWCTRL_CH


// create a browsebox
#xcommand	@ <nRow>, <nCol> GET [ <nVar> ] ;
					AS BROWSEBOX [ <oCtrl> ] ;
					[ USING <oTB> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ PROMPT <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwBrowsebox():new( <nRow>, ;
					<nCol>, <nHeight>, <nWidth>, <cPrompt>, <oTB>, ;
					bVAR(<nVar>), <"nVar">, <bAction>, <{bValid}>, ;
					<bFilter>, <cColor>, { <idKey> }, <cHelpLine> ) )

				
// create a checkbox
#xcommand	@ <nRow>, <nCol> GET [ <lVar> ] ;
					AS CHECKBOX [ <oCtrl> ] ;
					[ INITIAL <lValue> ] ;
					[ PROMPT <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwCheckbox():new( <nRow>, ;
					<nCol>, <cPrompt>, bVAR(<lVar>), <"lVar">, <lValue>, ;
					<bAction>, <{bValid}>, <bFilter>, <cColor>, { <idKey> }, ;
					<cHelpLine>) )


// create a checklist
#xcommand	@ <nRow>, <nCol> GET [ <nVar> ] ;
					AS CHECKLIST [ <oCtrl> ] ;
					[ USING <aArray> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ INITIAL <nValue> ] ;
					[ CHECKED <aChecked> ] ;
					[ UNCHECKED <aUnchecked> ] ;
					[ PROMPT <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwChecklist():new( <nRow>, ;
					<nCol>, <nHeight>, <nWidth>, <cPrompt>, <aArray>, ;
					bVAR(<nVar>), <"nVar">, <nValue>, <aChecked>, <aUnchecked>, ;
					<bAction>, <{bValid}>, <bFilter>, <cColor>, { <idKey> }, ;
					<cHelpLine> ) )

				
// create a combobox
#xcommand	@ <nRow>, <nCol> GET [ <nVar> ] ;
					AS COMBOBOX [ <oCtrl> ] ;
					[ USING <aArray> ] ;
					[ INITIAL <nValue> ] ;
					[ PROMPT [ <lAbove: ABOVE> ] <cPrompt> ] ;
					[ PICTURE <cPicture> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwCombobox():new( <nRow>, ;
					<nCol>, <cPrompt>, <.lAbove.>, <cPicture>, <aArray>, ;
					bVAR(<nVar>), <"nVar">, <nValue>, <bAction>, <{bValid}>, ;
					<bFilter>, <cColor>, { <idKey> }, <cHelpLine> ) )


// create a listbox
#xcommand	@ <nRow>, <nCol> GET [ <nVar> ] ;
					AS LISTBOX [ <oCtrl> ] ;
					[ USING <aArray> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ INITIAL <nValue> ] ;
					[ PROMPT <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwListbox():new( <nRow>, ;
					<nCol>, <nHeight>, <nWidth>, <cPrompt>, <aArray>, ;
					bVAR(<nVar>), <"nVar">, <nValue>, <bAction>, <{bValid}>, ;
					<bFilter>, <cColor>, { <idKey> }, <cHelpLine> ) )

				
// create a pushbutton
#xcommand	@ <nRow>, <nCol> GET [ <lVar> ] ;
					AS PUSHBUTTON [ <oCtrl> ] ;
					[ PROMPT <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwPushbutton():new( <nRow>, ;
					<nCol>, <nHeight>, <nWidth>, <cPrompt>, bVAR(<lVar>), ;
					<"lVar">, <bAction>, <{bValid}>, <bFilter>, <cColor>, ;
					{ <idKey> }, <cHelpLine> ) )


// create radiobuttons
#xcommand	@ <nRow>, <nCol> GET [ <nVar> ] ;
					AS RADIOBUTTONS [ <oCtrl> ] ;
					[ INITIAL <nValue> ] ;
					[ PROMPT <aPrompts> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ <idOrient: HORIZONTAL, VERTICAL> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwRadiobuttons():new( ;
					<nRow>, <nCol>, <aPrompts>, <"idOrient">, bVAR(<nVar>), ;
					<"nVar">, <nValue>, <bAction>, <{bValid}>, <bFilter>, ;
					<cColor>, { <idKey> }, <cHelpLine> ) )


// create a spinner
#xcommand	@ <nRow>, <nCol> GET [ <xVar> ] ;
					AS SPINNER [ <oCtrl> ] ;
					[ INITIAL <xValue> ] ;
					[ RANGE <xRangeLow>, <xRangeHigh> [ STEP <xRangeStep> ] ] ;
					[ USING <aArray> ] ;
					[ PROMPT [ <lAbove: ABOVE> ] <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ PICTURE <cPicture> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwSpinner():new( <nRow>, ;
					<nCol>, <cPrompt>, <.lAbove.>, bVAR(<xVar>), <"xVar">, ;
					<xValue>, <xRangeLow>, <xRangeHigh>, <xRangeStep>, ;
					<aArray>, <cPicture>, <bAction>, <{bValid}>, <bFilter>, ;
					<cColor>, { <idKey> }, <cHelpLine> ) )


// create a notepad control
#xcommand	@ <nRow>, <nCol> GET [ <cVar> ] ;
					AS NOTEPAD [ <oCtrl> ] ;
					[ SIZE <nHeight>, <nWidth> ] ;
					[ INITIAL <cInitial> ] ;
					[ BUFFERSIZE <nMaxBuffSize> ] ;
					[ MAXLINES <nMaxLines> ] ;
					[ LINELENGTH <nLineLength> ] ;
					[ TABSIZE <nTabSize> ] ;
					[ <ro: READONLY > ] ;
					[ PROMPT <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwNoteCtrl():new( <nRow>, ;
					<nCol>, <nHeight>, <nWidth>, <cPrompt>, ;
					bVAR(<cVar>), <"cVar">, <cInitial>, <bAction>, <{bValid}>, ;
					<bFilter>, <cColor>, { <idKey> }, <cHelpLine>, ;
					<nMaxBuffSize>, <nMaxLines>, <nLineLength>, <nTabSize>, ;
					<.ro.> ) )

				
// create a textfield
#xcommand	@ <nRow>, <nCol> GET [ <xVar> ] ;
					AS TEXTFIELD [ <oCtrl> ] ;
					[ INITIAL <xValue> ] ;
					[ PROMPT [ <lAbove: ABOVE> ] <cPrompt> ] ;
					[ HELPLINE <cHelpLine> ] ;
					[ PICTURE <cPicture> ] ;
					[ SHORTCUT <idKey, ...> ] ;
					[ <x: COLOR, COLOUR> <cColor> ] ;
					[ VALID <bValid> ] ;
					[ ACTION <bAction> ] ;
					[ FILTER <bFilter> ] ;
				=> ;
				AADD( GetList, [ <oCtrl> := ] pwTextfield():new( <nRow>, ;
					<nCol>, <cPrompt>, <.lAbove.>, bVAR(<xVar>), <"xVar">, ;
					<xValue>, <cPicture>, <bAction>, <{bValid}>, <bFilter>, ;
					<cColor>, { <idKey> }, <cHelpLine> ) )


#xcommand	@ <nRow>, <nCol> GET [ <xVar> ] AS <xType> ;
					[ <clauses, ...> ] ;
					SUPPRESSVALID ;
					[ <moreclauses, ...> ] ;
				=> ;
				@ <nRow>, <nCol> GET <xVar> AS <xType> ;
					[ <clauses> ] ;
					[ <moreclauses> ] ;;
				ATAIL(GetList):isException := .T.


// attach controls to a window
#xcommand	ATTACH CONTROLS TO <oWnd> ;
					[ INITIAL <oCtrl> ] ;
					[ DEFAULT ACTION <oDefault> ] ;
				=> ;
				<oWnd>:register( GetList, <oCtrl>, <oDefault> ) ;;
				GetList	:= {}


#endif


