unit PlayInfo;

interface
uses
  Strings,
  MMSystem,
  WinProcs,
  WinTypes;

const
  MsgLen = 200;

var
  wDeviceID: Word;

function ErrorMsg(Error: LongInt; Msg: PChar): Boolean; export;
function OpenWave(FileName: Pchar): Boolean; export;
function PlayWave: Boolean; export;
function CloseWave: Boolean; export;

implementation

function GetErrorMessage(RC:LongInt; S: PChar): PChar;
begin
  if not mciGetErrorString(RC, S, MsgLen) then
    StrCopy(S, 'No message available');
  GetErrorMessage := S;
end;

function ErrorMsg(Error: LongInt; Msg: PChar): Boolean;
var
  S, S1: array[0..MsgLen] of Char;
begin
  ErrorMsg := True;
  StrCopy(S, 'Return Code: ');
  Str(Error:5, S1);
  StrCat(S, S1);
  StrCat(S, Msg);
  StrCat(S, GetErrorMessage(Error, S1));
  if Error <> 0 then begin
    MessageBox(0, S1, 'Information', mb_OK);
    ErrorMsg := False;
  end;
end;

function OpenWave(FileName: Pchar): Boolean;
var
  OpenParms: TMci_Open_Parms;
  Style: LongInt;
  Result: LongInt;
  S1: array [0..MsgLen] of Char;
begin
  OpenWave := True;
  OpenParms.lpstrDeviceType := 'WaveAudio';
  OpenParms.lpstrElementName := FileName;
  Style := Mci_Open_Type or Mci_Open_Element;
  Result := MciSendCommand(0, MCI_OPEN, Style, LongInt(@OpenParms));
  if Result <> 0 then begin
    OpenWave := False;
    ErrorMsg(Result, S1);
    exit;
  end;
  wDeviceId := OpenParms.wDeviceID;
end;


function CloseWave: Boolean;
var
  Result: LongInt;
  S1: array[0..MsgLen] of Char;
begin
  CloseWave := True;
  Result := mciSendCommand(wDeviceID, MCI_Close, 0, 0);
  if Result <> 0 then begin
    CloseWave := False;
    ErrorMsg(Result, S1);
    exit;
  end;
end;

function PlayWave: Boolean;
var
  Result: LongInt;
  PlayParms: TMci_Play_Parms;
  S1: array[0..MsgLen] of Char;
begin
  PlayWave := True;
  Result := MciSendCommand(wDeviceID, Mci_Play, Mci_Notify, LongInt(@PlayParms));
  if Result <> 0 then begin
    PlayWave := False;
    ErrorMsg(Result, S1);
    exit;
  end;
end;
end.