


        *****************************************************************
        *                                                               *
        *  TELVOX TELEINFORMATICA     -    VIA F.LLI CAIROLI N. 4-6     *
        *                                  40121 BOLOGNA (ITALIA)       *
        *                                  TEL. +39-51-252784           *
        *                                  FAX. +39-51-252748           *
        *                                  COMPUSERVE 100064,125        *
        *                                                               *
        *****************************************************************
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                             C O D E C                         *
        *                             COmpressor                        *
        *                             DECompressor                      *
        *                                                               *
        *                             user's manual                     *
        *                             ver. 3.10                         *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *****************************************************************
        *                          (C)  1993                            *
        *****************************************************************







        CODEC                   TABLE OF CONTENTS               PAG.    I




                      T A B L E  O F  C O N T E N T S 


        WARNINGS ...........................................   PAG.    II
        LIST OF SYMBOLS USED ...............................   PAG.   III
        MANUAL'S STRUCTURE .................................   PAG.    IV
        INTRODUCTION .......................................   PAG.     V

        CODEC'S GENERAL FUNCTIONS   

             Product's use .................................   TBL. 00.01

             Description of commands .......................   TBL. 01.01
             - A       (adding without compression) ........   TBL. 01.02
             - C(n)    (compression) .......................   TBL. 01.03
             - CH      (compression help) ..................   TBL. 01.04
             - D       (decompression) .....................   TBL. 01.05
             - DB      (binary decompression) ..............   TBL. 01.06
             - K       (deletion) ..........................   TBL. 01.07
             - V       (display) ...........................   TBL. 01.08
             - VS      (display/sort) ......................   TBL. 01.09
             - X       (crc check) .........................   TBL. 01.10

             Description of options ........................   TBL. 02.01
             - A       (queues decompressed file) ..........   TBL. 02.02
             - D       (selection for date) ................   TBL. 02.03
             - E<file> (file outcome) ......................   TBL. 02.04
             - ED      (default outcome) ...................   TBL. 02.05
             - KF      (deletes file after compression) ....   TBL. 02.06
             - M       (running of subpath) ................   TBL. 02.07
             - NN<file>(changes file name) .................   TBL. 02.08
             - NP<path>(changes path name) .................   TBL. 02.09
             - O       (enables overwrite) .................   TBL. 02.10
             - PF<pw>  (file password) .....................   TBL. 02.11
             - PL<pw>  (library password) ..................   TBL. 02.12
             - PLN<pw> (changes library password) ..........   TBL. 02.13
             - Q       (reduces results' format) ...........   TBL. 02.14
             - S       (silence mode) ......................   TBL. 02.15
             - T<txt>  (file's free text) ..................   TBL. 02.16

        APPENDIX 
         
        CODEC ERRORS
             List of error codes and messages ..............   TBL.  A.01
             Description of error codes and messages .......   TBL.  A.02











        CODEC                      WARNINGS                     PAG.   II













         


                                   WARNINGS 


        The   information   contained  in  this  manual  is  subject   to 
        modification without prior notification.

        TELVOX TELEINFORMATICA shall not be held responsible for eventual 
        errors contained in this document,  nor of damage that may derive 
        from them.

        All  information  contained  in  this  document  is  subject   to 
        copyright.  All rights reserved. 
































        CODEC                     LIST OF SYMBOLS               PAG.  III



        LIST OF SYMBOLS USED   


        CMP       =    Compression 

        CODEC     =    Compressor/Decompressor 

        CRC       =    Cyclic Redundancy Check

        DCP       =    Decompression 

        DES       =    Data Encryption Standard

        KB        =    Kilo Bytes

        PAG       =    Page  

        RAM       =    Random Access Memory

        TBL       =    Table 





































        CODEC                     STRUCTURE OF MANUAL           PAG.   IV



        STRUCTURE OF MANUAL 


        This  manual  contains  the  description of the  uses  for  CODEC 
        (COmpressor/DECompressor).  It indicates which operations can  be 
        executed  and how they should be run.   It is organized in such a 
        way   that  its  reading  or  consultation  may  be  a   faithful 
        reproduction of what can be run effectively.

        The manual is subdivided into three sections. In :

             -    the  first section general information is provided  for 
                  the most effective use of the manual;

             -    the  second  section  the  general  functions  and  the 
                  commands   available   in   CODEC  (package   for   the 
                  compression    and    decompression    activity)    are 
                  analytically illustrated;
             
             -    the  third   section the appendixes pertaining  to  the 
                  list  of error codes and messages in the CODEC  package 
                  are contained.

        Each  section  of the manual is set up in tables for  quick  con-
        sultation  and  for a simpler  maintainance  for  updating.   The 
        heading of each page is presented in this way: 

                                                            chapter code    
                                                                     !
                                                                     !
        CODEC                     COMMANDS                    TBL.  00.07
         !                         !                          PAG.  01/10
         !                         !                                !  !
        product name               !                                !  !
                                   !                                !  !
                                  chapter                           !  !
                                                                    !  !
                                                                    !  !
                                       page number within the chapter  !
                                                                       !
                                           total number of chapter pages 
















        CODEC                     INTRODUCTION                  PAG.    V



        INTRODUCTION


        CODEC  is a software package that focuses on the  non-destructive 
        compression/decompression  and the encryption/deciphering of  one 
        or more files in the same work session.

        CODEC is characterized by the following:

             -    it is written entirely in "C" language according to the 
                  ANSI standard;

             -    it belongs to the family of software packages that  can  
                  operate  with the same modes in different  environments 
                  (it  is  possible  to compress/encrypt in  MVS  and  to 
                  decompress/decipher in AS400 or in PC-DOS);

             -    it   operates   with  compressed  and  encrypted   file 
                  libraries  in  proprietary  format,  transferable  into 
                  different operating systems;

             -    it executes a highly efficient compression  (from 1  to 
                  50  times)  by means of proprietary algorithms such  as 
                  HPBS (High Performance Bits Shrinker) and    T-DES type 
                  cryptography   (Timing  - Data   Encryption   Standard)       
                  with unlocking probability equal to about 10 ^ -150;

             -    it allows type of compression with less use of CPU  and 
                  less  efficiency in compression or with more  intensive   
                  CPU use and better results in compression;

             -    it  decompresses  in  one fourth the time it  takes  to 
                  compress; 

             -    it compresses/decompresses and simultaneously encrypts-
                  /deciphers  data in a single step  in  read/write  mode  
                  to guarantee a swift work execution;

             -    it is executed in command-line-driven mode;

             -    it gives back a return code;

             -    it operates with libraries of compressed files;














        CODEC                     INTRODUCTION                  PAG.   VI



             -    it guarantees  the integrity of the compressed files by 
                  means   of  a  triple 16-bit and  32-bit  crc  (library 
                  heading => 16-bit crc ;  compressed file heading => 16-
                  bit; compressed data file => 32-bit crc);

             -    it  interfaces the physical format of the data to  make 
                  the  informative flow  inside  a particular environment 
                  or between  different  but interconnected  environments 
                  transparent;

             -    it operates with a double password,  one for access  to 
                  the  compressed/encrypted file library and a second for 
                  each specific compressed/encrypted file.   The  library 
                  and file password may be as large as 255 characters and 
                  be written in character mode or in hexadecimal format; 
         
             -    it encrypts  a file using the password indicated by the 
                  operator for the access to the file itself;

             -    it  creates  a random access password for the  file  in 
                  case it has  not been  attributed  before,  in order to 
                  activate the cryptography function;
             
             -    it  encrypts  the same file with the same password in a 
                  different  way if it happens at a different time;

             -    it  runs  up  to  a  maximum  of  5000  compressed  and 
                  encrypted files in each library.





























        *****************************************************************
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                          C O D E C                            *
        *                                                               *
        *                      GENERAL FUNCTIONS                        *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *****************************************************************







        CODEC                     USE                         TBL.  00.01
                                                              PAG.  01/08



        PRODUCT'S USE    


        CODEC  is a software package that focuses on the  non-destructive 
        compression/decompression  and the encryption/deciphering of  one 
        or more files in the same work session.

        It can be executed :

             -    in interactive mode;

             -    in batch mode;

             -    by  means of a generalized call done through the user's 
                  program.

        CODEC is structured in eight areas:

             -    nucleus:  compression/decompression   and   encryption-
                  /deciphering operability;

             -    command  filter:  syntactic analysis,  running of  com-
                  mands  and passage of parameters to functions;

             -    i/o   library :  running  of single or multiple activi-
                  ties  in  the library by means of wildcard (  insertion 
                  of  compressed file;  extraction  of file to be  decom-
                  pressed through  standard  or binary mode;  deletion of 
                  file;  display  of compressed  file's  characteristics;  
                  running  of host path name and file name;  verification 
                  of file's pre-existence);

             -    i/o  file system :  running of the  physical  characte-
                  ristics  of the file  to  be compressed or decompressed  
                  in   different  operating systems  (file  organization; 
                  record format; record length; block size; conversion of 
                  the files format into a different  environment than the 
                  original; ascii-ebcdic/ebcdic-ascii conversion);

             -    check :  verification  of  the library crc's status and  
                  of the compressed files;

             -    security  :    running  of  an access password for  the  
                  library   of  compressed  files  and  of  the  specific 
                  password for each compressed file;











        CODEC                     USE                         TBL.  00.01
                                                              PAG.  02/08



             -    journal :   the creation of a journal of the activities 
                  done and the saving of the results of the work entered;

             -    harmonization :  the  possibility of not displaying the 
                  package's messages on the monitor.


        In  order to run CODEC there are certain commands that need to be 
        used  to  pass  the  parameters that  give  instructions  on  the 
        operations to be executed and on how they should be executed.

        To  list the different commands and options type CODEC and  press 
        RETURN :








        (C) 1993 CODEC - COmpressor DECompressor  Ver. 3.XX
        TELVOX TELEINFORMATICA - Via F.lli Cairoli n. 4-6 
                                 40121 Bologna (Italia)
                                 Tel. +39-51-252784    
                                 Fax. +39-51-252748    
                                 Compuserve 100064,125

        USE: CODEC <COMMAND> <LIBRARY> <FILE> (OPTIONS)

        COMMANDS:
        -A    = Adds file without compression    -K  = Deletes file in library
        -C(n) = Compresses file                  -V  = Displays information
        -CH   = Help for type of compression     -VS = Displays/sorts information
        -D    = Decompresses file                -X  = Checks file crc
        -DB   = Decompresses file in binary
        OPTIONS:
        -A         = Queues decompressed file    -NN <file> = Changes file name
        -D         = Date AAAA/MM/GG:HH:MM:SS    -NP <path> = Changes file path
                     date,       = greater       -O         = Enables overwriting
                     ,date       = lesser        -PF  <pw>  = File password
                     date        = equal         -PL  <pw>  = Library password
                     date1,date2 = range         -PLN <pw>  = Change library password
        -E  <file> = Results on user file        -Q         = Reduces result format
        -ED        = Results on ESITO file       -S         = Silence mode
        -KF        = Deletes file after cmp      -T   <txt> = Associates text to file
        -M         = Enables running of subpath









        CODEC                     USE                         TBL.  00.01
                                                              PAG.  03/08



        Before  executing  the indicated functions on the  command  line, 
        CODEC  runs  a  syntactic check on past parameters  and  in  case 
        incongruences are found, it indicates them by means of a code and 
        appropriate error message.

        If,  for  example,  there is an attempt to compress an inexistent 
        file, the following image will appear on screen:


















        (C) 1993 CODEC - COmpressor DECompressor  Ver. 3.XX
        TELVOX TELEINFORMATICA - Via F.lli Cairoli n. 4-6 
                                 40121 Bologna (Italia)
                                 Tel. +39-51-252784    
                                 Fax. +39-51-252748    
                                 Compuserve 100064,125



             
             RESULT    = (45)    IMPOSSIBLE TO OPEN FILE IN READ MODE      
                           !     !
                           !     !
                           !     !
                           !     !
                           !     error message      
                           !
                           !
                           error code      












        CODEC                     USE                         TBL.  00.01
                                                              PAG.  04/08



        CODEC   has  been  designed  to  operate  with  compressed   file 
        libraries.  This necessitates an articulated running of the:

             -    file name; 

             -    multiple operation by means of wildcard.

        The  original  file name is always conserved during any  and  all 
        data  processing  executed  by CODEC and is subdivided  into  two 
        parts:

             -    path name;
             
             -    file name.

        The path name contains all information regarding the localization 
        of  a  file in different operating systems  (directory,  library, 
        multi member file, etc...).

        The file name refers to the physical file name (file name, member 
        name, etc...).

        Multiple  operation by means of wildcard tends to facilitate  the 
        use  of  the  package,  allowing  for the  execution  of  several 
        activities with a single command.

        Wildcard  has  an effect only on the individual file name for all  
        elaborative  activities  within  the  library,  on  files  to  be 
        compressed within the library and during the decompression  phase 
        on  files  that must be allocated from the library into the  host 
        operating system. 

        Wildcard's logic will function with the following options:

             -    *    (select all)

             -    A*   (select everything that begins with 'A')

             -    *A   (select everything that ends with 'A')

             -    *A*  (select everything that includes 'A')

             -    A*B* (select everything that includes 'A' and 'B')

        In  addition,  it  is possible to use the ?  symbol to  select  a 
        character in terms of its positioning, even in context to *:

              -       A??B*C








        CODEC                     USE                         TBL.  00.01
                                                              PAG.  05/08



        In  order  to  compress  a file it is necessary  to  execute  the 
        following operative steps:


        STEP  1   =    Select a file to be compressed and decide in which 
                       library it must be compressed (e.g. MOVIMENTI file 
                       to  be  compressed  and  DATI.LIB  library   name)        

        STEP  2   =    Enter with the keyboard :

                       CODEC  -C  DATI.LIB   MOVIMENTI 


        At the end of a compression that has been executed  successfully, 
        the following message appears on screen:






        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        Compressed File Name      Orig.Size Comp.Size  %Cmp  Time Kb/Sec
        ----------------------------------------------------------------
        MOVIMENTI                    207420     13143  93.7     7   29.2
        ----------------------------------------------------------------
        CoDec Library Name        Orig.Size Comp.Size  %Cmp Files Number
        ----------------------------------------------------------------
        DATI.LIB                     461892     38286  91.7     3
        ----------------------------------------------------------------

        RESULT = (0) OK


















        CODEC                     USE                         TBL.  00.01
                                                              PAG.  06/08



        COMMENTS  :

        the screen display is divided into three areas :


        COMPRESSED FILE:

             Orig. Size     =    Original file size in bytes

             Comp. Size     =    Byte size of the compressed file

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lc * 100) / lo)

             Time           =    Elapsed  time  in seconds to compress  a 
                                 file       

             Kb/Sec         =    Kilo bytes compressed in a second 


        LIBRARY :

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code        
                                 and a corresponding message  













        CODEC                     USE                         TBL.  00.01
                                                              PAG.  07/08



        In order to execute the decompression of a file it is necessary to
        follow these operative steps:


        STEP   1  =    Select the file to be decompressed and decide from 
                       which library it should be decompressed (e.g. file 
                       to  be  decompressed  MOVIMENTI and  library  name 
                       DATI.LIB)


        STEP  2   =    Write with the keyboard 

                       CODEC  -D  DATI.LIB   MOVIMENTI


        At the end of the successful decompression process, the following 
        will appear on the screen :



                       



        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        Compressed File Name      Comp.Size Orig.Size  %Dcp  Time Kb/Sec
        ----------------------------------------------------------------
        MOVIMENTI                   13143    207420  1478.2     7   29.2
        ----------------------------------------------------------------
        CoDec Library Name      Comp.Size Orig.Size   %Dcp  Files Number
        ----------------------------------------------------------------
        DATI.LIB                    38286    461892  1106.4     3
        ----------------------------------------------------------------


        RESULT  = (0) OK














        CODEC                     USE                         TBL.  00.01
                                                              PAG.  08/08

                

        COMMENTS  :

        the screen display is divided into three areas :


        DECOMPRESSED FILE:

             Comp. Size     =    Byte size of the compressed file

             Orig. Size     =    Original file size in bytes

             % Dcp          =    Percentage of decompression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lo * 100) / lc)

             Time           =    Elapsed time in seconds to decompress  a 
                                 file       

             Kb/Sec         =    Kilo bytes decompressed in a second 


        LIBRARY :

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             % Dcp          =    Average  percentage of decompression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code 
                                 and a corresponding message  













        CODEC                     COMMANDS                    TBL.  01.01
                                                              PAG.  01/01



        DESCRIPTION OF COMMANDS


        In  order to activate CODEC there are certain commands that  need 
        to  be used to pass the parameters that give instructions on  the 
        operations to be executed and on how they should be executed.

        Within the line of commands, parameters inside brackets < > are
        obligatory while those in parentheses ( ) are optional. 

        Obligatory parameters always precede optional ones.      

        Each parameter can be written either in cap letters or lower case 
        and  should  be separated from the following one by at least  one 
        space.

        Obligatory parameters are :

             -    Command

             -    Library Name 

             -    File Name 

        The sequence of obligatory parameters passed onto CODEC should be 
        the following :

             -    Position  1    :    Command
             -    Position  2    :    Library Name 
             -    Position  3    :    File Name


                            Position  1     Position  2     Position  3
        ----------------------------------------------------------------
        EG :     CODEC      <COMMAND>       <LIBRARY>       <FILE>

        The following are commands through which it is possible to run a  
        vast  series of operations during the compression, decompression
        or compressed file library maintenance phases :

             -    A         =    Adding file without compression
             -    C(n)      =    Compresses file
             -    CH        =    Help for type of compression 
             -    D         =    Decompresses file
             -    DB        =    Decompresses file in binary mode
             -    K         =    Deletes file
             -    V         =    Displays information 
             -    VS        =    Displays information/sort
             -    X         =    Checks crc file







        CODEC                     COMMANDS                    TBL.  01.02
                                                              PAG.  01/03



        COMMAND  -A  (adding without compression)


        PURPOSE       

        Adding  a  file  inside a CODEC library without  compression  and 
        encryption. 


        TYPE

        Obligatory.


        SYNTAX

        CODEC  -A  <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    KF deletes file after compression ........ (cfr. TBL. 02.06)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    NN<file> changes file name ............... (cfr. TBL. 02.08)
        -    NP<path> changes path name ............... (cfr. TBL. 02.09)
        -    O enables overwrite ...................... (cfr. TBL. 02.10)
        -    PF<pw> file password ..................... (cfr. TBL. 02.11)
        -    PL<pw> library password .................. (cfr. TBL. 02.12)
        -    PLN<pw> changes library password ......... (cfr. TBL. 02.13)
        -    S silence mode ........................... (cfr. TBL. 02.15)
        -    T<txt> file free text .................... (cfr. TBL. 02.16)


        EXAMPLE

        CODEC     -A        DATI.LIB  MOV.DAT
        CODEC     -A        DATI.LIB  MOV.DAT  -E    LOG.TXT


        COMMENTS 

        The  "-A"  command  allows the adding of one or more files  in  a 
        library of compressed files whithout compression and encryption.










        CODEC                     COMMANDS                    TBL.  01.02
                                                              PAG.  02/03



        When the product is run with the command :

        CODEC  -A  DATI.LIB   MOVIMENTI

        at  the  end  of the successful  adding  process,  the  following 
        appears on the screen :


        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        Compressed File Name       Orig.Size Comp.Size %Cmp Time  Kb/Sec
        ----------------------------------------------------------------
        MOVIMENTI                    207420    207420   0.0     7   29.2
        ----------------------------------------------------------------
        CoDec Library Name         Orig.Size Comp.Size %Cmp Files Number
        ----------------------------------------------------------------
        DATI.LIB                     461892    245706  46.8     3
        ----------------------------------------------------------------

        RESULT = (0) OK


        COMMENTS :

        the screen display is divided into three areas :


        COMPRESSED FILE:

             Orig. Size     =    Original file size in bytes

             Comp. Size     =    Byte size of the compressed file

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lc * 100) / lo)

             Time           =    Elapsed  time  in seconds to compress  a 
                                 file       

             Kb/Sec         =    Kilo bytes compressed in a second 







        CODEC                     COMMANDS                    TBL.  01.02
                                                              PAG.  03/03



        LIBRARY :

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code        
                                 and a corresponding message  





































        CODEC                     COMMANDS                    TBL.  01.03
                                                              PAG.  01/03



        COMMAND  -C(n)  (compression)


        PURPOSE       

        Compression/encryption of a file inside a library.


        TYPE

        Obligatory.


        SYNTAX

        CODEC  -C  <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    KF deletes file after compression ........ (cfr. TBL. 02.06)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    NN<file> changes file name ............... (cfr. TBL. 02.08)
        -    NP<path> changes path name ............... (cfr. TBL. 02.09)
        -    O enables overwrite ...................... (cfr. TBL. 02.10)
        -    PF<pw> file password ..................... (cfr. TBL. 02.11)
        -    PL<pw> library password .................. (cfr. TBL. 02.12)
        -    PLN<pw> changes library password ......... (cfr. TBL. 02.13)
        -    S silence mode ........................... (cfr. TBL. 02.15)
        -    T<txt> file free text .................... (cfr. TBL. 02.16)


        EXAMPLE

        CODEC     -C        DATI.LIB  MOV.DAT
        CODEC     -C        DATI.LIB  MOV.DAT  -E    LOG.TXT


        COMMENTS 

        Command  "-C" may be followed by values from 1 to 9.  The default 
        value is 5.  At lower values (1-4) the compression will be faster 
        but  less efficient.  At higher values (6-9) the  compression  is 
        slower but more efficient.









        CODEC                     COMMANDS                    TBL.  01.03
                                                              PAG.  02/03



        Through command "-C" it is possible to execute a high  efficiency 
        compression   (from  1  to  50  times)  by  means  of  propietary 
        algorithms  such as HPBS (High Performance Bits Shrinker) and  T-
        DES  type cryptography (Timing - Data Encryption  Standard)  with 
        unlocking probability equal to about 10 ^ -150.

        In    order    to    guarantee   a    swift    execution,    data 
        compression/encryption takes place in a single step in read/write 
        mode.

        The T-DES (Timing-Data Encryption Standard) algorithm is accessed 
        through  a default password or with a password specified  by  the 
        user.

        When the product is run with the command :

        CODEC  -C  DATI.LIB   MOVIMENTI

        at  the end of the successful compression process,  the following 
        appears on the screen :


        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        Compressed File Name       Orig.Size Comp.Size %Cmp Time  Kb/Sec
        ----------------------------------------------------------------
        MOVIMENTI                    207420     13143  93.7     7   29.2
        ----------------------------------------------------------------
        CoDec Library Name         Orig.Size Comp.Size %Cmp Files Number
        ----------------------------------------------------------------
        DATI.LIB                     461892     38286  91.7     3
        ----------------------------------------------------------------

        RESULT = (0) OK

















        CODEC                     COMMANDS                    TBL.  01.03
                                                              PAG.  03/03



        COMMENTS :

        the screen display is divided into three areas :


        COMPRESSED FILE:

             Orig. Size     =    Original file size in bytes

             Comp. Size     =    Byte size of the compressed file

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lc * 100) / lo)

             Time           =    Elapsed  time  in seconds to compress  a 
                                 file       

             Kb/Sec         =    Kilo bytes compressed in a second 

        LIBRARY :

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 

        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code        
                                 and a corresponding message  















        CODEC                     COMMANDS                    TBL.  01.04
                                                              PAG.  01/02



        COMMAND  -CH  (help for type of compression)


        PURPOSE

        Display of the types of compression available.           


        TYPE

        Obligatory. 


        SYNTAX  

        CODEC  -CH


        ACTIVE OPTIONS

        None.   


        EXAMPLE

        CODEC     -CH


        COMMENTS 

        The -CH command displays on screen the following available models 
        of compression:


        !------------------------------------------------------------!
        !    TYPE      COMPRESSION      SPEED        COMMENT         !
        !------------------------------------------------------------!
        !     1        Minimum          Maximum                      !
        !     2                                                      !
        !     3                                                      !
        !     4                                                      !
        !     5        Medium           Medium       Default         !
        !     6                                                      !
        !     7                                                      !
        !     8                                                      !
        !     9        Maximum          Minimum                      !
        !    10-99                                   Reserved        !
        !------------------------------------------------------------!








        CODEC                     COMMANDS                    TBL.  01.04
                                                              PAG.  02/02



        CODEC  is currently being released with  an occupation of 380  kb 
        for the variable area.  

        It  is  nonetheless  possible  to  request  and  obtain  specific 
        versions using less RAM.



















































        CODEC                     COMMANDS                    TBL.  01.05
                                                              PAG.  01/03



        COMMAND  -D  (decompression)


        PURPOSE

        Decompression/deciphering of a file from a library.  


        TYPE

        Obligatory. 


        SYNTAX  

        CODEC  -D  <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    A queues decompressed file ............... (cfr. TBL. 02.02)
        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    NN<file> changes file name ............... (cfr. TBL. 02.08)
        -    NP<path> changes path name ............... (cfr. TBL. 02.09)
        -    O enables overwrite ...................... (cfr. TBL. 02.10)
        -    PF<pw> file password ..................... (cfr. TBL. 02.11)
        -    PL<pw> library password .................. (cfr. TBL. 02.12)
        -    S silence mode ........................... (cfr. TBL. 02.15)


        EXAMPLE

        CODEC     -D        DATI.LIB  MOV.DAT
        CODEC     -D        DATI.LIB  MOV.DAT  -E    LOG.TXT


        COMMENTS 

        Command  "-D" allows for the decompression/dechipering of one  or 
        more  files  from  one  library  of  compressed/encrypted   files 
        regardless   the   environment  of  origin.    If  the  file   is 
        decompressed in the same environment in which it was  compressed, 
        the same characteristics of the original file are repristined.  










        CODEC                     COMMANDS                    TBL.  01.05
                                                              PAG.  02/03



        If  the  file comes from a different environment,  the  receiving 
        file system will be interfaced with its eventual conversion  into 
        ascii-ebcdic/ebcdic-ascii.


        When running the product with the command :

        CODEC  -D  DATI.LIB   MOVIMENTI

        at the end  of the successful decompression activity,  the screen 
        will display the following :







        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748




        Compressed File Name     Comp.Size Orig.Size   %Dcp Time  Kb/Sec
        ----------------------------------------------------------------
        MOVIMENTI                   13143    207420  1478.2    7    29.2
        ----------------------------------------------------------------
        CoDec Library Name       Comp.Size Orig.Size   %Dcp Files Number
        ----------------------------------------------------------------
        DATI.LIB                    38286    461892  1106.4    3
        ----------------------------------------------------------------

        RESULT = (0) OK



















        CODEC                     USE                         TBL.  01.05
                                                              PAG.  03/03



        COMMENTS  :

        the screen display is divided into three areas :


        DECOMPRESSED FILE:

             Comp. Size     =    Byte size of the compressed file

             Orig. Size     =    Original file size in bytes

             % Dcp          =    Percentage of decompression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lo * 100) / lc)

             Time           =    Elapsed time in seconds to decompress  a 
                                 file       

             Kb/Sec         =    Kilo bytes decompressed in a second 


        LIBRARY :

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             % Dcp          =    Average  percentage of decompression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code 
                                 and a corresponding message  
                












        CODEC                     COMMANDS                    TBL.  01.06
                                                              PAG.  01/03



        COMMAND  -DB  (binary decompression)


        PURPOSE

        Decompression/deciphering  in  binary  mode  of  a  file  from  a 
        library.  

        TYPE

        Obligatory.


        SYNTAX  

        CODEC  -DB  <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    A queues decompressed file ............... (cfr. TBL. 02.02)
        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    NN<file> changes file name ............... (cfr. TBL. 02.08)
        -    NP<path> changes path name ............... (cfr. TBL. 02.09)
        -    O enables overwrite ...................... (cfr. TBL. 02.10)
        -    PF<pw> file password ..................... (cfr. TBL. 02.11)
        -    PL<pw> library password .................. (cfr. TBL. 02.12)
        -    S silence mode ........................... (cfr. TBL. 02.15)


        EXAMPLE

        CODEC     -DB       DATI.LIB  MOV.DAT
        CODEC     -DB       DATI.LIB  MOV.DAT  -E    LOG.TXT


        COMMENTS  

        The  "-DB"  command is operable only to decompress a file from  a 
        different  environment of which possible  control  characters  of 
        the  original  file  are  not  desired to  be  converted nor  the 
        ascii-ebcdic/ebcdic-ascii conversion obtained.











        CODEC                     COMMANDS                    TBL.  01.06
                                                              PAG.  02/03



        When executing the product with the command:

        CODEC  -DB  DATI.LIB   MOVIMENTI

        at the end of the successful decompression session, the following 
        will appear on screen:











        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748



        Compressed File Name     Comp.Size Orig.Size   %Dcp Time  Kb/Sec
        ----------------------------------------------------------------
        MOVIMENTI                   13143    207420  1478.2     7   29.2
        ----------------------------------------------------------------
        CoDec Library Name       Comp.Size Orig.Size   %Dcp Files Number
        ----------------------------------------------------------------
        DATI.LIB                    38286    461892  1106.4     3
        ----------------------------------------------------------------

        RESULT = (0) OK





















        CODEC                     USE                         TBL.  01.06
                                                              PAG.  03/03



        COMMENTS  :

        the screen display is divided into three areas :

        DECOMPRESSED FILE:

             Comp. Size     =    Byte size of the compressed file

             Orig. Size     =    Original file size in bytes

             % Dcp          =    Percentage of decompression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lo * 100) / lc)

             Time           =    Elapsed  time in seconds to decompress a 
                                 file       

             Kb/Sec         =    Kilo bytes decompressed in a second 


        LIBRARY :

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             % Dcp          =    Average  percentage of decompression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code 
                                 and a corresponding message  














        CODEC                     COMMANDS                    TBL.  01.07
                                                              PAG.  01/03



        COMMAND  -K  (deletion)


        PURPOSE

        Deletion of a file from a library.


        TYPE

        Obligatory.


        SYNTAX  

        CODEC  -K  <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    PF<pw> file password ..................... (cfr. TBL. 02.11)
        -    PL<pw> library password .................. (cfr. TBL. 02.12)
        -    PLN<pw> changes library password.......... (cfr. TBL. 02.13)
        -    S silence mode ........................... (cfr. TBL. 02.15)


        EXAMPLE

        CODEC     -K        DATI.LIB  MOV.DAT
        CODEC     -K        DATI.LIB  MOV.DAT  -E    LOG.TXT


        COMMENTS  

        Command -K allows the physical deletion of one or more files from 
        a library of compressed files.
















        CODEC                     COMMANDS                    TBL.  01.07
                                                              PAG.  02/03



        When executing the product with command -K :

        CODEC  -K  DATI.LIB  MOV.DAT

        at  the end of the successful deletion the following will  appear 
        on screen :




        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748



        ----------------------------------------------------------------
        MOV.DAT                                FILE DELETED FROM LIBRARY  
        ---------------------------------------------------------------- 
        Library Name ...... DATI.LIB
        Original Size ..... 202562        Compressed Size ..... 22872
        %Cmp .............. 88.7          Files Number ........ 1
        Creation Date ..... 01/02/91      Last Update ......... 06/02/92 
        Password .......... NO            CoDec Version ....... 3.xx
        ----------------------------------------------------------------

        RESULT = (0) OK



























        CODEC                     COMMANDS                    TBL.  01.07
                                                              PAG.  03/03



        COMMENTS  :

        the screen display is divided into three areas :

        DELETED FILE:

             File Name      =    Name of deleted file    

        LIBRARY :

             Library Name   =    Name of the library

             Orig.  Size    =    Original  byte size of files present  in          
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 

             Creation Date  =    Date of library creation

             Last Update    =    Date of last library update

             Password       =    Existence  of an access password to  the   
                                 library by means of a YES/NO condition 

             CoDec Version  =    CoDec Version 

                                      
        OUTCOME :

             Result         =    Outcome  represented by a  numeric  code 
                                 and a corresponding message  


















        CODEC                     COMMANDS                    TBL.  01.08
                                                              PAG.  01/07



        COMMAND  -V  (display)


        PURPOSE

        Display of a file's characteristics in a library according to the 
        chronological order of the entries.


        TYPE

        Obligatory.


        SYNTAX  

        CODEC  -V   <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    Q reduces format results ................. (cfr. TBL. 02.14) 
        -    S silence mode ........................... (cfr. TBL. 02.15)


        EXAMPLE

        CODEC     -V        DATI.LIB  MOV.DAT
        CODEC     -V        DATI.LIB  *.DAT  -E    LOG.TXT   -Q


        COMMENTS  

        Command  -V allows the display of the characteristics of one file 
        or  more in a given library according to the chronological  order 
        of the entry.  The display can be whole or partial.

        In the "Compression type" field there may appear values from 1 to 
        9,  98 and 99. Value 98 indicates that the file has been inserted 
        with command "-A".  Value 99 indicates that the file,  at the end 
        of the compression, resulted not compressable.          











        CODEC                     COMMANDS                    TBL.  01.08
                                                              PAG.  02/07



        When executing the product with command -V :

        CODEC  -V  DATI.LIB  MOV.DAT

        at the end of the successful complete mode display, the following 
        will appear on screen :



        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748



        ----------------------------------------------------------------
        File Name ............ MOV.DAT
        Original Size ........ 207420      Compressed Size .... 13176
        %Cmp ................. 93.6        Compression Type ... 05
        CRC 32 ............... A5F7B201    Compression Date ... 06/02/92 
        File Attributes ...... *-*-*       Orig. File Date .... 04/12/91 
        File Organization .... PS          Record Format ...... FB
        Record Size .......... 80          Block Size ......... 6240
        Orig. Environment .... MVS         Password ........... YES
        Text ................. Mov. bolle             
        ----------------------------------------------------------------
        Library Name ......... DATI.LIB
        Original Size ........ 202562      Compressed Size .... 22872
        %Cmp ................. 88.7        Files Number ....... 1
        Creation Date ........ 01/02/92    Last Update ........ 06/02/92
        Password ............. NO          CoDec Version ...... 3.xx
        ----------------------------------------------------------------

        RESULT = (0) OK




















        CODEC                     COMMANDS                    TBL.  01.08
                                                              PAG.  03/07



        COMMENTS  :

        the screen display is divided into three areas :

        DISPLAYED FILE :

             File Name      =    Name of displayed file    

             Original Size  =    Original size of file in bytes

             Comp. Size     =    Compressed size of file in bytes

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original size of file
                                 lc = compressed size of file    
                                 abs(100 - (lc * 100) / lo)

             Cmp. Type      =    Model of compression used          

             Crc32          =    Exadecimal   representation   of   Crc32     
                                 that  certifies  the  data area  of  the 
                                 compressed file

             Compr. Date    =    Date and hour of file compression   

             File Attributes=    File attributes   

             Or. File Date  =    Original date in which the file has been 
                                 created.   In case the environment  does   
                                 not  permit the feedback of information,     
                                 the  field  will  contain  the  date  of 
                                 origin   of   the   original    (source) 
                                 operating system

             File Org.      =    File organization      

             Record Format  =    Record's format     

             Record Size    =    Record's size      

             Block Size     =    Record's blockage size             

             Environment     =   Environment  in  which  compression  has             
                                 been executed











        CODEC                     COMMANDS                    TBL.  01.08
                                                              PAG.  04/07



             Password       =    The  existence of an access password  to   
                                 the file by means of a YES/NO condition

             Text           =    Free  text  corresponding to  the  file,     
                                 within 255 characters


        LIBRARY :

             Library Name   =    Name of the library

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 

             Creation Date  =    Date of library creation

             Last Update    =    Date of last library update

             Password       =    Existence  of an access password to  the   
                                 library by means of a YES/NO condition 

             CoDec Version  =    CoDec Version 


        OUTCOME :

             Result         =    Outcome  represented by a  numeric  code 
                                 and a corresponding message  



















        CODEC                     COMMANDS                    TBL.  01.08
                                                              PAG.  05/07



        When executing the product with the following command  :

        CODEC  -V  DATI.LIB  *.DAT   -Q

        at the end of the successful partial mode display,  the following 
        will appear on screen :




        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748



        ----------------------------------------------------------------
        Compressed File Name       Orig.Size  Comp.Size  %Cmp  Environmt
        ----------------------------------------------------------------
        FATTURE.DAT                   207420      13176   93.6       MVS
        BOLLE.DAT                     202562      22838   88.7     AS400
        ----------------------------------------------------------------
        Library Name ......... DATI.LIB
        Original Size ........ 409982      Compressed Size .... 36065
        %Cmp ................. 91.2        Files Number ....... 2
        Creation Date ........ 01/02/92    Last Update ........ 06/02/92
        Password ............. NO          CoDec Version ...... 3.xx
        ----------------------------------------------------------------

        RESULT = (0) OK
























        CODEC                    COMMANDS                     TBL.  01.08
                                                              PAG.  06/07



        COMMENTS  :

        the screen display is divided into three areas :

        DISPLAYED FILE :

             File Name      =    Name of displayed file    

             Original Size  =    Original size of file in bytes

             Comp. Size     =    Compressed size of file in bytes

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original size of file
                                 lc = compressed size of file    
                                 Formula for calculation of compr.:
                                 abs(100 - (lc * 100) / lo)

             Environment    =    Environment  in which the file has  been   
                                 compressed

        LIBRARY :

             Library Name   =    Name of the library

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 

             Creation Date  =    Date of library creation

             Last Update    =    Date of last library update

             Password       =    Existence  of an access password to  the   
                                 library by means of a YES/NO condition 

             CoDec Version  =    CoDec Version 










        CODEC                    COMMANDS                     TBL.  01.08
                                                              PAG.  07/07



        OUTCOME :

             Result         =    Outcome  represented by a  numeric  code 
                                 and a corresponding message  




















































        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  01/07



        COMMAND  -VS  (display/sort)


        PURPOSE

        Display of a file's characteristics in a library according to the 
        alphabetical  order obtained by the sum of the path name and file 
        name strings.


        TYPE

        Obligatory.


        SYNTAX  

        CODEC  -VS   <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    Q reduces format results ................. (cfr. TBL. 02.14) 
        -    S silence mode ........................... (cfr. TBL. 02.15)


        EXAMPLE

        CODEC     -VS       DATI.LIB    *.DAT
        CODEC     -VS       DATI.LIB    *.DAT  -E    LOG.TXT   -Q


        COMMENTS  

        Command  "-VS"  allows the display of the characteristics of  one 
        file  or  more in a given library according to  the  alphabetical 
        order obtained by the sum of the path name and file name strings.  
        The display can be whole or partial.

        In the "Compression type" field there may appear values from 1 to 
        9,  98 and 99. Value 98 indicates that the file has been inserted 
        with command "-A".  Value 99 indicates that the file,  at the end 
        of the compression, resulted not compressable.          









        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  02/07



        When executing the product with command -VS :

        CODEC  -VS  DATI.LIB  MOV.DAT

        at the end of the successful complete mode display, the following 
        will appear on screen :


        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        ----------------------------------------------------------------
        File Name ............ BOLLE.DAT
        Original Size ........ 202562      Compressed Size .... 22838
        %Cmp ................. 88.7        Compression Type ... 05
        CRC 32 ............... B503A201    Compression Date ... 06/02/92 
        File Attributes ...... *-*-*       Orig. File Date .... 04/12/91 
        File Organization .... DATA        Record Format ...... *-*-*
        Record Size .......... 128         Block Size ......... *-*-*
        Orig. Environment .... AS400       Password ........... YES
        Text ................. Mov. bolle             
        ----------------------------------------------------------------
        Library Name ......... DATI.LIB
        Original Size ........ 409982      Compressed Size .... 13176
        %Cmp ................. 91.2        Files Number ....... 2
        Creation Date ........ 01/02/92    Last Update ........ 06/02/92
        Password ............. NO          CoDec Version ...... 3.xx
        ----------------------------------------------------------------

        RESULT = (0) OK






















        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  03/07



        COMMENTS  :

        the screen display is divided into three areas :


        DISPLAYED FILE :

             File Name      =    Name of displayed file    

             Original Size  =    Original size of file in bytes

             Comp. Size     =    Compressed size of file in bytes

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original size of file
                                 lc = compressed size of file    
                                 abs(100 - (lc * 100) / lo)

             Cmp. Type      =    Model of compression used          

             Crc32          =    Exadecimal representation of Crc32  that 
                                 certifies  the data area of the compres-
                                 sed file

             Compr. Date    =    Date and hour of file compression   

             File Attributes=    File attributes   

             Or. File Date  =    Original date in which the file has been 
                                 created.   In case the environment  does   
                                 not  permit the feedback of information, 
                                 the  field  will  contain  the  date  of 
                                 origin   of   the   original    (source) 
                                 operating system

             File Org.      =    File organization      

             Record Format  =    Record's format     

             Record Size    =    Record's size       

             Block Size     =    Record's blockage size             

             Environment    =    Environment  in  which  compression  has 
                                 been executed










        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  04/07



             Password       =    The  existence of an access password  to   
                                 the file by means of a YES/NO condition

             Text           =    Free  text  corresponding to  the  file,     
                                 within 225 characters


        LIBRARY :

             Library Name   =    Name of the library

             Orig.  Size    =    Original  byte size of files present  in           
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 

             Creation Date  =    Date of library creation

             Last Update    =    Date of last library update

             Password       =    Existence  of an access password to  the   
                                 library by means of a YES/NO condition 

             CoDec Version  =    CoDec Version 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code    
                                 and a corresponding message  



















        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  05/07



        When executing the product with command -VS :

        CODEC  -VS  DATI.LIB  MOV.DAT  -Q

        at the end of the successful complete mode display, the following 
        will appear on screen :





        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        ----------------------------------------------------------------
        Compressed File Name        Orig.Size  Comp.Size  %Cmp Environmt 
        ----------------------------------------------------------------
        BOLLE.DAT                     202562      22838   88.7     AS400
        FATTURE.DAT                   207420      13176   93.6       MVS
        ----------------------------------------------------------------
        Library Name ......... DATI.LIB
        Original Size ........ 409982      Compressed Size .... 36065
        %Cmp ................. 91.2        Files Number ....... 2
        Creation Date ........ 01/02/92    Last Update ........ 06/02/92
        Password ............. NO          CoDec Version ...... 3.xx
        ----------------------------------------------------------------

        RESULT = (0) OK
























        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  06/07



        COMMENTS  :

        the screen display is divided into three areas :

        DISPLAYED FILE :

             File Name      =    Name of displayed file    

             Original Size  =    Original size of file in bytes

             Comp. Size     =    Compressed size of file in bytes

             % Cmp          =    Percentage of compression
                                 Definites
                                 lo = original size of file
                                 lc = compressed size of file    
                                 Formula for calculation of compr.:
                                 abs(100 - (lc * 100) / lo)

             Environment    =    Environment  in which the file has  been   
                                 compressed

        LIBRARY :

             Library Name   =    Name of the library

             Orig.  Size    =    Original  byte size of files present  in            
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 

             Creation Date  =    Date of library creation

             Last Update    =    Date of last library update

             Password       =    Existence  of an access password to  the 
                                 library by means of a YES/NO condition 

             CoDec Version  =    CoDec Version 










        CODEC                     COMMANDS                    TBL.  01.09
                                                              PAG.  07/07



        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code 
                                 and a corresponding message  




















































        CODEC                     COMMANDS                    TBL.  01.10
                                                              PAG.  01/03



        COMMAND  -X  (crc check)


        PURPOSE

        Library, heading and the compressed file's data area crc checks.


        TYPE

        Obligatory.


        SYNTAX  

        CODEC  -X  <Library>  <File>  (Options)


        ACTIVE OPTIONS

        -    D selection for date ..................... (cfr. TBL. 02.03)
        -    E<file> file outcome ..................... (cfr. TBL. 02.04)
        -    ED default outcome ....................... (cfr. TBL. 02.05)
        -    M running of subpath ..................... (cfr. TBL. 02.07)
        -    PF<pw> file password ..................... (cfr. TBL. 02.11)
        -    PL<pw> library password .................. (cfr. TBL. 02.12)
        -    S silence mode ........................... (cfr. TBL. 02.15)


        EXAMPLE

        CODEC     -X        DATI.LIB    *.DAT
        CODEC     -X        DATI.LIB    *.DAT  -E    LOG.TXT   


        COMMENTS  

        Command  "-X"  allows  the  library,  heading  and  one  or  more 
        compressed file's crc check, performing a blank decompression.

        During the crc's check phase, it is recommended to make sure that 
        there  is  sufficient RAM to allocate the variable area that  was 
        necessary  for compression in the environment in which the  check 
        is taking place.












        CODEC                     COMMANDS                    TBL.  01.10
                                                              PAG.  02/03



        When executing the product with command -X :

        CODEC  -X   DATI.LIB  MOV.DAT    

        at the end of the successful crc check, the following will appear 
        on screen :






        (C) 1993 CODEC - COmpressor DECompressor   Ver. 3.XX
        TELVOX TELEINFORMATICA -      Via F.lli Cairoli n. 4-6 
                                      40121 Bologna (Italia)
                                      Tel. +39-51-252784   
                                      Fax. +39-51-252748


        ----------------------------------------------------------------
        Compressed File Name     Comp.Size  Orig.Size  %Dcp    Environmt 
        ---------------------------------------------------------------- 
        MOV.DAT                   13413      207420   1478.2      PC-DOS
        ---------------------------------------------------------------- 
        CoDec Library Name     Orig.size   Comp.Size  %Cmp  Files Number
        ---------------------------------------------------------------- 
        DATI.LIB                 461892       38286   91.7        3
        ---------------------------------------------------------------- 

        RESULT = (0) OK


























        CODEC                     COMMANDS                    TBL.  01.10
                                                              PAG.  03/03


        COMMENTS  :

        the screen display is divided into three areas :


        CHECKED FILE:

             Comp. Size     =    Byte size of the compressed file

             Orig. Size     =    Original file size in bytes

             % Dcp          =    Percentage of decompression
                                 Definites
                                 lo = original file size          
                                 lc = compressed file size        
                                 Formula for calculating compression:
                                 abs(100 - (lo * 100) / lc)

             Environment    =    Environment in which the compression has 
                                 taken place.

        LIBRARY :

             Orig.  Size    =    Original  byte size of files present  in 
                                 library

             Comp. Size     =    Byte size of compressed files present in 
                                 library 

             % Cmp          =    Average  percentage  of  compression  of 
                                 files present in library

             Files Number   =    Total number of compressed files present 
                                 in library 


        OUTCOME :

             Result         =    Outcome  represented  by a numeric  code 
                                 and a corresponding message  

















        CODEC                     OPTIONS                     TBL.  02.01
                                                              PAG.  01/01



        DESCRIPTION OF OPTIONS 

        A  series  of  optional parameters that  further  specialize  the 
        activated  command  can be added to the  commands  that  instruct 
        CODEC  on  operations  to be performed and and how they  must  be 
        executed. 

        Within  the line of commands,  parameters inside brackets < > are 
        obligatory while those in parentheses ( ) are optional. 

        Optional parameters must always follow obligatory ones.      

        Each parameter can be written either in cap letters or lower case 
        and  should  be separated from the following one by at least  one 
        space.               

        CODEC may be executed with the following syntax :

        Position  1     Position  2     Position  3    Position  4
        ----------------------------------------------------------------
        <COMMAND>       <LIBRARY>       <FILE>         <OPTIONS>

        Optional parameters can offer specialized services in addition to 
        basic  functions  run  by commands.  Their use  is  not  tied  to 
        specific  positional  data,  except by being outside the area  of 
        obligatory  parameters.   Optional  parameters are to  be  always 
        inserted  after  the third position in the line of  commands  and 
        separated one from another by at least one space.

        The options available are the following :

             -    A          =   queues decompressed file
             -    D          =   selection for date     
             -    E   <file> =   file outcome
             -    ED         =   default outcome
             -    KF         =   deletes file after compression
             -    M          =   running of subpath
             -    NN  <file> =   changes file name
             -    NP  <path> =   changes path name
             -    O          =   enables overwrite
             -    PF  <pw>   =   file password
             -    PL  <pw>   =   library password 
             -    PLN <pw>   =   changes library password
             -    Q          =   reduces format results
             -    S          =   silence mode
             -    T   <txt>  =   file free text 










        CODEC                     OPTIONS                     TBL.  02.02
                                                              PAG.  01/01



        OPTION   -A (queues decompressed file)


        PURPOSE  

        Allows the queueing of decompressed files in a single file during 
        normal decompression or in binary mode.   

        TYPE

        Optional.


        SYNTAX   

        CODEC  <Command> <Library> <File> -A


        ACTIVE COMMANDS

        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
                    

        EXAMPLE

        CODEC     -D        DATI.LIB  MOV.DAT  -A
        CODEC     -DB       DATI.LIB  MOV.DAT  -A


        COMMENTS

        During  normal  decompression  or in binary  mode,  option   "-A" 
        allows  for the queueing of decompressed files in a  single  file 
        which is created if it does not already exist.





















        CODEC                     OPTIONS                     TBL.  02.03
                                                              PAG.  01/03



        OPTION   -D (selection for date)


        PURPOSE  

        Restricts file selection to files that have a date amd time which 
        is lesser, greater, the same or between two dates.  The following 
        symbols indicate:

             Greater than        YYYY/MM/DD:HH:MM:SS,
             Lesser than         ,YYYY/MM/DD:HH:MM:SS    
             Equal               YYYY/MM/DD:HH:MM:SS
             Range               YYYY/MM/DD:HH:MM:SS,YYYY/MM/DD:HH:MM:SS


        TYPE

        Optional.


        SYNTAX  

        CODEC  <Command> <Library> <File> -D <YYYY/MM/DD:HH:MM:SS>


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
        -    K deletion ............................... (cfr. TBL. 01.07)
        -    V display ................................ (cfr. TBL. 01.08)
        -    VS display/sort .......................... (cfr. TBL. 01.09)
        -    X crc check .............................. (cfr. TBL. 01.10)


        EXAMPLE

        CODEC -C DATI.LIB *.DAT -D 1992/01/01:10:00:00, 
        CODEC -C DATI.LIB *.DAT -D ,1992/01/01:10:00:00
        CODEC -C DATI.LIB *.DAT -D 1992/01/01:10:00:00
        CODEC -C DATI.LIB *.DAT -D 1992/01/01:10:00:00,1993/10/10:00:00:00













        CODEC                     OPTIONS                     TBL.  02.03
                                                              PAG.  02/03



        COMMENTS

        Option  "-D" establishes the date and hour of an original  file's 
        creation  in  a  specific  operating  system  and  restricts  the 
        selection  of  files indicated for execution to dates  and  hours 
        that are greater, lesser, equal to or within two dates.

        After  option  "-D"  it  is necessary to  insert  a  space  which 
        precedes the date and hour selected.

        The date should be formatted in the following manner:

                  YYYY/MM/DD:HH:MM:SS

        where :

                YYYY   =    year
                  MM   =    month
                  DD   =    day   
                  HH   =    hour  
                  MM   =    minute
                  SS   =    second 


        If  a  portion of the date or the hour is composed  of  a  single 
        digit,  a zero should be added to the left of that digit ( 1 must 
        be written as 01).

        The admissible value for:  

             -    the  year (YYYY) must be greater or the same as 1970 or 
                  lesser or the same as 2100;

             -    the  month (MM) must be greater or the same as  01  and           
                  lesser or the same as 12;

             -    the  day  (DD) must be greater or the same as   01  and           
                  lesser  or the same as the number of days of the  month           
                  in question;

             -    the  hour  (HH)  must be greater or equal  to   00  and 
                  lesser or equal to 23;

             -    the  minutes  (MM) must be greater or equal to  00  and 
                  lesser or equal to 59;

             -    the  seconds  (SS) must be greater or equal to  00  and 
                  lesser or equal to 59;








        CODEC                     OPTIONS                     TBL.  02.03
                                                              PAG.  03/03



        It   is   not   necessary   to  write  out  the   date   in   the 
        YYYY/MM/DD:HH:MM:SS  mode.  It is possible to write the date  and 
        hour from the left to right in the following manner:

             -    YYYY/MM/DD:HH:MM:SS
             -    YYYY/MM/DD:HH:MM
             -    YYYY/MM/DD:HH
             -    YYYY/MM/DD
             -    YYYY/MM
             -    YYYY

        The missing values will be filled in case of :

             -    greater   :    starting  from the first second  of  the 
                                 established  fraction of time.  
                                 Examples  :    
                                 "-D  1993,"          1993/01/01:00:00:00  
                                 "-D  1993/02,"       1993/02/01:00:00:00  
                                 "-D  1993/02/10,"    1993/02/10:00:00:00  
                                 "-D  1993/02/10:12," 1993/02/10:12:00:00  

             -    lesser    :    from the last second of the  established 
                                 fraction of time.
                                 Examples  :    
                                 "-D  ,1993"          1993/12/31:23:59:59  
                                 "-D  ,1993/02"       1993/02/28:23:59:59  
                                 "-D  ,1993/02/10"    1993/02/10:23:59:59  
                                 "-D  ,1993/02/10:12" 1993/02/10:12:59:59  

             -    equal     :    from the first to the last second of the 
                                 established fraction of time. 
                                 Examples  :
                                 "-D 1992"      from  1992/01/01:00:00:00     
                                                 to   1992/12/31:23:59:59
                                 "-D 1992/02"   from  1992/02/01:00:00:00     
                                                 to   1992/02/29:23:59:59

             -    range     :    for the starting time,  the first second 
                                 of the established fraction of time will 
                                 be used;  for the ending time,  the last 
                                 second  of the established  fraction  of 
                                 time will be included. 
                                 Examples  :
                                 "-D 1992,1993" from  1992/01/01:00:00:00     
                                                to    1993/12/31:23:59:59











        CODEC                     OPTIONS                     TBL.  02.04
                                                              PAG.  01/05



        OPTION   -E <file> (file outcome)


        PURPOSE

        Writes the journal of work done on a given file of which the name 
        is specified.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -E <file> (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
        -    K deletion ............................... (cfr. TBL. 01.07)
        -    V display ................................ (cfr. TBL. 01.08)
        -    VS display/sort .......................... (cfr. TBL. 01.09)
        -    X crc check .............................. (cfr. TBL. 01.10)
                    

        EXAMPLE

        CODEC     -C        DATI.LIB  MOV.DAT  -E    LOG.TXT  


        COMMENTS

        "-E <file>" option allows the writing of a journal of work run on 
        a file whose name is specified.

        The  file is sequential.   Each record,  208 characters in  size, 
        contains  all the information that allows for a detailed analysis 
        of each execution.












        CODEC                     OPTIONS                     TBL.  02.04
                                                              PAG.  02/05



        The  record  is  structured  into  27  fields  organized  in  the 
        following manner:


             CC   =         Field code  

             CI   =         Initial character 

             CF   =         Final character 

             LU   =         Field size         

             T    =         Type (A=Alphanumeric  N=numeric  B=Blank)

             DE   =         Field description    


        CC   CI   CF        LU   T    DE
        -----------------------------------------------------------------
        01   001  002       002  A    Error code      
        02   003  003       001  B    -
        03   004  063       060  A    Path name
        04   064  064       001  B    -
        05   065  124       060  A    File name 
        06   125  125       001  B    -
        07   126  134       009  N    File size in input
        08   135  135       001  B    -
        09   136  144       009  N    File size in output
        10   145  145       001  B    -
        11   146  151       006  N    % Cmp/Dcp
        12   152  152       001  B    -
        13   153  158       006  N    Elapsed time   
        14   159  159       001  B    -
        15   160  165       006  N    Kb/Sec
        16   166  166       001  B    -
        17   167  174       008  A    File's environment of origin            
        18   175  175       001  B    -
        19   176  177       002  A    Compression model      
        20   178  178       001  B    -
        21   179  186       008  A    File's crc area data
        22   187  187       001  B    -
        23   188  195       008  A    Date
        24   196  196       001  B    -
        25   197  204       008  A    Hour
        26   205  205       001  B    -
        27   206  208       003  A    Presence of password










        CODEC                     OPTIONS                     TBL.  02.04
                                                              PAG.  03/05



        In  the  outcome  file's  record  layout,  all  even  fields  are 
        individual  blanks  that subdivide the  various  information  for 
        greater readability even during the printing phase.

        Odd   numbered   fields  are  those  that   contain   significant 
        information.  Some of these need further clarification :

        FIELD 1 (Error code)

        For  further information on the meaning of specific error  codes, 
        see Appenndix <A> "Error codes and messages".

        FIELD 3 (Path name)

        Contains the path name correlated to the compressed file.

        FIELD 5 (File name)

        Indicates the physical name of the compressed file.

        FIELD 7 (Size of the file in input)

        Defines  the original file size in compression and the compressed 
        file size in decompression.

        FIELD 9 (Size of file in output)

        Defines the compressed file size in compression and the  original 
        file size in decompression.

        FIELD 11 (% Cmp/Dcp)

        Compression  or decompression percentage expressed by means of  a 
        relative value with a decimal.
        Definites
        lo = original file size          
        lc = compressed file size        
        Formula for calculating compression:
        abs(100 - (lc * 100) / lo)
        Formula for calculating decompression:
        abs(100 - (lo * 100) / lc)

        FIELD 13 (Elapsed time)

        The   elapsed  time  of  the  package's  activities   (start-end) 
        expressed in seconds employed to compress or decompress.










        CODEC                     OPTIONS                     TBL.  02.04
                                                              PAG.  04/05



        FIELD 15 (Kb/Sec)

        Execution  speed  in compression or decompression,  expressed  by 
        means of a relative value with a decimal, based on the input file 
        size and the elapsed time.
        Definites
        li = input file size            
        ti = elapsed time 
        Formula for calculation of kb/sec :
        (li / ti)

        FIELD 17 (Environment of origin)

        Indicates in which operating system the file has been compressed.

        FIELD 19 (Compression method)

        Indicates  which of the 100 available compression models has been 
        used.

        FIELD 21 (File crc data area)

        Hexadecimal  representation  of  the Crc-32  that  certifies  the 
        compressed file's data area.

        FIELD 23 (Date)

        Starting date of the compression or decompression.   The date  is 
        displayed in day/month/year format.

        FIELD 25 (Hour)

        The  compression or decompression's starting hour.  The  hour  is 
        displayed in hour:minute:second format.

        FIELD 27 (Presence password)

        Indicates the presence or absence of the password associated with 
        the file by means of YES/NO.




        The  outcome  file is always structured with a  208-byte  record.  
        The fields that make up the record,  depending on the work saved, 
        can be either full or empty.

        With  the  "-C"  (compression),  "-D" (decompression)  and  "-DB" 
        (binary decompression) commands, all fields are full.       







        CODEC                     OPTIONS                     TBL.  02.04
                                                              PAG.  05/05



        With  the "-K" (deletion) command only fields 1 (error  code),  3 
        (path  name),  and 5 (file name) are significant.   The rest  are 
        blank.

        With  the "-X" (crc check),  "-V" (information display)  and  the 
        "-VS"  (information  display/sort)  all  fields  are  significant 
        except  13 (elapsed time) and 15 (kb/sec),  which have been  left 
        blank.
















































        CODEC                     OPTIONS                     TBL.  02.05
                                                              PAG.  01/05



        OPTION -ED (outcome by default)


        PURPOSE

        Writes the journal of work done on the default file named ESITO.


        TYPE

        Optional.


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -ED  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
        -    K deletion ............................... (cfr. TBL. 01.07)
        -    V display ................................ (cfr. TBL. 01.08)
        -    VS display/sort .......................... (cfr. TBL. 01.09)
        -    X crc check .............................. (cfr. TBL. 01.10)


        EXAMPLE

        CODEC     -C        DATI.LIB  MOV.DAT  -ED


        COMMENTS

        Option  "-ED" allows  the writing of a journal to record the work 
        done on the default file named ESITO.

        The file is sequential.   Each 208-character record contains  all 
        the  information  that allows for the detailed analysis  of  each 
        elaboration done.













        CODEC                     OPTIONS                     TBL.  02.05
                                                              PAG.  02/05



        Each  record  is  structured  into 27  fields  organized  in  the 
        following manner:


             CC   =         Field code  

             CI   =         Initial character 

             CF   =         Final character 

             LU   =         Field size          

             T    =         Type (A=Alphanumeric  N=numeric  B=Blank)

             DE   =         Field description    

        CC   CI   CF        LU   T    DE
        -----------------------------------------------------------------
        01   001  002       002  A    Error code      
        02   003  003       001  B    -
        03   004  063       060  A    Path name
        04   064  064       001  B    -
        05   065  124       060  A    File name 
        06   125  125       001  B    -
        07   126  134       009  N    File size in input
        08   135  135       001  B    -
        09   136  144       009  N    File size in output
        10   145  145       001  B    -
        11   146  151       006  N    % Cmp/Dcp
        12   152  152       001  B    -
        13   153  158       006  N    Elapsed time   
        14   159  159       001  B    -
        15   160  165       006  N    Kb/Sec
        16   166  166       001  B    -
        17   167  174       008  A    File's environment of origin   
        18   175  175       001  B    -
        19   176  177       002  A    Compression model      
        20   178  178       001  B    -
        21   179  186       008  A    File crc's data area  
        22   187  187       001  B    -
        23   188  195       008  A    Date
        24   196  196       001  B    -
        25   197  204       008  A    Hour
        26   205  205       001  B    -
        27   206  208       003  A    Presence of password

        In  the  outcome  files'  record  layout  all  even  fields   are 
        individual  blanks  that  subdivide the various  information  for 
        greater legibility even during the printing phase. 







        CODEC                     OPTIONS                     TBL.  02.05
                                                              PAG.  03/05



        Odd fields are those that contain significant information.   Some 
        of these need further clarification :

        FIELD 1 (Error code)

        For further explanation on the meaning of specific error codes    
        cfr. Appendix <A> "Error codes and messages".

        FIELD 3 (Path name)

        Contains the path name correlated to the compressed file.

        FIELD 5 (File name)

        Indicates the physical name of the compressed file.

        FIELD 7 (File size in input)

        Defines   the  original  file's  size  in  compression  and   the 
        compressed file size in decompression.

        FIELD 9 (File size in output)

        Defines  the  compressed  file's  size  in  compression  and  the 
        original file size in in decompression.

        FIELD 11 (% Cmp/Dcp)

        Percentage  of compression or decompression expressed by means of 
        the relative value with a decimal.
        Definites
        lo = original file size          
        lc = compressed file size        
        Formula for calculating compression:
        abs(100 - (lc * 100) / lo)
        Formula for calculating decompression:
        abs(100 - (lo * 100) / lc)

        FIELD 13 (Elapsed time)

        Elapsed time of the package's activities (start-end) expressed in 
        seconds employed to compress or decompress.














        CODEC                     OPTIONS                     TBL.  02.05
                                                              PAG.  04/05



        FIELD 15 (Kb/Sec)

        Execution  speed in compression or  decompression,  expressed  by 
        means  of  a relative value with a decimal,  based on the  file's 
        size in input and the elapsed time.
        Definites
        li = input file size            
        ti = elapsed time 
        Formula for calculation of kb/sec :
        (li / ti)

        FIELD 17 (Environment of origin)

        Indicates in which operating system the file was compressed.

        FIELD 19 (Compression model)

        Indicates  which one of the 100 available compression models  has 
        been used.

        FIELD 21 (File crc's data area)

        Hexadecimal  representation  of the Crc-32 that insures the  data 
        area of the compressed file.

        FIELD 23 (Date)

        Initial  date  of  compression or  decompression.   The  date  is 
        displayed in day/month/year format.

        FIELD 25 (Hour)

        Starting  time  of  compression or  decompression.  The  time  is 
        displayed in hour:minute:second format.

        FIELD 27 (Presence of password)

        Indicates the presence or absence of the password associated with 
        the file by means of a YES/NO message.




        The  outcome  file is always structured with a  208-byte  record.  
        The  field that make up the record can be full or empty depending 
        on the work saved.

        With commands "-C" (compression),  "-D" (decompression) and "-DB" 
        (binary decompression), all fields are full.







        CODEC                     OPTIONS                     TBL.  02.05
                                                              PAG.  05/05



        With command "-K" (deletion) only fields 1 (error code),  3 (path 
        name) and 5 (file name) have any significance.   Remaining fields 
        are blank.

        With  commands "-X" (crc check),  "-V" (display information)  and 
        "-VS"  (display  information/sort)  all  fields  are  significant  
        except 13 (elapsed time) and 15 (kb/sec), which are blank.

















































        CODEC                     OPTIONS                     TBL.  02.06
                                                              PAG.  01/01



        OPTION   -KF (deletes file after compression)


        PURPOSE  

        Permits  the  deletion of an original file to be  compressed  and 
        encrypted  or to be queued at the end of an execution only if  it 
        has been successful.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -KF (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)


        EXAMPLE

        CODEC     -C   DATI.LIB  /DATI/MOV.DAT  -KF


        COMMENTS

        Option  "-KF"  enables  the deletion of an original  file  to  be 
        compressed  and  encrypted  or  to be queued at the  end  of  the 
        execution only if it has been successful.




















        CODEC                     OPTIONS                     TBL.  02.07
                                                              PAG.  01/02



        OPTION  -M (running of subpath)


        PURPOSE

        Permits the running of the path name.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -M  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
        -    K deletion ............................... (cfr. TBL. 01.07)
        -    V display ................................ (cfr. TBL. 01.08)
        -    VS display/sort .......................... (cfr. TBL. 01.09)
        -    X crc check .............................. (cfr. TBL. 01.10)


        EXAMPLE

        CODEC     -C   DATI.LIB  /DATI/MOV.DAT  -M


        COMMENTS

        Option  "-M"  allows   the running of the path name  and  obtains 
        different effects when accompanied by specific commands.

        In  compression "-C(n)" has the task of memorizing,  in  library, 
        the  path  name and the file name of the file  to  be  compressed 
        thereby  allowing  the insertion of two files with the same  file 
        name but with different path names into the library.  In case the 
        compression is requested with wildcards, it instructs the package 
        to proceed with the compression,  recurring to all the successive 
        gerarchic levels and that in which it is positioned.









        CODEC                     OPTIONS                     TBL.  02.07
                                                              PAG.  02/02



        In  decompression  "-D"  and "-DB" have the  task  of  physically 
        repristining the path of each file in which an option to conserve 
        the path name has been inserted during the compression phase.

        In  deletion "-K",  in display "-V" and "-VS" and in the checking 
        phase of the crc, "-X" allows  the access to files into which the 
        conservation of the path name option has been inserted during the 
        compression phase. 
















































        CODEC                     OPTIONS                     TBL.  02.08
                                                              PAG.  01/01



        OPTION  -NN <file> (changes file name)


        PURPOSE

        Permits   the   changing  of  the  file  to  be   compressed   or 
        decompressed's name.


        TYPE 

        Optional.


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -NN <File>  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)


        EXAMPLE

        CODEC     -A   DATI.LIB  MOV.DAT   -NN  NUOVO.DAT
        CODEC     -C   DATI.LIB  MOV.DAT   -NN  NUOVO.DAT
        CODEC     -D   DATI.LIB  NUOVO.DAT -NN  MOV.DAT


        COMMENTS

        Option  "-NN" permits the compression of a file in library with a 
        name different from the original and the decompression of a  file 
        with a different name than that existing in the library.

















        CODEC                     OPTIONS                     TBL.  02.09
                                                              PAG.  01/01



        OPTION  -NP <path> (changes path name)


        PURPOSE

        Permits   the   changing  of  the  file  to  be   compressed   or 
        decompressed's path name.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -NP <Path>  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)


        EXAMPLE

        CODEC     -A        DATI.LIB  /DATI/MOV.DAT  -NP /ARCHIVIO/
        CODEC     -C        DATI.LIB  /DATI/MOV.DAT  -NP /ARCHIVIO/
        CODEC     -D        DATI.LIB  /ARCHIVIO/MOV.DAT  -NP /DATI/


        COMMENTS

        Option  "-NP"  allows  the compression of a library file  with  a 
        different   path   name  than  that  of  the  original  and   the 
        decompression  of a file with a different path name than that  in 
        existence in the library. 

        It  changes  the path name of the file recorded  in  the  library 
        heading   with   one  indicated  in  the  command   line   during 
        compression or decompression.

        In  order to annul a path name it is enough to add a space and  a 
        period after "-NP" ("-NP ."). Using the options "-NP" and "-M" it 
        is possible to change only the first level of the path name.








        CODEC                     OPTIONS                     TBL.  02.10
                                                              PAG.  01/01



        OPTION  -O (enables overwrite)


        PURPOSE

        Enables  the  overwriting of a compressed file in library  or  to 
        overwrite on an already existing file in decompression.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -O  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)


        EXAMPLE

        CODEC     -A        DATI.LIB  MOV.DAT  -O
        CODEC     -C        DATI.LIB  MOV.DAT  -O
        CODEC     -D        DATI.LIB  MOV.DAT  -O


        COMMENTS

        In  compression,  option "-O" allows  overwriting on a file  with 
        the   same   name  already  present  in  the   library   or,   in 
        decompression,  overwriting  on  an  existing file  in  the  host 
        environment.
















        CODEC                     OPTIONS                     TBL.  02.11
                                                              PAG.  01/02



        OPTION  -PF <pw> (file password)


        PURPOSE

        Runs  the  access  password for the  individual  compressed  file 
        inside the library.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -PF < pw>  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)


        EXAMPLE

        CODEC     -A        DATI.LIB  MOV.DAT  -PF SECRET
        CODEC     -C        DATI.LIB  MOV.DAT  -PF SECRET
        CODEC     -D        DATI.LIB  MOV.DAT  -PF SECRET


        COMMENTS

        Option  "-PF  <pw>"  runs the access password to  the  individual  
        compressed and encrypted file.  It is attributed only once during 
        the "-C(n)" compression phase or "-A"  file adding. 

        During the compression,  the password acts as a cryptographic key 
        for the T-DES algorithm used.   During adding phase, the password 
        has  the sole function of inhibiting access to the file and  does 
        not act as a cryptographic key.

        In  "-D"  and  "-DB" decompression and in  "-X"  crc  check,  the 
        password  enables  the  decyphering  of the  file  for  pertinent 
        executions.








        CODEC                     OPTIONS                     TBL.  02.11
                                                              PAG.  02/02



        The  T-DES  (Timing  - Data Encryption Standard) algorithm  is  a 
        feature of a DES model,  modified by Telvox,  which is capable of 
        sensitizing  the DES machine to the time in which it is activated  
        (an octet of bytes,  if encrypted with the same password but at a 
        different time, produce different outputs).

        The  password  can be as large as 255 characters and it may  hold 
        within it all the characters of the ASCII or EBCDIC tables.

        In  case  there  are blank characters,  the password  is  set  in 
        quotation marks " ".

        It  is possible to create a password either composed of  keyboard 
        characters  or  by means of hexadecimal  representations  of  the 
        same,  or  by mixing characters with hexadecimal representations. 
        Each hexadecimal character must be preceded by a slash  "/".  For 
        example /F1. In case the hexadecimal value were inferior to 0x0F, 
        it  should nonetheless be completed with a zero to the left of it 
        (/00, ..., /0F).

        The file password will not be inserted in the compressed file nor      
        in any other part of the compressed file library.

        For  a  quick  check on the consistency of the  password  and  to 
        reduce  computational  overhead  in case of typing error  of  the 
        same,  a 64 bit transcription of the password should be  executed 
        by  means  of  a one-way  function,  encrypted  onto  itself  and 
        recorded on the compressed file's heading.

        In  case a password is not entered in order to encrypt the  file, 
        CODEC  creates a random password that nonetheless  activates  the 
        T-DES algorithm.

        It  is  advisable  to  use a password  that  is  at  least  eight 
        characters long.





















        CODEC                     OPTIONS                     TBL.  02.12
                                                              PAG.  01/02



        OPTION  -PL <pw> (library password)


        PURPOSE

        Runs the library access password.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -PL <pw>  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
        -    K deletion ............................... (cfr. TBL. 01.07)


        EXAMPLE

        CODEC     -A        DATI.LIB  MOV.DAT  -PL SECRET
        CODEC     -C        DATI.LIB  MOV.DAT  -PL SECRET
        CODEC     -D        DATI.LIB  MOV.DAT  -PL SECRET
        CODEC     -K        DATI.LIB  MOV.DAT  -PL SECRET


        COMMENTS

        Option  "-PL <pw>" runs the access password to the library and is 
        attributed only once in  "-C(n)" compression phase or "-A" adding 
        phase of the first file inserted in the library.

        In   "-C(n)" compression or in "-A" adding for  files  succeeding 
        the  first  one,  in "-D" and  "-DB" decompression and  in   "-K" 
        deletion,  the   password enables access to files present in  the 
        library.             











        CODEC                     OPTIONS                     TBL.  02.12
                                                              PAG.  02/02



        The   library  password  is  encrypted  by  means  of  the  T-DES 
        algorithm.

        The  T-DES  (Timing  - Data Encryption Standard) algorithm  is  a 
        feature of a DES model,  modified by Telvox,  which is capable of 
        sensitizing  the DES machine to the time in which it is activated  
        (an octet of bytes,  if encrypted with the same password but at a 
        different time, produce different outputs).

        The  password  can be as large as 255 characters and it may  hold 
        within it all the characters of the ASCII or EBCDIC tables.

        In  case  there  are blank characters,  the password  is  set  in 
        quotation marks " ".

        It  is possible to create a password either composed of  keyboard 
        characters  or  by means of hexadecimal  representations  of  the 
        same,  or  by mixing characters with hexadecimal representations. 
        Each hexadecimal character must be preceded by a slash  "/".  For 
        example /F1. In case the hexadecimal value were inferior to 0x0F, 
        it  should nonetheless be completed with a zero to the left of it 
        (/00, ..., /0F).

        The library password will not be inserted in the compressed  file 
        library nor in any other part of the compressed file library.

        For  a  quick  check on the consistency of the  password  and  to 
        reduce  computational  overhead  in case of typing error  of  the 
        same,  a 64 bit transcription of the password should be  executed 
        by  means  of  a  one-way function,  encrypted  onto  itself  and 
        recorded on the compressed file's heading.

        It  is  advisable  to  use a password  that  is  at  least  eight 
        characters long.






















        CODEC                     OPTIONS                     TBL.  02.13
                                                              PAG.  01/02



        OPTION  -PLN <pw> (changes library password)


        PURPOSE

        Runs the variation of the library's access file.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command> <Library> <File> -PL <pw> -PLN <pw>  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    K deletion ............................... (cfr. TBL. 01.07)


        EXAMPLE

        CODEC     -A        DATI.LIB  MOV.DAT  -PL SECRET -PLN NEW
        CODEC     -C        DATI.LIB  MOV.DAT  -PL SECRET -PLN NEW
        CODEC     -K        DATI.LIB  MOV.DAT  -PL SECRET -PLN NEW


        COMMENTS

        Option  "-PLN  <pw>" runs the variation of the  library's  access 
        password.   Such  an  operation  is permitted  by  inserting  the 
        previous password and attributing the new one.   The modification 
        can  be run only in "-C(n)" compression phase,  "-A" adding files 
        and "-K" deletion.

















        CODEC                     OPTIONS                     TBL.  02.13
                                                              PAG.  02/02



        The   library  password  is  encrypted  by  means  of  the  T-DES 
        algorithm.

        The  T-DES  (Timing  - Data Encryption Standard) algorithm  is  a 
        feature of a DES model,  modified by Telvox,  which is capable of 
        sensitizing  the DES machine to the time in which it is activated  
        (an octet of bytes,  if encrypted with the same password but at a 
        different time, produce different outputs).

        The  password  can be as large as 255 characters and it may  hold 
        within it all the characters of the ASCII or EBCDIC tables.

        In  case  there  are blank characters,  the password  is  set  in 
        quotation marks " ".

        It  is possible to create a password either composed of  keyboard 
        characters  or  by means of hexadecimal  representations  of  the 
        same,  or  by mixing characters with hexadecimal representations. 
        Each hexadecimal character must be preceded by a slash  "/".  For 
        example /F1. In case the hexadecimal value were inferior to 0x0F, 
        it  should nonetheless be completed with a zero to the left of it 
        (/00, ..., /0F).

        The library password will not be inserted in the compressed  file 
        library nor in any other part of the compressed file library.

        For  a  quick  check on the consistency of the  password  and  to 
        reduce  computational  overhead  in case of typing error  of  the 
        same,  a 64 bit transcription of the password should be  executed 
        by  means  of  a  one-way function,  encrypted  onto  itself  and 
        recorded on the compressed file's heading.

        It  is  advisable  to  use a password  that  is  at  least  eight 
        characters long.






















        CODEC                     OPTIONS                     TBL.  02.14
                                                              PAG.  01/01



        OPTION  -Q (reduces result's format)


        PURPOSE

        Runs the data display in a reduced format.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -Q  (Options)


        ACTIVE COMMANDS

        -    V display ................................ (cfr. TBL. 01.08)
        -    VS display/sort .......................... (cfr. TBL. 01.09)


        EXAMPLE

        CODEC     -V        DATI.LIB  *.DAT  -Q
        CODEC     -VS       DATI.LIB  *.DAT  -Q


        COMMENTS

        Option "-Q" runs the data display in reduced format when commands 
        "-V" and "-VS" are used.






















        CODEC                     OPTIONS                     TBL.  02.15
                                                              PAG.  01/01



        OPTION  -S (silence mode)


        PURPOSE  

        Activates the silence mode.


        TYPE

        Optional. 


        SYNTAX  

        CODEC  <Command>  <Library>  <File>  -S (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)
        -    D decompression .......................... (cfr. TBL. 01.05)
        -    DB binary decompression .................. (cfr. TBL. 01.06)
        -    K deletion ............................... (cfr. TBL. 01.07)
        -    V display ................................ (cfr. TBL. 01.08)
        -    VS display/sort .......................... (cfr. TBL. 01.09)
        -    X crc check .............................. (cfr. TBL. 01.10)


        EXAMPLE

        CODEC     -C        DATI.LIB  MOV.DAT  -S


        COMMENTS

        Option  "-S"  runs  the  silence mode,  thus  avoiding  that  the 
        package's native messages are displayed on screen. 

















        CODEC                     OPTIONS                     TBL.  02.16
                                                              PAG.  01/01



        OPTION  -T <txt> (file's free text)


        PURPOSE

        Attributes free text to the file to be compressed.


        TYPE

        Optional. 


        SYNTAX   

        CODEC  <Command>  <Library>  <File>  -T "Testo"  (Options)


        ACTIVE COMMANDS

        -    A adding witout compression .............. (cfr. TBL. 01.02)
        -    C(n) compression ......................... (cfr. TBL. 01.03)


        EXAMPLE

        CODEC     -A        DATI.LIB  MOV.DAT  -T "FREE TEXT"
        CODEC     -C        DATI.LIB  MOV.DAT  -T "FREE TEXT"


        COMMENTS

        Option  "-T" allows  the attribution of free text, 255 characters 
        in size,  for the file to be compressed.   The free text must  be 
        written in quotation marks " ".





















        *****************************************************************
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                       APPENDIX   < A >                        *
        *                                                               *
        *                         CODEC ERRORS                          *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *                                                               *
        *****************************************************************







        CODEC               ERRORS AND MESSAGES               TBL.   A.01
                                                              PAG.  01/03



        LIST OF CODEC ERROR CODES AND MESSAGES 


        CODE      DESCRIPTION                             
        -----------------------------------------------------------------

        (0)       OK                                      

        (1)       FILE ALREADY PRESENT IN LIBRARY         

        (2)       FILE NOT COMPRESSABLE                   

        (3)       INCORRECT FILE PASSWORD                 

        (4)       INCORRECT FILE CRC                      

        (5)       DATA LOST FOR RECORD TRUNCATION                   

        (6)       FILE TO BE DECOMPRESSED ALREADY IN EXISTENCE 

        (7)       FUTURE EXPANSION                             

        (8)       FILE DELETED FROM LIBRARY                                 

        (9)       IMPOSSIBLE TO DUPLICATE FILE DESCRIPTION                     

        (10)      INCORRECT SYNTAX                        

        (11)      INCORRECT CODEC VERSION                       

        (12)      DECOMPRESSION FROM A NON QUALIFIED ENVIRONMENT          

        (13)      INCORRECT CODE                          

        (14)      IMPOSSIBLE TO OPEN 'ESITO' FILE                            

        (15)      IMPOSSIBLE TO WRITE IN 'ESITO' FILE                 

        (16)      IMPOSSIBLE TO CLOSE 'ESITO' FILE                            

        (17)      INSUFFICIENT MEMORY                     

        (18)      INSUFFICIENT MEMORY                    

        (19)      INSUFFICIENT MEMORY                     

        (20)      IMPOSSIBLE TO RECREATE PATH NAME                               









        CODEC               ERRORS AND MESSAGES               TBL.   A.01
                                                              PAG.  02/03



        CODE      DESCRIPTION                                      
        -----------------------------------------------------------------

        (21)      FUTURE EXPANSION                        

        (22)      FUTURE EXPANSION                        

        (23)      FUTURE EXPANSION                        

        (24)      FUTURE EXPANSION                        

        (25)      IMPOSSIBLE TO OPEN LIBRARY IN READ MODE                            

        (26)      IMPOSSIBLE TO READ CHARACTER FROM LIBRARY
                                  
        (27)      IMPOSSIBLE TO OPEN LIBRARY IN WRITE MODE                           

        (28)      IMPOSSIBLE TO WRITE CHARACTER IN LIBRARY 

        (29)      LIBRARY CLOSED INCORRECTLY                                     

        (30)      LIBRARY CONTAINING 5000 COMPRESSED FILES

        (31)      NOT CODEC LIBRARY  

        (32)      FILE NOT PRESENT IN LIBRARY                                 

        (33)      INCORRECT LIBRARY HEADING CRC                                

        (34)      INCORRECT LIBRARY PASSWORD                                    

        (35)      IMPOSSIBLE TO DELETE ORIGINAL LIBRARY                         

        (36)      IMPOSSIBLE TO SUBSTITUTE ORIGINAL LIBRARY                    

        (37)      SAME LIBRARY AND FILE NAME           

        (38)      SAME LIBRARY AND FILE NAME           

        (39)      INCORRECT LIBRARY POSITIONING

        (40)      FUTURE EXPANSION                        

        (41)      FUTURE EXPANSION                        

        (42)      FUTURE EXPANSION                        

        (43)      FUTURE EXPANSION                        








        CODEC               ERRORS AND MESSAGES               TBL.   A.01
                                                              PAG.  03/03



        CODE      DESCRIPTION                                      
        -----------------------------------------------------------------

        (44)      FUTURE EXPANSION                    

        (45)      IMPOSSIBLE TO OPEN FILE TO BE COMPRESSED

        (46)      IMPOSSIBLE TO READ CHARACTER FROM FILE

        (47)      IMPOSSIBLE TO OPEN FILE TO BE DECOMPRESSED

        (48)      IMPOSSIBLE TO WRITE CHARACTER IN FILE 

        (49)      FILE CLOSED INCORRECTLY                  

        (50)      INCORRECT COMPRESSED FILE HEADING CRC   

        (51)      IMPOSSIBLE TO DELETE ORIGINAL FILE      

        (52)      FUTURE EXPANSION                        

        (53)      FUTURE EXPANSION                        

        (54)      FUTURE EXPANSION                        

        (55)      FUTURE EXPANSION                        

        (56)      FUTURE EXPANSION                        

        (57)      FUTURE EXPANSION                        

        (58)      FUTURE EXPANSION                       

        (59)      FUTURE EXPANSION                        






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  01/30



        CODE     ( 0 )

        DESCRIPTION              :    Ok

        COMMENTS                 :    The   executed  CODEC  command  was  
                                      successful.

        ACTION                   :    None.



















        CODE     ( 1 )

        DESCRIPTION              :    File already present in library

        COMMENTS                 :    File   to  be  compressed   already 
                                      exists in library.

        ACTION                   :    If  there is a need to compress   a        
                                      file with an already existent  name 
                                      in the library,  it is necessary to 
                                      use   option  "-O"  (enables  over-
                                      write).

















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  02/30



        CODE     ( 2 )

        DESCRIPTION              :    File not compressable

        COMMENTS                 :    Type of file not compressable.   

        ACTION                   :    Insure that the chosen file has the  
                                      necessary  characteristics for  the 
                                      compression  or  that its  size  is       
                                      superior  to  0  byte.    For  more 
                                      information  consult the chapter on 
                                      "FILE  TYPES  "  of  the   specific 
                                      environment manual.














        CODE     ( 3 )

        DESCRIPTION              :    Incorrect file password  

        COMMENTS                 :    The password entered to access  the    
                                      file  does  not correspond to  that 
                                      used during the compression phase.

        ACTION                   :    Enter  the  correct  password  with 
                                      option "-PF <pw>" (file  password). 
                                      


















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  03/30



        CODE     ( 4 )

        DESCRIPTION              :    Incorrect file crc     

        COMMENTS                 :    After  decompression file does  not 
                                      appear  identical to  the  original 
                                      because one or more bytes have been 
                                      modified   within  the   compressed 
                                      file.

        ACTION                   :    Recompress  the original  file.  In 
                                      case  it  was compressed  with  the 
                                      same  computer  with which  it  was 
                                      decompressed,  insure that the disk 
                                      is  functioning  correctly.   If  a 
                                      different computer is used,  insure 
                                      the      communications      system 
                                      guarantees  the  integrity  of  the 
                                      data  in  transfer phase  from  one 
                                      computer to another.        







        CODE     ( 5 )

        DESCRIPTION              :    Data lost for record truncation

        COMMENTS                 :    Attempt   at  decompression  on  an 
                                      already allocated file with  record 
                                      size smaller than the original. The 
                                      characters in execess are lost. The  
                                      indicated   error  does  not   stop 
                                      CODEC's  activity and it appears as 
                                      a warning to the user.        

        ACTION                   :    Insure   that   the  file   to   be 
                                      decompressed is correctly allocated 
                                      or that it doesn't exist.  














        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  04/30



        CODE   ( 6 )

        DESCRIPTION              :    File to be decompressed already  in 
                                      existence

        COMMENTS                 :    The file to be decompressed already 
                                      exists in the host environment.

        ACTION                   :    If it is necessary to decompresse a 
                                      file  with a name  already  present 
                                      among  available files in the  host 
                                      environment, it is advisable to use 
                                      option "-O" (enables overwrite).














        CODE     ( 7 )

        DESCRIPTION              :    Future expansion  

        COMMENTS                 :    None.   

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  05/30



        CODE     ( 8 )

        DESCRIPTION              :    File deleted from library     

        COMMENTS                 :    Confirmation  of a successful dele-
                                      tion  of a file compressed  from  a 
                                      library.
                  
        ACTION                   :    None.   


















        CODE     ( 9 )

        DESCRIPTION              :    Impossible   to   duplicate    file          
                                      description

        COMMENTS                 :    Unsuccessful  attempt take away  or 
                                      attribute  the file's  characteris-
                                      tics  during compression or  decom-
                                      pression.  The  error message  does 
                                      not  block   CODEC's activities and 
                                      appears  as a warning to the  user.          

        ACTION                   :    Check the file's status.     
















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  06/30


             
        CODE     ( 10 )

        DESCRIPTION              :    Incorrect syntax     

        COMMENTS                 :    The command string contains one  or 
                                      more   unavailable  options  or  is        
                                      missing   one  or  more  obligatory 
                                      definites for correct elaboration.     

        ACTION                   :    Consult section "GENERAL FUNCTIONS" 
                                      in the CODEC user's manual.

                                      













                                    
        CODE     ( 11 )

        DESCRIPTION              :    Incorrect CODEC version     

        COMMENTS                 :    The  file  to be  decompressed  was       
                                      compressed  with a different  CODEC         
                                      version,  even though the  original 
                                      and   host  environments  were  ac-
                                      tioned.  For example, when the file 
                                      was compressed with version 2.xx in 
                                      an  actioned environment but  there 
                                      is  an   attempt  at  decompression 
                                      with version 3.xx.

        ACTION                   :    Decompresses  the  file  with   the             
                                      corresponding  version  to the  one 
                                      used for compression.












        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  07/30



        CODE   ( 12 )
                                      
        DESCRIPTION              :    Decompression  from a non qualified    
                                      environment

        COMMENTS                 :    There was an attempt at  decompres-
                                      sion in the host environment with a          
                                      CODEC   version   unable   to   run      
                                      compressed files coming from diffe-
                                      rent environments.

        ACTION                   :    Install  the CODEC version  capable 
                                      of  running both files generated in 
                                      the   host  environment  and  those 
                                      coming from other environments.        












        CODE   ( 13 )

        DESCRIPTION              :    Incorrect code       

        COMMENTS                 :    The  compression  or  decompression 
                                      algorithm  is unable  to  elaborate 
                                      one  or more of the file's  charac-
                                      ters  within  a specific  operating 
                                      system.  

        ACTION                   :    Check  the correct CODEC  installa-
                                      tion   and  retry  compression   or 
                                      decompression.  In  case  the  same 
                                      error  message   appears,   contact 
                                      "Telvox Teleinformatica".














        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  08/30



        CODE     ( 14 )

        DESCRIPTION              :    Impossible to open "ESITO" file

        COMMENTS                 :    The  command string contains option 
                                      "-E  <file>" or "ED" and the  disk, 
                                      in  which  the ESITO file  must  be 
                                      written,    is    full    or    the            
                                      operating  system does not allow to 
                                      be opened in write mode.

        ACTION                   :    Check if the disk is full or if the   
                                      ESITO    file   has   been   opened 
                                      correctly.













        CODE     ( 15 )

        DESCRIPTION              :    Impossible to write in "ESITO" file
          
        COMMENTS                 :    The command string contains  option 
                                      "-E  <file>" or "ED" and the  disk, 
                                      in  which  the ESITO file  must  be 
                                      written,  is full or the  operating 
                                      system,    after    allowing    the       
                                      access    of the ESITO  file,  does 
                                      not allow writing in it.     

        ACTION                   :    Check  if  the disk is full  or  if       
                                      the  ESITO  file  has  been  opened 
                                      correctly.














        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  09/30



        CODE   ( 16 )

        DESCRIPTION              :    Impossible to close "ESITO" file

        COMMENTS                 :    The  command string contains option 
                                      "-E  <file>" or "ED" and the  disk, 
                                      in  which  the ESITO file  must  be 
                                      written,  is  full or the operating 
                                      system,    after    allowing    the       
                                      access    of the ESITO  file,  does 
                                      not allow writing in it.     

        ACTION                   :    Check  if  the disk is full  or  if       
                                      the  ESITO  file  has  been  opened     
                                      correctly.












        CODE     ( 17 )

        DESCRIPTION              :    Insufficient memory   

        COMMENTS                 :    Insufficient  RAM to  allocate  the     
                                      variable dictionary.     
          
        ACTION                   :    Retry running of CODEC while making   
                                      sure   there   is  enough  RAM   in           
                                      relation  to the compression  model     
                                      used.


















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  10/30



        CODE     ( 18 )

        DESCRIPTION              :    Insufficient memory    

        COMMENTS                 :    Insufficient RAM to reallocate  the    
                                      necessary   memory  areas  for  the        
                                      correct functioning of the product.

        ACTION                   :    Retry running of CODEC while making   
                                      sure   there  is  enough   RAM   in           
                                      relation  to the compression  model 
                                      used.















        CODE     ( 19 )

        DESCRIPTION              :    Insufficient memory    

        COMMENTS                 :    Insufficient  RAM  to allocate  the 
                                      input/output buffers.

        ACTION                   :    Retry running of CODEC while making   
                                      sure   there  is  enough   RAM   in           
                                      relation  to the compression  model 
                                      used.


















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  11/30



        CODE     ( 20 )

        DESCRIPTION              :    Impossible to recreate path name

        COMMENTS                 :    In decompression phase, by means of   
                                      option "-M" (running of subpath) or 
                                      "-NP <path>" (change path name), it 
                                      is   not   possible  to   correctly       
                                      allocate the path name (subdirecto-
                                      ry,  library or multi-member  file)         
                                      correlated with the file's physical   
                                      name.

        ACTION                   :    Check if the disk is full or if the   
                                      file has been addressed correctly.












        CODE     ( 21 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  12/30



        CODE     ( 22 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   




















        CODE     ( 23 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  13/30



        CODE     ( 24 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.




















        CODE     ( 25 )

        DESCRIPTION              :    Impossible  to open library in read   
                                      mode   

        COMMENTS                 :    The  library containing  compressed     
                                      files   does  not  exist   or   the
                                      operating  system  does  not  allow  
                                      to be opened in read mode.

        ACTION                   :    Check the existence  of the library  
                                      or the possibility of access to it.   

















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  14/30



        CODE      ( 26 )

        DESCRIPTION              :    Impossible  to read character  from    
                                      library 

        COMMENTS                 :    The  library containing  compressed     
                                      files has been opened correctly but   
                                      the   operating  system  does   not    
                                      allow its reading.

        ACTION                   :    Check  for the correct function  of 
                                      the disk.   









         





        CODE     ( 27 )

        DESCRIPTION              :    Impossible   to  open  library  in      
                                      write mode

        COMMENTS                 :    The  library containing  compressed     
                                      files   does  not  exist   or   the           
                                      operating    system    does     not        
                                      allow to be opened in write mode.

        ACTION                   :    Verify the existence of the library  
                                      or the possibility of access during   
                                      write mode.            
















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  15/30



        CODE     ( 28 )

        DESCRIPTION              :    Impossible  to  write character  in    
                                      library

        COMMENTS                 :    The  library containing  compressed     
                                      files has been opened correctly but   
                                      the   operating  system  does   not    
                                      allow writing. 

        ACTION                   :    Check  if the disk is full or if it 
                                      is functioning correctly.















        CODE     ( 29 )

        DESCRIPTION              :    Library closed incorrectly    

        COMMENTS                 :    After  having  opened  in  read  or 
                                      write   mode  and  having  read  or 
                                      written    correctly   within   the 
                                      library  of compressed  files,  the 
                                      operating  system does not allow to 
                                      be closed.

        ACTION                   :    Check  if the disk is full or if it    
                                      is functioning correctly.
















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  16/30



        CODE     ( 30 )

        DESCRIPTION              :    Library containing 5000  compressed   
                                      files

        COMMENTS                 :    The   library  contains  a  maximum       
                                      number of (5000) compressed files.

        ACTION                   :    Compress  selected  files in a  new 
                                      library.       

















        CODE     ( 31 )

        DESCRIPTION              :    Non CODEC library 

        COMMENTS                 :    In the library's opening  phase and   
                                      for   read/write  activities   some 
                                      fundamental characteristics of  the 
                                      library   heading  have  not   been 
                                      recognized.

        ACTION                   :    Make  sure that it is a case  of  a 
                                      library  of compressed files  gene-
                                      rated by CODEC and successively run        
                                      CODECR  for  the reconstruction  of 
                                      the damaged library. 














        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  17/30



        CODE     ( 32 )

        DESCRIPTION              :    File not present in library 

        COMMENTS                 :    Attempt at accessing a non-existent   
                                      file from the library. 

        ACTION                   :    None.   



















        CODE     ( 33 )

        DESCRIPTION              :    Incorrect library heading crc    

        COMMENTS                 :    The  calculation  of  the   library        
                                      heading's crc does not correspond.
                  
        ACTION                   :    Run  CODECR for the  reconstruction 
                                      of the damaged library. 




















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  18/30



        CODE   ( 34 )

        DESCRIPTION              :    Incorrect library password    

        COMMENTS                 :    Attempt  to access library by means 
                                      of   a  password  other  than   the 
                                      original  

        ACTION                   :    Insert the correct password through 
                                      option  "-PL <pw>"  (library  pass-  
                                      word).
















        CODE   ( 35 )

        DESCRIPTION              :    Impossible   to   delete   original        
                                      library  

        COMMENTS                 :    In deletion or compression phase of 
                                      a library file in overwrite (option 
                                      "-O") it is impossible to   regene-
                                      rate a new library without files to 
                                      be  deleted  or  substituted.   The 
                                      original  library is left  unvaried 
                                      as  to  type and structure and  the 
                                      support  file  "COPIALIB"  contains 
                                      all  resulting files from  previous 
                                      operations.                

        ACTION                   :    Delete original library and  effect    
                                      a rename manual of the support file 
                                      "COPIALIB"  on the original library 
                                      name.      









        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  19/30



        CODE   ( 36 )

        DESCRIPTION              :    Impossible  to substitute  original    
                                      library  

        COMMENTS                 :    In deletion or compression phase of 
                                      a library file in overwrite (option 
                                      "-O") it is impossible to   regene-
                                      rate  a new library with the aid of 
                                      the support file "COPIALIB",  which 
                                      contains    all   resulting   files    
                                      from   previous   operations.   The 
                                      original library has been deleted.

        ACTION                   :    Effect  a  rename  manual  of   the    
                                      support  file  "COPIALIB"  on   the 
                                      original library's name.










        CODE   ( 37 )

        DESCRIPTION              :    Same library and file name    

        COMMENTS                 :    In  constructing the command string    
                                      to compress the library name, it is   
                                      the same as that of the file.

        ACTION                   :    Recompile the command string.     




















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  20/30


                                      
        CODE   ( 38 )

        DESCRIPTION              :    Same library and file name           

        COMMENTS                 :    While   constructing  the   command 
                                      string  for decompression,  the li-
                                      brary name   is the same as that of 
                                      the file.     

        ACTION                   :    Ricompile the command string.      

















        CODE   ( 39 )

        DESCRIPTION              :    Incorrect library positioning      

        COMMENTS                 :    The library is damaged.    

        ACTION                   :    Run  CODECR for the  reconstruction 
                                      of the damaged library. 





















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  21/30



        CODE   ( 40 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   




















        CODE   ( 41 )

        DESCRIPTION              :    Future expansion  

        COMMENTS                 :    None.   

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  22/30



        CODE   ( 42 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   




















        CODE   ( 43 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  23/30



        CODE   ( 44 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   




















        CODE   ( 45 )

        DESCRIPTION              :    Impossible  to  open  file  to   be        
                                      compressed

        COMMENTS                 :    The  file to be compressed does not 
                                      exist  or the operating system does 
                                      not allow to be opened.

        ACTION                   :    Insure the existence of the file to 
                                      be  compressed and the  possibility 
                                      of accessing it in read mode.

















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  24/30



        CODE   ( 46 )

        DESCRIPTION              :    Impossible  to read character  from 
                                      file

        COMMENTS                 :    The  file to be compressed has been 
                                      opened  correctly but the operating 
                                      system does not allow its reading.

        ACTION                   :    Check  for the correct  functioning 
                                      of the disk.
















        CODE   ( 47 )

        DESCRIPTION              :    Impossible   to  open  file  to  be         
                                      decompressed

        COMMENTS                 :    The  disk on which the file  to  be 
                                      compressed must be written is  full 
                                      or  the operating system  does  not 
                                      allow  the file's opening  in write 
                                      mode.

        ACTION                   :    Check if the disk is full or if the 
                                      file  has been addressed  correctly 
                                      on disk.     















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  25/30



        CODE   ( 48 )

        DESCRIPTION              :    Impossible  to write character   in 
                                      file 

        COMMENTS                 :    The file to be compressed has  been 
                                      opened  correctly but the operating 
                                      system does not allow writing.

        ACTION                   :    Check if the disk is full or if  it 
                                      is functioning correctly.     
















        CODE   ( 49 )

        DESCRIPTION              :    File closed incorrectly    

        COMMENTS                 :    The file to be compressed or decom-
                                      pressed  was  not closed  correctly 
                                      during  the compression  or  decom-
                                      pression phase.     

        ACTION                   :    Check the file's status.



















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  26/30



        CODE   ( 50 )

        DESCRIPTION              :    Incorrect  compressed file  heading 
                                      crc 

        COMMENTS                 :    The  calculation of the  compressed 
                                      file  heading crc does not  corres-
                                      pond.

        ACTION                   :    Run  CODECR for the  reconstruction 
                                      of the damaged library and compress 
                                      the  original file once  more.   In 
                                      case  the file was compressed  with 
                                      the same computer in which it is to 
                                      be  decompressed,   check  for  the 
                                      correct functioning of the disk. If 
                                      the   file   comes   from   another 
                                      computer,   make   sure  that   the 
                                      communications   system  guarantees 
                                      the   integrity  of  the  data   in 
                                      transit   from  one   computer   to 
                                      another.





        CODE   ( 51 )

        DESCRIPTION              :    Impossible to delete original file

        COMMENTS                 :    In file deletion phase, when  "-KF" 
                                      option  is  used,   the   operating 
                                      system  does not allow deleting the 
                                      original file.

        ACTION                   :    Check  the file attributes allowing 
                                      the file deletion.


















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  27/30



        CODE   ( 52 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   




















        CODE   ( 53 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTIONENTO               :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  28/30



        CODE   ( 54 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   




















        CODE   ( 55 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.   

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  29/30



        CODE   ( 56 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.

        ACTION                   :    None.   




















        CODE   ( 57 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.

        ACTION                   :    None.   






















        CODEC               ERRORS AND MESSAGES               TBL.   A.02
                                                              PAG.  30/30



        CODE   ( 58 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.

        ACTION                   :    None.   




















        CODE     ( 59 )

        DESCRIPTION              :    Future expansion 

        COMMENTS                 :    None.

        ACTION                   :    None.   



















