/*
 * buildvrx.cmd -- Build the VX REXX folder and the associated
 *                 icons.
 */

address CMD

'@echo off'

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

call setlocal

/*
 * The target directory is the parm we were passed... make sure
 * the directory exists...
 */

target_dir   = ''
folder_title = ''

parse arg target_dir folder_title

if( target_dir = '?' | target_dir = '/?' )then
    call Usage

if( folder_title = '' )then
    folder_title = 'WATCOM VX-REXX'

if( target_dir = '' )then
    target_dir = directory()

if( directory( target_dir ) = '' )then
    call Usage

target_dir = directory( target_dir )

/*
 * Clean things up first...
 */

call CleanIni
call AssignTypes

/*
 * Create the main folder object
 */

say 'Building Workplace Shell VX-REXX Objects...'

classname = 'WPFolder'
title     = folder_title
location  = '<WP_DESKTOP>'
iconparm  = 'ICONFILE=' || target_dir || '\watcom2.ico;'
setup     = 'OBJECTID=<VXREXX_FOLDER>;' || iconparm

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a Color Palette
 */

classname = 'WPColorPalette'
title     = 'Color Palette'
location  = '<VXREXX_FOLDER>'

call SysCreateObject classname, title, location

/*
 * Create a Font Palette
 */

classname = 'WPFontPalette'
title     = 'Font Palette'
location  = '<VXREXX_FOLDER>'

call SysCreateObject classname, title, location

/*
 * Create the projects folder
 */

classname = 'WPShadow'
title     = 'Projects'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\PROJECTS;OBJECTID=<VXREXX_PROJECTS>;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the Samples folder
 */

classname = 'WPShadow'
title     = 'Samples'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\SAMPLES;OBJECTID=<VXREXX_SAMPLES>;'

call SysCreateObject classname, title, location, setup, 'r'


/*
 * Create the Macros folder
 */

classname = 'WPShadow'
title     = 'Macros'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\MACROS;OBJECTID=<VXREXX_MACROS>;'
call SysCreateObject classname, title, location, setup, 'r'


/*
 * Create the book program objects
 */

classname = 'WPProgram'
title     = "Programmer's Guide"
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || '\ProgGuid.INF;' ||,
            'STARTUPDIR=' || target_dir || ';'

call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPProgram'
title     = 'Reference'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || '\A2Z.INF;' ||,
            'STARTUPDIR=' || target_dir || ';'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the Readme program object
 */

classname = 'WPProgram'
title     = 'Read Me First'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || '\readme.inf;' ||,
            'STARTUPDIR=' || target_dir || ';'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a shadow of the REXX information
 */

classname = 'WPProgram'
title     = 'REXX Information'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=rexx.inf;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the VX REXX program object
 */

classname = 'WPProgram'
title     = 'VX-REXX'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=' || target_dir || '\vrxedit.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ASSOCFILTER=*.VRP;' ||,
            'ASSOCTYPE=VX-REXX Project;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the VX REXX macro-launcher object
 */
/*
    Don't include this for now.
    Its presence in the VX-REXX folder is confusing.  People click on it and
    expect something to happen.  Nothing does.

    We don't really expect people to drag and drop macros, or to rename them *.VRM and
    double click on them.  Macro's are really only run from applications.
*/
/*
classname = 'WPProgram'
title     = 'VX-REXX Macro'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=' || target_dir || '\vrx.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ASSOCFILTER=*.VRM;' ||,
            'ASSOCTYPE=VX-REXX Macro;'

call SysCreateObject classname, title, location, setup, 'r'
*/

/*
 * Add the project template
 */

call AddTemplate

/*
 * Set the executable icon.
 */
call AddSample "button",    "Button"
call AddSample "calc",      "Calculator"
call AddSample "mindgame",  "Mind Game"
call AddSample "threads",   "Threads"
call AddSample "sampledb",  "Sample Database"
call AddSample "movies",    "Multimedia"
call AddSample "hinthelp",  "Hint and Help"
call AddSample "mmw",       "MMW"
call AddSample "WinCtrl",   "Window Controller"

/*  Add an icon to run the EPM demos
*/
call AddScan

exit

/****************************** End of Program ****************************/

/*
 * AddTemplate
 */

AddTemplate:

    classname = 'WPFolder'
    title     = 'VX-REXX Project'
    location  = target_dir || '\Projects'
    setup     = 'OBJECTID=<VXREXX_TEMPLATE>;' ||,
                'TEMPLATE=yes;'

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Project.VRP'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Window1.VRY'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Window1.VRX'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    return

/*
 * AddSample
 */

AddSample:
    startup     = target_dir || '\Samples\' || arg( 1 )
    folder_name = startup
    exe_parms = ''
    exe_name  = arg( 1 ) || '.EXE'
    ico_name  = arg( 1 ) || '.ICO'

    classname = 'WPProgram'
    title     = arg( 2 )
    location  = folder_name
    setup     = 'EXENAME=' || startup || '\Bin\' || exe_name || ';' ||,
                'PROGTYPE=PM;' ||,
                'ICONFILE=' || startup || '\Bin\' || ico_name || ';' ||,
                'STARTUPDIR=' || startup || ';' ||,
                'PARAMETERS=' || exe_parms || ';'

    call SysCreateObject classname, title, location, setup, 'r'

    return

/*
 * AddScan
 */

AddScan:
    startup     = target_dir || '\Samples\Scan'
    folder_name = startup
    ico_name    = 'Scan.ICO'

    classname = 'WPProgram'
    title     = 'EPM with Scan'
    location  = folder_name
    setup     = 'EXENAME=epm.exe;' ||,
                'PROGTYPE=PM;' ||,
                'ICONFILE=' || startup || '\Bin\' || ico_name || ';' ||,
                'STARTUPDIR=' || startup || ';' ||,
                "PARAMETERS=bin\scan.erx 'rx bin\scan';"

    call SysCreateObject classname, title, location, setup, 'r'

    return
    

/*
 * AssignTypes -- Assigns the 'VX-REXX Project' type to all the .VRP files
 *                that have been installed.
 */

AssignTypes:


    type      = 'VX-REXX Project'
    typevalue = 'DFFF00000100FFDF'x || d2c(length(type)) || '00'x || type

    call SysIni 'USER', 'PMWP_ASSOC_TYPE', type
    call SysIni 'USER', 'PMWP_ASSOC_FILTER', '*.VRP'

    call SysFileTree target_dir || '\*.VRP', 'files.', 'fso'

    do i = 1 to files.0
        call SysPutEa files.i, '.TYPE', typevalue
    end

    return

/*
 * CleanIni -- Clean up the .INI file out of old VX-REXX information.
 *             Cleans up old beta stuff, too.
 */

CleanIni:
    call SysIni 'user', 'PMWP_ASSOC_FILTER', '*.VRP', 'DELETE:'
    call SysIni 'user', 'PMWP_ASSOC_TYPE', 'VX-REXX Project', 'DELETE:'
    call SysIni 'user', 'PMWP_ASSOC_TYPE', 'VRx Project', 'DELETE:'

    call sysini 'user', 'PM_Workplace:Templates', 'All:', 'ids.'
    do i = 1 to ids.0
        if( pos( 'REXX', ids.i ) \= 0 & pos( 'VX', ids.i ) \= 0 & ,
            pos( 'Project', ids.i ) \= 0 )then do
            call SysIni 'user', 'PM_Workplace:Templates', ids.i, 'DELETE:'
        end
    
        if( pos( 'VRx', ids.i ) \= 0 & pos( 'Project', ids.i ) \= 0 )then do
            call SysIni 'user', 'PM_Workplace:Templates', ids.i, 'DELETE:'
        end
    end

    call SysDestroyObject '<VXREXX_SAMPLES>'
    call SysDestroyObject '<VXREXX_TEMPLATE>'
    call SysDestroyObject '<VXREXX_PROJECTS>'
    call SysDestroyObject '<VXREXX_MACROS>'
    call SysDestroyObject '<VXREXX_FOLDER>'

    return
    
/*
 * FileExists
 */
    
FileExists:
    return( stream( arg(1), 'c', 'query exists' ) <> '' )

/*
 * Usage
 */

Usage:
    say ''
    say 'Usage: buildvrx [target_dir] [title]'
    say ''
    say '    target_dir   = path where WATCOM VX-REXX has been installed'
    say '    title        = folder title (defaults to "WATCOM VX-REXX")'
    say ''
    say 'This program builds/rebuilds the various Workplace Shell objects'
    say 'needed to run WATCOM VX-REXX.'
    exit
