/* Copyright 1993 HockWare Inc. */
Call RxFuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
say '****************************************************************'
say '* VisPro/REXX (tm) by HockWare (tm) Inc.                       *'
say '*                                                              *'
say '* This command file is used to help apply the VisPro/REXX      *'
say '* update 1.1 on your system.  This update contains a number    *'
say '* of enhancements, which are described in the file UPDATE.ME   *'
say '*                                                              *'
say '* Prior to continuing with this command file, you must have    *'
say '* installed VisPro/REXX in your system using your installation *'
say '* diskette.                                                    *'
say '*                                                              *'
say '* Note: before continuing, make certain that all VisPro/REXX   *'
say '* windows are closed.  Otherwise, the fixes may not be applied.*'
say '****************************************************************'
say ''
say '  Are you sure you want to update VisPro/REXX(Y/N)?'
PARSE UPPER VALUE LINEIN() with RESPONSE
IF RESPONSE<>'Y' THEN EXIT
say ''

/* Get value of OS/2 boot path */
OSPATH=SysSearchPath('PATH','CMD.EXE')
OSDIR=OVERLAY('        ',OSPATH,LENGTH(OSPATH)-LENGTH('CMD.EXE'))
OSDIR=STRIP(OSDIR)

/* Get value of VisPro/REXX installation directory */
CONFIG=LEFT(OSDIR,2)||'\CONFIG.SYS'
call SysFileSearch 'SET VISPRORX=', CONFIG, 'hits.'

i=hits.0

if i=0 THEN
   PRODUCTDIR='C:\VISPRORX'
ELSE DO
   PRODUCTDIR=STRIP(DELSTR(hits.i,1,13))
   END

say ''
say '  Applying update to VisPro/REXX...'
say ''

'unpack visprorx.ex@ ' PRODUCTDIR
call ERRORCHECK 'visprorx.exe'
'unpack runit.ex@ ' PRODUCTDIR
call ERRORCHECK 'runit.exe'
'unpack template.ex@ ' PRODUCTDIR
call ERRORCHECK 'template.exe'
'copy update.me ' PRODUCTDIR||'\PROJECTS\UPDATE.ME'
call ERRORCHECK 'update.me'
'unpack visprorx.hl@ ' OSDIR||'\HELP'
if (rc > 1) then do
   say ''
   say '  Error copying file visprorx.hlp to the 'OSDIR'\HELP directory.'
   say '  There may be insuficient disk space.'
   EXIT
end

say ''
say '  VisPro/REXX update was successfully applied. '
say ''
say '  For information on changes provided by this update, '
say '  refer to the UPDATE.ME file.'
EXIT

ERRORCHECK:
Arg FileName
if (rc > 1) then do
   say ''
   say '  Error copying file 'FileName' to the 'PRODUCTDIR' directory.'
   say '  Make certain that all VisPro/REXX windows are closed.'
   say '  Then retry this command.'
   EXIT
end
RETURN
