/* Copyright (C) 1992,1993 Peter Edward Cann */

#include<stdio.h>
#include<dos.h>
#include<stdlib.h>
#include<process.h>
#include<graph.h>
#include<time.h>
#include<bios.h>
#include<signal.h>
#include"port.h"

unsigned long tick;

void (interrupt far *oldtick)();

void interrupt far tickhndl()
	{
	tick++;
	}

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i];i++)
		{
		while(!(inp(basereg+STATREG)&TXMTMASK));
		outp(basereg, str[i]);
		}
	}

char okstr[]="OK\r\n";

int follow;

scanok()
	{
	long ts;
	int i;
	char c;
	i=0;
	time(&ts);
	while(1)
		{
		while(follow==index)
			if((time(NULL)-ts)>5)
				{
				printf("ScanOK timeout.\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(57);
				}
		putch(c=buf[follow++]);
		if(follow>=TBUFSIZ)
			follow=0;
		if(c==okstr[i])
			if(okstr[++i]=='\0')
				break;
			else;
		else
			if(c==okstr[0])
				i=1;
			else
				i=0;
		}
	}

void pause(int ticks)
	{
	long ts, ts1;
	tick=0;
	while(1)
		{
		if(tick>ticks)
			break;
		}
	}

#define MAXTIMES 1024

long times[MAXTIMES];

int ntimes;

quit()
	{
	cleanup(0);
	_dos_setvect(0x1c, oldtick);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, curind, flag, toflag, fbi, delenp, gbdr, mbdr;
	char grtpname[256], msgpname[256], msgss[256], *quicke, gq, mq;
	char c, numstr[16], *cp, farback[16], txpname[256], cmdstr[40];
	long tmptime;
	time_t ts;
	struct tm *tptr;
	struct find_t findbuf;
	if(argc<7)
		{
		printf("USAGE: vbrowse <com#> <canned spd> <canned q> <msg spd> <msg q> <dir> [/d]\n");
		printf("Where <dir> has utime.vce message files and q is bits per sample.\n");
		printf("Canned .vce files are looked for in PCCPPATH.\n");
		printf("/d enables DTMF delete option.\n");
		exit(1);
		}
	if(argc==8)
		if((argv[7][0]=='/')&&((argv[7][1]=='d')||(argv[7][1]=='D')))
			delenp=1;
		else
			delenp=0;
	if((quicke=getenv("PCCPPATH"))==NULL)
		{
		printf("You have apparently not set the environment variable PCCPPATH.\n");
		printf("Prompt sequencing is probably going to be appallingly slow, due to\n");
		printf("having to use DOS's executable path search facility.\n");
		sprintf(txpname, "VOICETX.EXE");
		}
	else
		sprintf(txpname, "%s\\VOICETX.EXE", quicke);
	gbdr=atoi(argv[2]);
	gq=argv[3][0];
	mbdr=atoi(argv[4]);
	mq=argv[5][0];
	comnum=atoi(argv[1])-1;
	speed=gbdr;
	databits='8';
	parity='n';
	stopbits='1';
	setport();
	readset();
	oldtick=_dos_getvect(0x1c);
	signal(SIGINT, quit);
	_dos_setvect(0x1c, tickhndl);
	setup();
	index=follow=0;
	sprintf(cmdstr, "at#bdr=%d\r", gbdr/24);
	sendstr(cmdstr);
	scanok();
	sprintf(cmdstr, "at#vbs=%c\r", gq);
	sendstr(cmdstr);
	scanok();
	sprintf(msgss, "%s\\*.vce", argv[6]);
	if(_dos_findfirst(msgss, _A_NORMAL, &findbuf))
		{
		sprintf(grtpname, "%s\\NOFILES.VCE", quicke);
		spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
		pause(12);
		_dos_setvect(0x1c, oldtick);
		exit(1);
		}
	ntimes=0;
	if(sscanf(findbuf.name, "%lx", &times[ntimes++])!=1)
		ntimes--;
	while(!_dos_findnext(&findbuf))
		{
		if(sscanf(findbuf.name, "%lx", &times[ntimes++])!=1)
			ntimes--;
		if(ntimes>=MAXTIMES)
			break;
		}
	for(i=0;i<ntimes;++i)
		for(j=i+1;j<ntimes;++j)
			if(times[i]<times[j])
				{
				tmptime=times[i];
				times[i]=times[j];
				times[j]=tmptime;
				}
	/*
	 * Voice files for user interface. Please reconcile w/ MANUAL
	 *
	 * NOFILES.VCE: "There are no files in the directory."
	 * ENTSHFB.VCE: "entries exist. How far back?"
	 * INSTRUC.VCE "Cancel any playback with star. At any prompt,
	 *	     dial digits, star to clear, pound to enter.
		     Entering nothing exits."
	 * DELETE.VCE "Dial 3 pound to delete, or just pound to proceed."
	 * DELETED.VCE "You have already deleted that message."
	 * <digit>RISE.VCE Decimal digit with rising inflection.
	 * <digit>DIP.VCE Decimal digit with dip inflection.
	 * <digit>FALL.VCE Decimal digit with falling inflection.
	 * POINT.VCE "Point" with mild dip inflection.
	 * AT.VCE "At" with mild dip inflection
	 */
	sprintf(grtpname, "%s\\instruc.vce", quicke);
	spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
	pause(9);
	while(1)
		{
		sprintf(numstr, "%d", ntimes);
		for(cp=numstr;*cp;++cp)
			{
			if(cp[1])
				sprintf(grtpname, "%s\\%cRISE.VCE", quicke, *cp);
			else
				sprintf(grtpname, "%s\\%cDIP.VCE", quicke, *cp);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, NULL);
			}
		sprintf(grtpname, "%s\\ENTSHFB.VCE", quicke);
		spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
		follow=index=fbi=flag=0;
		while(1)
			{
			time(&ts);
			toflag=0;
			while(follow==index)
				if((time(NULL)-ts)>10)
					if(toflag)
						break;
					else
						{
						toflag=1;
						sprintf(grtpname, "%s\\INSTRUC.VCE", quicke);
						spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
						pause(9);
						for(cp=numstr;*cp;++cp)
							{
							if(cp[1])
								sprintf(grtpname, "%s\\%cRISE.VCE", quicke, *cp);
							else
								sprintf(grtpname, "%s\\%cDIP.VCE", quicke, *cp);
							spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, NULL);
							}
						sprintf(grtpname, "%s\\ENTSHFB.VCE", quicke);
						spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
						time(&ts);
						}
			if(follow==index)
				break; /* Timed out after giving instructions */
			c=buf[follow++];
			if(follow>=TBUFSIZ)
				follow=0;
			if((c>='0')&&(c<='9'))
				if(fbi<15)
					farback[fbi++]=c;
				else;
			else if(c=='*')
				fbi=0;
			else if(c=='#')
				{
				if(fbi)
					flag=1;
				break;
				}
			}
		if(!flag)
			break;
		if(atoi(farback)>=ntimes)
			continue;
		tmptime=times[atoi(farback)];
		if(!tmptime)
			{
			sprintf(grtpname, "%s\\DELETED.VCE", quicke);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
			pause(9);
			continue;
			}
		tptr=localtime(&tmptime);
		sprintf(numstr, "%02d", tptr->tm_mon+1);
		for(cp=numstr; *cp; cp++)
			{
			if(cp[1])
				sprintf(grtpname, "%s\\%cRISE.VCE", quicke, *cp);
			else
				sprintf(grtpname, "%s\\%cDIP.VCE", quicke, *cp);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, NULL);
			}
		sprintf(grtpname, "%s\\POINT.VCE", quicke);
		spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
		sprintf(numstr, "%02d", tptr->tm_mday);
		for(cp=numstr; *cp; cp++)
			{
			if(cp[1])
				sprintf(grtpname, "%s\\%cRISE.VCE", quicke, *cp);
			else
				sprintf(grtpname, "%s\\%cDIP.VCE", quicke, *cp);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, NULL);
			}
		sprintf(grtpname, "%s\\AT.VCE", quicke);
		spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
		sprintf(numstr, "%02d", tptr->tm_hour);
		for(cp=numstr; *cp; cp++)
			{
			if(cp[1])
				sprintf(grtpname, "%s\\%cRISE.VCE", quicke, *cp);
			else
				sprintf(grtpname, "%s\\%cDIP.VCE", quicke, *cp);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, NULL);
			}
		sprintf(numstr, "%02d", tptr->tm_min);
		for(cp=numstr; *cp; cp++)
			{
			if(cp[1])
				sprintf(grtpname, "%s\\%cRISE.VCE", quicke, *cp);
			else
				sprintf(grtpname, "%s\\%cFALL.VCE", quicke, *cp);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, NULL);
			}
		pause(9);
		sprintf(cmdstr, "at#vbs=%c\r", mq);
		sendstr(cmdstr);
		scanok();
		sprintf(cmdstr, "at#bdr=%d\r", mbdr/24);
		sendstr(cmdstr);
		scanok();
		cleanup(INHCTL);
		sprintf(msgpname, "%s\\%08lx.VCE", argv[6], tmptime);
		spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[4], msgpname, "*", NULL);
		speed=mbdr;
		setport();
		setup();
		sprintf(cmdstr, "at#bdr=%d\r", gbdr/24);
		sendstr(cmdstr);
		scanok();
		cleanup(INHCTL);
		speed=gbdr;
		setport();
		setup();
		sprintf(cmdstr, "at#vbs=%c\r", gq);
		sendstr(cmdstr);
		scanok();
		if(delenp)
			{
			pause(12);
			sprintf(grtpname, "%s\\DELETE.VCE", quicke);
			spawnlp(P_WAIT, txpname, "voicetx", argv[1], argv[2], grtpname, "*", NULL);
			flag=fbi=0;
			while(1)
				{
				time(&ts);
				while(follow==index)
					if((time(NULL)-ts)>10)
						{
						flag=1;
						break;
						}
				if(flag)
					break;
				c=buf[follow++];
				if(follow>=TBUFSIZ)
					follow=0;
				if(c=='3')
					fbi=!fbi;
				else if(c=='#')
					{
					if(fbi)
						{
						times[atoi(farback)]=0L;
						unlink(msgpname);
						}
					break;
					}
				else if(c!=0x10)
					fbi=0;
				}
			}
		pause(12);
		}
	cleanup(0);
	_dos_setvect(0x1c, oldtick);
	exit(0);
	}
