/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<graph.h>
#include"emu.h"
#include"color.h"
#include"port.h"


unsigned long tick;

void (interrupt far *oldtick)();

void interrupt far tickhndl()
	{
	tick++;
	}

int locechop;

sendraw(str)
	char *str;
	{
	int i;
	i=0;
	while(str[i])
		{
		while(!(inp(basereg+STATREG)&TXMTMASK));
		outp(basereg, str[i++]);
		}
	}

dispkbd(code)
	unsigned short code;
	{
	int i;
	unsigned char ccode, scode;
	ccode=code&0xff;
	scode=(code>>8)&0xff;
	if(ccode)
		{
		while(!(inp(basereg+STATREG)&TXMTMASK));
		if(locechop)
			dispport(ccode);
		outp(basereg, code);
		}
	else
		if(!emu.keys[scode].len)
			putch(0x07);
		else
			for(i=0;i<emu.keys[scode].len;i++)
				{
				while(!(inp(basereg+STATREG)&TXMTMASK));
				if(emu.keys[scode].nullpause_p&&!emu.keys[scode].chars[i])
					{
					tick=0L;
					while(1)
						{
						if(tick>22)
							break;
						}
					}
				else if(emu.keys[scode].nullpause_p&&(emu.keys[scode].chars[i]==0xff))
					{
					tick=0L;
					outp(basereg+LCTLREG, lctl|0x40);
					while(1)
						{
						if(tick>10)
							break;
						}
					outp(basereg+LCTLREG, lctl);
					}
				else
					{
					if(locechop)
						dispport(emu.keys[scode].chars[i]);
					outp(basereg, emu.keys[scode].chars[i]);
					}
				}
	}

#define LISTSIZ 16

struct
	{
	short index;
	short row;
	char rowset;
	short column;
	char colset;
	short list[LISTSIZ];
	short listindex;
	}
	funcstor[NFUNCS];

clrfuncstor(seqn)
	short seqn;
	{
	int i;
	if(funcstor[seqn].listindex==LISTSIZ)
		funcstor[seqn].listindex--;
	for(i=funcstor[seqn].listindex;i>=0;i--)
		funcstor[seqn].list[i]=0;
	funcstor[seqn].row=funcstor[seqn].column=funcstor[seqn].listindex=funcstor[seqn].index=funcstor[seqn].rowset=funcstor[seqn].colset=0;
	}

int bold, faint, blink, inverse, bkcolor, fgcolor;
struct videoconfig far *vconf;

atthndl()
	{
	int adds, workingbk, workingfg;
	adds=0;
	if((vconf->adapter!=_MDPA)&&(vconf->adapter!=_HGC))
		{
		/* Color Adapter */
		workingbk=bkcolor;
		workingfg=fgcolor;
		if(faint&&(fgcolor==WHITE))
			workingfg=GRAY;
		if(bold)
			adds+=BOLDADD;
		if(blink)
			adds+=BLINKADD;
		if(inverse)
			{
			_settextcolor(workingbk+adds);
			_setbkcolor((long)(workingfg&0x07));
			}
		else
			{
			_settextcolor(workingfg+adds);
			_setbkcolor((long)(workingbk&0x07));
			}
		}
	else
		{
		workingbk=BLACK;
		if(bold&&!inverse)
			workingfg=M_UNDER;
		else
			if(inverse)
				workingfg=WHITE;
			else
				workingfg=M_NORMAL;
		if(faint)
			if(inverse)
				if(bkcolor!=BLACK)
					adds+=FAINTADD;
				else;
			else
				if(fgcolor!=BLACK)
					adds+=FAINTADD;
		if(blink)
			adds+=BLINKADD;
		if(inverse)
			{
			_settextcolor(workingbk+adds);
			_setbkcolor((long)(workingfg&0x07));
			}
		else
			{
			_settextcolor(workingfg+adds);
			_setbkcolor((long)(workingbk&0x07));
			}
		}
	}


ansiatthndl(seqn)
	short seqn;
	{
	int i, adds, workingbk, workingfg;
	if(emu.funcs[seqn].func==ANSIATTRIB)
		for(i=0;i<funcstor[seqn].listindex;i++)
			switch(funcstor[seqn].list[i])
				{
				/*at the moment this is strictly ANSI subset*/
				case 0:
					bkcolor=BLACK;
					fgcolor=WHITE;
					bold=faint=blink=inverse=0;
					break;
				case 1:
					bold=1;
					break;
				case 2:
					faint=1;
					break;
				case 5:
				case 6:
					blink=1;
					break;
				case 7:
					inverse=1;
					break;
				case 30:
					fgcolor=BLACK;
					break;
				case 31:
					fgcolor=RED;
					break;
				case 32:
					fgcolor=GREEN;
					break;	
				case 33:
					fgcolor=YELLOW;
					break;
				case 34:
					fgcolor=BLUE;
					break;
				case 35:
					fgcolor=MAGENTA;
					break;
				case 36:
					fgcolor=CYAN;
					break;
				case 37:
					fgcolor=WHITE;
					break;
				case 40:
					bkcolor=BLACK;
					break;
				case 41:
					bkcolor=RED;
					break;
				case 42:
					bkcolor=GREEN;
					break;	
				case 43:
					bkcolor=YELLOW;
					break;
				case 44:
					bkcolor=BLUE;
					break;
				case 45:
					bkcolor=MAGENTA;
					break;
				case 46:
					bkcolor=CYAN;
					break;
				case 47:
					bkcolor=WHITE;
					break;
				default:
					break;
				}
	atthndl();
	}

int wrap_p;

wrapctl()
	{
	if(wrap_p)
		_wrapon(_GWRAPON);
	else
		_wrapon(_GWRAPOFF);
	}

char emupname[256], emubname[13], dribpname[256];

updstatus()
	{
	struct rccoord posptr;
	short tc;
	long bc;
	char str[81];
	posptr=_gettextposition();
	tc=_gettextcolor();
	bc=_getbkcolor();
	_settextwindow(1,1,1,80);
	_settextcolor(BLACK);
	_setbkcolor((long)WHITE);
	_clearscreen(_GWINDOW);
	_wrapon(_GWRAPOFF);
	sprintf(str, " Ctrl-Alt-Shift to Exit  COM%u %5u %c%c%c %8s %30s",
		comnum+1, speed, databits, parity, stopbits, emubname, dribpname);
	_outtext(str);
	_settextwindow(2,1,25,80);
	wrapctl();
	_settextcolor(tc);
	_setbkcolor(bc);
	_settextposition(posptr.row, posptr.col);
	}

int graphics;

showchar(c)
	unsigned char c;
	{
	unsigned char str[2];
	if(graphics)
		if(emu.gchars[c])
			c=emu.gchars[c];
	str[0]=c;
	str[1]='\0';
	_outtext(str);
	}

int savedrow, savedcol;

perffunc(seqn)
	short seqn;
	{
	char str[64];
	struct rccoord posptr;
	int i;
	switch(emu.funcs[seqn].func)
		{
		case CLEAR:
			_clearscreen(_GWINDOW);
			_settextposition(1,1);
			break;
		case HOME:
			_settextposition(1,1);
			break;
		case CLREOL:
			posptr=_gettextposition();
			_wrapon(_GWRAPOFF);
			for(i=posptr.col;i<=80;i++)
				_outtext(" ");
			_settextposition(posptr.row, posptr.col);
			wrapctl();
			break;
		case UP:
			posptr=_gettextposition();
			if(posptr.row>1)
				_settextposition(posptr.row-1, posptr.col);
			break;
		case DOWN:
			posptr=_gettextposition();
			if(posptr.row<24)
				_settextposition(posptr.row+1, posptr.col);
			else
				{
				showchar('\n');
				_settextposition(posptr.row, posptr.col);
				}
			break;
		case LEFT:
			posptr=_gettextposition();
			if(posptr.col>1)
				_settextposition(posptr.row, posptr.col-1);
			break;
		case RIGHT:
			posptr=_gettextposition();
			if(posptr.col<80)
				_settextposition(posptr.row, posptr.col+1);
			break;
		case GOTO:
			funcstor[seqn].row-=(emu.firstrowaddr-1);
			funcstor[seqn].column-=(emu.firstcoladdr-1);
			if(funcstor[seqn].row<1)
				funcstor[seqn].row=1;
			if(funcstor[seqn].row>24)
				funcstor[seqn].row=24;
			if(funcstor[seqn].column<1)
				funcstor[seqn].column=1;
			if(funcstor[seqn].column>80)
				funcstor[seqn].row=80;
			_settextposition((emu.tophi_p?25-funcstor[seqn].row:funcstor[seqn].row), funcstor[seqn].column);
			break;
		case NORMAL:
			fgcolor=WHITE;
			bkcolor=BLACK;
			blink=faint=bold=inverse=0;
			atthndl();
			break;
		case BLINK:
			blink=1;
			atthndl();
			break;
		case NOBLINK:
			blink=0;
			atthndl();
			break;
		case BOLD:
			bold=1;
			atthndl();
			break;
		case NOBOLD:
			bold=0;
			atthndl();
			break;
		case FAINT:
			faint=1;
			atthndl();
			break;
		case NOFAINT:
			faint=0;
			atthndl();
			break;
		case INVERSE:
			inverse=1;
			atthndl();
			break;
		case NOINVERSE:
			inverse=0;
			atthndl();
			break;
		case UPN:
			posptr=_gettextposition();
			if(posptr.row-funcstor[seqn].row<1)
				_settextposition(1, posptr.col);
			else
				_settextposition(posptr.row-funcstor[seqn].row, posptr.col);
			break;
		case DOWNN:
			posptr=_gettextposition();
			if(posptr.row+funcstor[seqn].row>24)
				{
				_settextposition(24,1);
				for(i=25-(posptr.row+funcstor[seqn].row);i<0;++i)
					showchar('\n');
				_settextposition(24, posptr.col);
				}
			else
				_settextposition(posptr.row+funcstor[seqn].row, posptr.col);
			break;
		case LEFTN:
			posptr=_gettextposition();
			if(posptr.col-funcstor[seqn].column<1)
				_settextposition(posptr.row, 1);
			else
				_settextposition(posptr.row, posptr.col-funcstor[seqn].column);
			break;
		case RIGHTN:
			posptr=_gettextposition();
			if(posptr.col+funcstor[seqn].column>80)
				_settextposition(posptr.row, 80);
			else
				_settextposition(posptr.row, posptr.col+funcstor[seqn].column);
			break;
		case ANSIATTRIB:
			ansiatthndl(seqn);
			break;
		case WRAP:
			wrap_p=1;
			wrapctl();
			break;
		case NOWRAP:
			wrap_p=0;
			wrapctl();
			break;
		case GOTOLINE:
			funcstor[seqn].row-=(emu.firstrowaddr-1);
			posptr=_gettextposition();
			if(funcstor[seqn].row<1)
				funcstor[seqn].row=1;
			if(funcstor[seqn].row>24)
				funcstor[seqn].row=24;
			_settextposition(emu.tophi_p?25-funcstor[seqn].row:funcstor[seqn].row, 1);
			break;
		case GOTOCOL:
			funcstor[seqn].column-=(emu.firstcoladdr-1);
			posptr=_gettextposition();
			if(funcstor[seqn].column<1)
				funcstor[seqn].column=1;
			if(funcstor[seqn].column>80)
				funcstor[seqn].row=80;
			_settextposition(posptr.row, funcstor[seqn].column);
			break;
		case BINATTR:
			if((funcstor[seqn].row-emu.attroffset)&emu.blinkmask)
				blink=1;
			else
				blink=0;
			if((funcstor[seqn].row-emu.attroffset)&emu.inversemask)
				inverse=1;
			else
				inverse=0;
			if((funcstor[seqn].row-emu.attroffset)&emu.boldmask)
				bold=1;
			else
				bold=0;
			if((funcstor[seqn].row-emu.attroffset)&emu.faintmask)
				faint=1;
			else
				faint=0;
			atthndl();
			break;
		case GRAPHCHAR:
			showchar(emu.gchars[funcstor[seqn].row]);
			break;
		case BEGGRAPH:
			graphics=1;
			break;
		case ENDGRAPH:
			graphics=0;
			break;
		case TAB:
			posptr=_gettextposition();
			_settextposition(posptr.row, posptr.col+(8-((posptr.col-1)%8)));
			break;
		case BELL:
			putch(7);
			break;
		case DTAB:
			posptr=_gettextposition();
			for(i=0;i<(8-((posptr.col-1)%8));++i)
				_outtext(" ");

		case CRLF:
			showchar('\n');
			break;
		case SAVEPOS:
			posptr=_gettextposition();
			savedrow=posptr.row;
			savedcol=posptr.col;
			break;
		case RESTOREPOS:
			_settextposition(savedrow, savedcol);
			break;
		case RESPOND:
			dispkbd(0x0000); /* Macro for scancode 0 */
			break;
		case ANSICPR:
			posptr=_gettextposition();
			sprintf(str, "\033[%d;%dR", posptr.row, posptr.col);
			sendraw(str);
			break;
		default:
			break;
		}
	}

int foundfuncs;

dispport(c)
	unsigned char c;
	{
	int seqn, done, ok;
	done=0;
	ok=0;
	for(seqn=0;seqn<foundfuncs;seqn++)
		{
		if(emu.funcs[seqn].codes[funcstor[seqn].index]&0xff00)
			switch(emu.funcs[seqn].codes[funcstor[seqn].index])
				{
				case END:
					if(funcstor[seqn].index)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case BINCOL:
					funcstor[seqn].column=c-emu.bincoloff;
					ok=1;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case BINROW:
					funcstor[seqn].row=c-emu.binrowoff;
					ok=1;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case ASCDECCOL:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].column*=10;
						funcstor[seqn].column+=(c-'0');
						funcstor[seqn].colset=1;
						}
					else
						if(funcstor[seqn].colset&&(c==emu.funcs[seqn].codes[++funcstor[seqn].index]))
							{
							ok=1;
							if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
								{
								done=1;
								perffunc(seqn);
								}
							}
						else
							clrfuncstor(seqn);
					break;
				case ASCDECROW:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].row*=10;
						funcstor[seqn].row+=(c-'0');
						funcstor[seqn].rowset=1;
						}
					else
						if(funcstor[seqn].rowset&&(c==emu.funcs[seqn].codes[++funcstor[seqn].index]))
							{
							ok=1;
							if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
								{
								done=1;
								perffunc(seqn);
								}
							}
						else
							clrfuncstor(seqn);
					break;
				case ASCDECSEMILIST:
					if((c>='0')&&(c<='9')&&(funcstor[seqn].listindex<LISTSIZ))
						{
						ok=1;
						funcstor[seqn].list[funcstor[seqn].listindex]*=10;
						funcstor[seqn].list[funcstor[seqn].listindex]+=(c-'0');
						}
					else
						{
						if(funcstor[seqn].listindex<LISTSIZ)
							funcstor[seqn].listindex++;
						
						if(c==';')
							ok=1;
						else
							if(c==emu.funcs[seqn].codes[++funcstor[seqn].index])
								{
								ok=1;
								if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
									{
									done=1;
									perffunc(seqn);
									}
								}
							else
								clrfuncstor(seqn);
						}
					break;
				case GRABCHAR:
					ok=1;
					funcstor[seqn].row=c;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case GRAPHCHAR_T:
					if(emu.gchars[c])
						{
						ok=1;
						funcstor[seqn].row=c;
						if(emu.funcs[seqn].codes[funcstor[seqn].index]==END)
							{
							done=1;
							perffunc(seqn);
							}
						}
					else
						clrfuncstor(seqn);
					break;
				}
		else
			if(c==emu.funcs[seqn].codes[funcstor[seqn].index])
				{
				ok=1;
				if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
					{
					done=1;
					perffunc(seqn);
					}
				}
			else
				clrfuncstor(seqn);
		if(done)
			{
			ok=1;
			for(seqn=0;seqn<foundfuncs;seqn++)
				clrfuncstor(seqn);
			break;
			}
		}
	if(!ok)
		showchar(c);
	}

initdisp()
	{
	int i;
	for(i=0;i<foundfuncs;i++)
		{
		funcstor[i].listindex=LISTSIZ;
		clrfuncstor(i);
		}
	bold=faint=blink=inverse=0;
	fgcolor=WHITE;
	bkcolor=BLACK;
	graphics=0;
	wrap_p=emu.default_wrap_p;
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	FILE *dribble;
	int follow, emufd, i, j, orun;
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run TERM? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("I didn't think so!\n");
			exit(99);
			}
		else
			printf("OK, you're the boss!\n");
		}
	_getvideoconfig(vconf);
	_setvideomode(_DEFAULTMODE);
	index=follow=0;
	if((argc<4)||(argc>6))
		{
		printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
		printf("USAGE: term <comnum> <bps> <data><parity><stop> [<emu or - >] [<dribble>]\n");
		printf("<emu> is an emulation file base pathname.\n");
		printf("<dribble> is a dribble (text capture) file.\n");
		printf("The environment variable PCCPPATH is used for the emulation file if set.\n");
		exit(1);
		}
	emupname[0]='\0';
	dribpname[0]='\0';
	if((argc>=5)&&(argv[4][0]=='+'))
		{
		locechop=1;
		argv[4]++;
		}
	else
		locechop=0;
	if((argc>=5)&&(argv[4][0]!='-'))
		{
		if((getenv("PCCPPATH")==NULL)||(argv[4][0]=='\\')||(argv[4][0]&&(argv[4][1]==':'))||(argv[4][0]=='.'))
			sprintf(emupname, "%s.emu", argv[4]);
		else
			sprintf(emupname, "%s\\%s.emu", getenv("PCCPPATH"), argv[4]);
		if((emufd=open(emupname, O_RDONLY|O_BINARY))==-1)
			{
			printf("Error opening emulation file %s.\n", emupname);
			exit(2);
			}
		else
			if(read(emufd, &emu, sizeof(emu))!=sizeof(emu))
				{
				printf("Error reading emulation file %s.\n", emupname);
				exit(3);
				}
			else;
		for(i=strlen(argv[4]);(i>=0)&&(argv[4][i]!='\\')&&(argv[4][i]!=':');i--);
		i++;
		for(j=0;argv[4][i];i++,j++)
			emubname[j]=argv[4][i];
		emubname[j]='\0';
		}
	else
		{
		strcpy(emubname, "-");
		nullemu();
		emu.funcs[0].func=LEFT;
		emu.funcs[0].codes[0]='\b';
		emu.funcs[0].codes[1]=END;
		emu.funcs[1].func=DTAB;
		emu.funcs[1].codes[0]='\t';
		emu.funcs[1].codes[1]=END;
		emu.funcs[2].func=BELL;
		emu.funcs[2].codes[0]='\007';
		emu.funcs[2].codes[1]=END;
		}
	for(foundfuncs=NFUNCS;foundfuncs>=0;foundfuncs--)
		if(emu.funcs[foundfuncs].func!=NOOP)
			break;
	foundfuncs++;
	if(argc==6)
		{
		strcpy(dribpname, argv[5]);
		if((dribble=fopen(argv[5], "a"))==NULL)
			{
			printf("Couldn't open dribble file %s.\n");
			exit(10);
			}
		else
			{
			setmode(fileno(dribble), O_BINARY);
			fprintf(dribble, "\r\nBeginning of dribble segment.\r\n\n");
			}
		}
	else
		{
		strcpy(dribpname, "-");
		dribble=NULL;
		}
	oldtick=_dos_getvect(0x1c);
	_dos_setvect(0x1c, tickhndl);
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	parity=argv[3][1];
	databits=argv[3][0];
	stopbits=argv[3][2];
	setport();
	readset();
	setup();
	_clearscreen(_GCLEARSCREEN);
	initdisp();
	updstatus();
	atthndl();
	_settextposition(1,1);
	orun=0;
	if(vconf->adapter==_VGA)
		_remappalette(GRAY, (long)0x001a1a1a); /* Lighten up gray */
	while(1)
		{
		if((_bios_keybrd(_KEYBRD_SHIFTSTATUS) & 0x0f)>12)
			{
			cleanup(0);
			_settextcolor(WHITE);
			_setbkcolor((long)BLACK);
			_settextposition(24,1);
			if(dribble!=NULL)
				{
				fprintf(dribble, "\r\nEnd of dribble segment.\r\n");
				fclose(dribble);
				}
			if(vconf->adapter==_VGA)
				_remappalette(GRAY, _GRAY); /* Restore gray */
			_dos_setvect(0x1c, oldtick);
			_outtext("\nOrderly exit from TERM.\n");
			exit(0);
			}
		if(_bios_keybrd(_KEYBRD_READY))
			dispkbd(_bios_keybrd(_KEYBRD_READ));
		if(follow!=index)
			{
			if(dribble!=NULL)
				fputc(buf[follow], dribble);
			/* We only display if we're not too far behind; */
			/* this makes dribble more reliable. */
			if(((index-follow)>4096)||(((index-follow)<0)&&((follow-index)<4096)))
				if(!orun)
					{
					orun=1;
					initdisp();
					}
				else;
			else
				{
				orun=0;
				dispport(buf[follow]);
				}
			follow++;
			if(follow>=TBUFSIZ)
				follow=0;
			}
		}
	}
