/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 */

#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<bios.h>
#include<graph.h>
#include"emu.h"

main(argc, argv)
	int argc;
	char **argv;
	{
	int emufd, major, minor, scan, value;
	char c, fpname[256];
	_settextposition(25,1);
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	printf("You may set the environment variable PCCPPATH.\n");
	printf("If not set we use the current directory.\n\n");
	printf("You should have a copy of emu.h to consult to program display functions.\n\n");
	printf("Making a variable length substitution token last in a\n");
	printf("function sequence is highly questionable.\n\n");
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run EMUED? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("I didn't think so!\n");
			exit(99);
			}
		else
			printf("OK, you're the boss!\n");
		}
	if(argc!=2)
		{
		printf("USAGE: emued <emu file basename>\n");
		exit(1);
		}
	if((getenv("PCCPPATH")==NULL)||(argv[1][0]=='.')||(argv[1][0]=='\\')&&(argv[1][0]&&(argv[1][1]!=':')))
		sprintf(fpname, "%s.emu", argv[1]);
	else
		sprintf(fpname, "%s\\%s.emu", getenv("PCCPPATH"), argv[1]);
	if((emufd=open(fpname, O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening existing emu file %s for read.\nStarting from scratch.\n\n", fpname);
		nullemu();
		}
	else if(read(emufd, &emu, sizeof(emu))!=sizeof(emu))
		{
		printf("Error reading existing emu file %s.\nStarting from scratch.\n\n", fpname);
		nullemu();
		}
	if(emufd!=-1)
		close(emufd);
	while(1)
		{
		printf("\n\nm(isc), k(ey), f(unc), g(raphics char), w(rite) or q(uit)? --> ");
		c=getch();
		printf("%c\n", c);
		if(c=='m')
			{
			printf("First column numeric address = %d\n", emu.firstcoladdr);
			printf("First row numeric address = %d\n", emu.firstrowaddr);
			printf("Modify? --> ");
			if(getch()=='y')
				{
				printf("y\nEnter first column numeric address (decimal): --> ");
				scanf("%d", &value);
				emu.firstcoladdr=value;
				printf("Enter first row numeric address (decimal): --> ");
				scanf("%d", &value);
				emu.firstrowaddr=value;
				}
			else
				printf("n\n");
			printf("\ntophi_p = %d {1 => top row is 24; 0 => top is 1}\n", (int)emu.tophi_p);
			printf("Binary row offset = %02x\n", emu.binrowoff);
			printf("Binary column offset = %02x\n", emu.bincoloff);
			printf("default_wrap_p = %d\n", emu.default_wrap_p);
			printf("Modify? --> ");
			if(getch()=='y')
				{
				printf("y\nEnter tophi_p (0 or 1): --> ");
				scanf("%d", &value);
				emu.tophi_p=value;
				printf("Enter binary row offset (hex): --> ");
				scanf("%x", &value);
				emu.binrowoff=value;
				printf("Enter binary column offset (hex): --> ");
				scanf("%x", &value);
				emu.bincoloff=value;
				printf("Enter default_wrap_p (0 or 1): --> ");
				scanf("%d", &value);
				emu.default_wrap_p=value;
				}
			else
				printf("n\n");
			printf("\nBinary attribute zero bitmap offset char = %02x\n", emu.attroffset);
			printf("Bold attribute bitmask = %02x\n", emu.boldmask);
			printf("Faint attribute bitmask = %02x\n", emu.faintmask);
			printf("Blink attribute bitmask = %02x\n", emu.blinkmask);
			printf("Inverse attribute bitmask = %02x\n", emu.inversemask);
			printf("Modify? --> ");
			if(getch()=='y')
				{
				printf("y\nEnter binary attribute zero bitmap offest char (hex): --> ");
				scanf("%x", &value);
				emu.attroffset=value;
				printf("Enter bold attribute bitmask (hex): -- > ");
				scanf("%x", &value);
				emu.boldmask=value;
				printf("Enter faint attribute bitmask (hex): --> ");
				scanf("%x", &value);
				emu.faintmask=value;
				printf("Enter blink attribute bitmask (hex): --> ");
				scanf("%x", &value);
				emu.blinkmask=value;
				printf("Enter inverse attribute bitmask (hex): --> ");
				scanf("%x", &value);
				emu.inversemask=value;
				}
			else
				printf("n\n");
			}
		if(c=='k')
			{
			printf("Operate the key (0 = code 0x00 (response)) --> ");
			while(!_bios_keybrd(_KEYBRD_READY));
			major=_bios_keybrd(_KEYBRD_READ);
			if((major&0xff)&&((major&0xff)!='0'))
				printf("\n\007Not a programmable key!\n");
			else
				{
				if((major&0xff)=='0')
					major=0;
				else
					major=(major>>8)&0xff;
				printf("\nScancode 0x%02x selected; ", major);
				if(emu.keys[major].nullpause_p)
					printf("00 => pause > 1 sec. and ff => break.\n");
				else
					printf("all codes literal.\n");
				printf("Present contents (blank line means empty):\n");
				for(minor=0;minor<emu.keys[major].len;++minor)
					printf(" %02x", emu.keys[major].chars[minor]);
				printf("\nModify? (y or n): --> ");
				if(getch()=='y')
					{
					printf("y\nZero means 1.1 sec pause and ff means break? (y or n): --> ");
					if(getch()=='y')
						{
						printf("y\n");
						emu.keys[major].nullpause_p=1;
						}
					else
						{
						printf("n\n");
						emu.keys[major].nullpause_p=0;
						}
					printf("Enter chars (up to %d). INSERT to enter in hex. END to end:\n-->\n\n", KEYLEN);
					_settextposition(23,4);
					minor=0;
					while(1)
						{
						value=_bios_keybrd(_KEYBRD_READ);
						if(value==0x5200)
							{
							printf("\nEnter hex code: --> ");
							scanf("%x", &value);
							_settextposition(24,1);
							printf("\t\t\t\t\t\t\t\t\t\r");
							}
						else
							if(value==0x4f00)
								value=END;
							else
								value&=0xff;
						if(value==END)
							{
							printf("\n");
							emu.keys[major].len=minor;
							break;
							}
						else
							if(minor<KEYLEN)
								{
								emu.keys[major].chars[minor++]=value;
								_settextposition(23,1);
								for(scan=0;scan<minor;scan++)
									printf(" %02x", emu.keys[major].chars[scan]);
								printf(" -->");
								}
							else
								{
								printf("\nExcess char ignored.\n");
								emu.keys[major].len=KEYLEN;
								break;
								}
							}
					}
				else
					printf("n\n");
				}
			}
		if(c=='f')
			{
			printf("Sequence number (decimal): --> ");
			scanf("%d", &major);
			if((major<0)||(major>=NFUNCS))
				printf("Bad sequence number.\n");
			else
				{
				printf("Function is presently #%d decimal.\n", emu.funcs[major].func);
				for(minor=0;emu.funcs[major].codes[minor]!=END;++minor)
					printf(" %03x", emu.funcs[major].codes[minor]);
				printf("\nModify? (y or n): --> ");
				if(getch()=='y')
					{
					printf("y\nEnter function number in decimal. --> ");
					scanf("%d", &value);
					if((value<0)||(value>LASTFUN))
						printf("Bad function number.\n");
					else
						{
						emu.funcs[major].func=value;
						printf("Enter chars (up to %d). INSERT to enter in hex. END at end:\n-->\n\n", FUNLEN-1);
						_settextposition(23,4);
						minor=0;
						while(1)
							{
							value=_bios_keybrd(_KEYBRD_READ);
							if(value==0x5200)
								{
								printf("\nEnter hex code: --> ");
								scanf("%x", &value);
								_settextposition(24,1);
								printf("\t\t\t\t\t\t\t\r");
								}
							else
								if(value==0x4f00)
									value=END;
								else
									value&=0xff;
							emu.funcs[major].codes[minor++]=value;
							if(value==END)
								{
								printf("\n");
								break;
								}
							else
								if(minor<FUNLEN)
									{

									_settextposition(23,1);
									for(scan=0;scan<minor;scan++)
										printf(" %03x", emu.funcs[major].codes[scan]);
									printf(" -->");
									}
								else
									{
									minor--;
									printf("\nExcess code ignored.\n");
									emu.funcs[major].codes[FUNLEN-1]=END;
									break;
									}
							}
						}
					}
				else
					printf("n\n");
				}
			}
		if(c=='g')
			{
			printf("Enter char or INSERT to enter in hex: --> ");
			value=_bios_keybrd(_KEYBRD_READ);
			if(value==0x5200)
				{
				printf("Enter hex: --> ");
				scanf("%x", &value);
				}
			else
				{
				value&=0xff;
				printf("%c\n", value);
				}
			if(emu.gchars[value])
				printf("Hex code %02x  Current char: -->%c<--  Modify? (y or n) --> ", value, emu.gchars[value]);
			else
				printf("Hex code %02x  Current char is zero (unspecified).  Modify? (y or n) --> ", value);
			if(getch()=='y')
				{
				printf("y\nEnter hex code of new graphics character: --> ");
				scanf("%x", &emu.gchars[value]);
				if(emu.gchars[value])
					printf("gchar %02x hex is now: -->%c<--\n", value, emu.gchars[value]);
				else
					printf("gchar %02x hex is now zero (unspecified).\n", value);
				}
			else
				printf("n\n");
			}
		if(c=='w')
			{
			if((emufd=open(fpname, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, S_IWRITE))==-1)
				{
				printf("Error opening emu file for write.\n");
				}
			else
				{
				if(write(emufd, &emu, sizeof(emu))!=sizeof(emu))
					printf("Write error!\n");
				else
					printf("Emulation structure written successfully.\n");
				close(emufd);
				}
			}
		if(c=='q')
			break;
		}
	exit(0);
	}
