{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,R-,S+,V+,X-}
{$M 16384,0,200000}

Program Records;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ This program allows the user to input data to a sales record.          }
{ The data for the record are Name, Item, Quantity, Unit Price and VAT   }
{ Rate and this data can be entered into memory by the user response to  }
{ screen prompts. The input is checked for correctness of type and form. }
{ An initial menu allows the user to make a record file on disk or to    }
{ open an existing record file and, once open, the user can append to,   }
{ change data on or read from this record file. Because of the           }
{ sequential storage of the records on disk, it is not easy to remove a  }
{ record and pack the disk file. For simplicity, deletion is achieved by }
{ changing the record fields for name and item to spaces and the numeric }
{ fields to zeros, effectively giving an empty record.                   }
{ Finally when the user selects Quit, the program automatically closes   }
{ the record file before returning to DOS.                               }
{                                                                        }
{ RECORDS.PAS  ->  RECORDS.EXE       R. Shaw       14.12.92              }
{________________________________________________________________________}

uses Crt,Dos;

Type
   SaleType = Record                  { A record of sales containing two }
     Name       : string[50];         { string fields and three numeric  }
     Item       : string[20];         { fields. For display of the data, }
     Quantity   : integer;            { the total price is calculated as }
     UnitPrice  : real;               { Quantity * UnitPrice*(1+VAT/100) }
     VAT        : real;               { where VAT is entered as a        }
   end;                               { percentage value (i.e. 17.5)     }

Const              { A set of constant strings used to display the Menu. }
   i1 = 'M';
   s1 = 'ake a record file - existing names will be listed.';
   i2 = 'O';
   s2 = 'pen an existing file - select from given list.';
   i3 = 'I';
   s3 = 'nput new record data - field names shown in window.';
   i4 = 'A';
   s4 = 'ppend new record to file - must have input in window.';
   i5 = 'C';
   s5 = 'hange a record on file - must have input in window.';
   i6 = 'R';
   s6 = 'ead a record from file - range of record numbers shown.';
   i7 = 'Q';
   s7 = 'uit and close any open file.';
   i8 = '';
   s8 = 'Please make choice by typing the initial letter: ';
   i9 = '';
   s9 = 'Options to input data and append, change and read ';
   i10 = '';
   s10 = 'records will be available, once a file is opened.';

Var
  Sale          : SaleType;             { An instance of the SaleType record.}
  SalesFile     : File of SaleType;     { A file of such records.            }
  reply,c       : char;
  Name          : string[50];
  Position      : longint;
  TempFile      : Text;       { Temporary file holding directory information.}
  Line          : string[80];
  Ch            : Char;
  FName         : string[12];
  Fle           : array [1..6] of string[8];
  b,i, code     : integer;
  rpos          : longint;
  TotalCost     : real;       { Calculated as Quantity*UnitPrice*(1+VAT/100) }
  Open          : Boolean;    { True if file open, false if not open.        }
  IOR           : word;
  QuantityStr   : string;     { These three string variables are used to     }
  PriceStr      : string;     { ensure that at least one character is entered}
  VATStr        : string;     { and hence ensure integrity of input.         }

Procedure Init;               { To initialise variables, window size and     }
Begin                         { colour and clear the screen.                 }
   name := ' ';
   Sale.Name := ' ';
   Sale.Item := ' ';
   Sale.Quantity := 0;
   Sale.UnitPrice := 0;
   Sale.VAT  := 0;
   reply := ' ';
   Window(1,1,80,25);
   TextBackGround(Black);
   ClrScr;
   Open := False;
End;      {Proc Init}

Procedure Display(x,y : integer; I,S : string);
Begin
   GoToXY(x,y);               { To display two strings in different colours }
   TextColor(red);            { at a specified x,y location.                }
   write(I);
   TextColor(Black);
   write(S);
End;

procedure CreateFile(Filename : string);    { To create a new file on disk, }
begin                                       { open it by rewriting it, so   }
   Assign(SalesFile,Filename);              { that there are no records     }
   Rewrite(SalesFile);                      { preserved from a possible     }
   Open := True;                            { previous file with same name. }
end;        {Proc CreateFile}

procedure OpenFile(Filename : string);    { To open an existing file on disk,}
begin                                     { and reset it, so that existing   }
   Assign(SalesFile,Filename);            { records are preserved.           }
   Reset(SalesFile);
   Open := True;
end;        {Proc OpenFile}


Procedure Choices;            { To display appropriate Menu options,   }
Begin                         { initially to open a file and then      }
   Window(11,2,69,12);        { once open, to allow input of data, or  }
   TextColor(red);            { to append, change or read a record.    }
   TextBackGround(white);     { The initial letter for each option is  }
   ClrScr;                    { shown in red and is used for selection.}
   GoToXY(24,1);
   write('MENU');
   TextColor(black);
   GoToXY(1,2);
   write(' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');

   If Open = True then
         Begin
           GoToXY(2,3);
           write('File ');
           TextColor(red);
           write(FName);
           TextColor(black);
           write(' now open, please make additional choice.');
           Display(2,5,i3,s3);
           Display(2,6,i4,s4);
           Display(2,7,i5,s5);
           Display(2,8,i6,s6);
           Display(2,9,i7,s7);
           Display(2,11,i8,s8);
         End
       else
         Begin
           Display(2,3,i1,s1);
           Display(2,4,i2,s2);
           Display(2,6,i9,s9);
           Display(2,7,i10,s10);
           Display(2,9,i7,s7);
           Display(2,11,i8,s8);
         End;
end;

Procedure DosDir;           { To obtain a directory listing of all record  }
                            { files with extension names .REC and place    }
begin                       { the list in a file RECFILE.LST, which is then}
  window(15,15,60,18);      { read and the list displayed in a window below}
  GoToXY(2,2);                                          { the Menu window. }
  write('Please wait whilst disk is accessed... ');
  TextColor(LightGray);     
  SwapVectors;                                          
  Exec(GetEnv('COMSPEC'),'/C DIR *.REC/W>RECFILE.LST');
  If DosError <> 0 then writeln('Dos error # ',DosError);
  SwapVectors;
  Assign(TempFile,'RECFILE.LST');
  Reset(TempFile);
  Readln(TempFile,Line);
  Readln(TempFile,Line);
  Readln(TempFile,Line);
  Readln(TempFile,Line);
  window(9,15,71,20);
  TextColor(Black);
  TextBackGround(cyan);
  ClrScr;
  GoToXY(1,1);
  writeln('List of existing record files: ');
  Readln(TempFile,Line);
  Fle[1] := Copy(Line,1,8);
  Fle[2] := Copy(Line,14,8);
  Fle[3] := Copy(Line,27,8);
  Fle[4] := Copy(Line,40,8);
  Fle[5] := Copy(Line,53,8);
  Fle[6] := Copy(Line,66,8);
  For i := 1 to 6 do write('  ',Fle[i],' ');
  repeat
      writeln;
      Readln(TempFile,Line);
      Ch := Line[1];
      If Ch <> ' ' then
         begin
           Fle[1] := Copy(Line,1,8);
           Fle[2] := Copy(Line,14,8);
           Fle[3] := Copy(Line,27,8);
           Fle[4] := Copy(Line,40,8);
           Fle[5] := Copy(Line,53,8);
           Fle[6] := Copy(Line,66,8);
           For i := 1 to 6 do write('  ',Fle[i],' ');
         end;
  until Ch = ' ';
  Close(TempFile);
  Window(10,22,70,24);
  TextColor(Yellow);
  TextBackGround(Blue);
  ClrScr;
  GoToXY(2,2);
  Write('Please enter the filename and press ENTER key: ');
  Readln(FName);
  b := Pos('.',FName);
  If b = 0 then b := length(FName) else b := b - 1;
  FName := Copy(FName,1,b);
  For i := 1 to b do FName[i] := UpCase(FName[i]);
  FName := FName + '.REC';
  If UpCase(reply) = 'M' then CreateFile(Fname);
  If UpCase(reply) = 'O' then OpenFile(Fname);
  Window(1,1,80,25);
  TextBackGround(black);
  ClrScr;
  Choices;
end;         { Proc DosDIR }

Procedure RecordWindow;        { To create a window for entry of the data   }
                               { for each field of the new or revised record}
Begin
   Window(1,13,80,25);
   TextBackGround(Black);
   ClrScr;
   Window(2,14,78,22);
   TextBackGround(White);
   TextColor(Blue);
   ClrScr;
   GoToXY(3,3);
   write('Name  (<50 characters) : ');
   GoToXY(3,4);
   write('Item  (<20 characters) : ');
   GoToXY(3,5);
   write('Quantity  (<10000)     : ');
   GoToXY(3,6);
   write('UnitPrice (<1 million) : ');
   GoToXY(3,7);
   write('VAT per cent (<100.00) : ');
   GoToXY(3,8);
   write('Total Cost             : ');
   GoToXY(26,3);
End;            { Proc RecordWindow }


Procedure InputData;       { To input data with check of data type and form. }
                           { All the data is entered in string format, to    }
Begin                      { ensure that at least a space is entered. The    }
  RecordWindow;            { numeric data is then converted using the VAL    }
  GoToXY(2,1);             { procedure and then checked for range.           }
  write('Please supply the data for this record: ');
  With Sale do
     Begin
        {$I-}
        {$R-}
        Repeat
           IOR:= 1;
           GoToXY(28,3);
           ClrEol;
           Readln(Name);
           IOR := IOResult;
        Until (IOR = 0) and (Sale.Name <> '') and (Sale.Name[0] < #50);
        IOR := 1;
        Repeat
           GoToXY(28,4);
           ClrEol;
           Readln(Item);
           IOR := IOResult;
        Until (IOR = 0) and (Sale.Item <> '') and (Sale.Item[0] < #20);
        Repeat
           GoToXY(28,5);
           ClrEol;
           readln(QuantityStr);
           val(QuantityStr,Quantity,code);
           until (QuantityStr[0] < #5) and (QuantityStr <> '') and
                 (Quantity >= 0) and (code = 0);
        Repeat
           GoToXY(28,6);
           ClrEol;
           Readln(PriceStr);
           val(PriceStr,UnitPrice,code);
        Until (PriceStr[0] < #10) and (PriceStr <> '') and
              (UnitPrice >= 0)  and (code = 0);
        Repeat
           GoToXY(28,7);
           ClrEol;
           Readln(VATStr);
           val(VATStr,VAT,code);
        Until (VATStr[0] < #6) and (VATStr <> '') and (VAT >= 0) and
              (VAT < 100) and (code = 0);
        {$I+}
        {$R+}
        GoToXY(28,8);
        TotalCost := Quantity * UnitPrice * ( 1 + VAT/100 );
        write(TotalCost:10:2);
     End;
End;       {Proc InputData}


procedure AppendRecord(Filename : string);     { To append new data to the}
begin                                          { currently open disk file.}
   Seek(SalesFile,FileSize(SalesFile));
   Write(SalesFile,Sale);
   Window(1,13,80,25);
   TextBackGround(black);
   ClrScr;
end;

procedure ChangeRecord(Filename : string; Recpos : longint);
begin                                          { To change an existing record}
   If Recpos > (FileSize(SalesFile) - 1) then  { on the currently open file. }
     Begin
       GoToXY(10,25);
       write('Beyond the end of file of records. Press any key to continue.');
       c := readkey;
       exit;
     End;
   Seek(SalesFile,Recpos);
   write(SalesFile,Sale);
   Window(1,13,80,25);
   TextBackGround(black);
   ClrScr;
end;

procedure ReadRecord(Filename : string; Recpos : longint);
begin
   If RecPos > (FileSize(SalesFile) - 1) then     { To read a specific record}
     Begin                                     { from the currently open file}
       GoToXY(10,25);                          { and display the information.}
       write('Beyond the end of file of records. Press any key to continue.');
       c := readkey;
       exit;
     End;
   Seek(SalesFile,RecPos);
   Read(SalesFile,Sale);
   RecordWindow;
   With Sale do
   begin
     GoToXY(3,1);
     ClrEol;
     write('Record number: ',RecPos);
     GoToXY(28,3);
     ClrEol;
     write(Name);
     GoToXY(28,4);
     ClrEol;
     write(Item);
     GoToXY(28,5);
     ClrEol;
     write(Quantity:7);
     GoToXY(28,6);
     ClrEol;
     write(UnitPrice:10:2);
     GoToXY(28,7);
     ClrEol;
     write(VAT:10:2);
     GoToXY(28,8);
     TotalCost := Quantity * UnitPrice * ( 1 + VAT/100 );
     write(TotalCost:10:2);
   end;
end;

{Main program starts here}

Begin
   ClrScr;
   Init;
   Assign(TempFile,'RECFILE.LST');
   Rewrite(TempFile);
   Close(TempFile);
   repeat
     Choices;
     reply := readkey;
     write(UpCase(reply));
     If (UpCase(reply) = 'C') or (UpCase(reply) = 'R') then
        begin
           window(10,24,70,25);
           TextColor(Black);
           TextBackGround(cyan);
           ClrScr;
           GoToXY(3,1);
           writeln('Record numbers range from 0 to ',FileSize(SalesFile) - 1);
           write('Please type the record number required and press ENTER: ');
           readln(rpos);
        end;
     Case UpCase(reply) of
      'M' : DosDir;
      'O' : DosDir;
      'I' : InputData;
      'A' : AppendRecord(FName);
      'C' : ChangeRecord(FName, rpos);
      'R' : ReadRecord(FName, rpos);
      'Q' : If Open = True then Close(SalesFile);
     end;
   Until UpCase(reply) = 'Q';
   Window(1,1,80,25);
   TextBackGround(Black);
   TextColor(LightGray);
   ClrScr;
 end.




