{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,R-,S+,V+,X-}
{$M 4096,0,20000}

program HeapList;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ The program demonstrates the creation of a single linked list of  }
{ records on the Heap, using pointers. The user is invited to enter }
{ the name, as a string[15], and price in pence, as an integer, for }
{ three items, which form the linked list.                          }
{                                                                   }
{ HEAPLIST.PAS  ->  .EXE       R Shaw           2.12.92             }
{___________________________________________________________________}

Uses  Crt, Dos, Graph, hex;

Type
   PItem = ^ TItem;
   TItem = record
     Name     : string[15];
     Price    : integer;
     NextItem : PItem;
   End;

Var
   InName                        : string[15];
   InPrice                       : integer;
   FirstItem, LastItem, ThisItem : PItem;
   i                             : integer;
   HeapOrgSeg,HeapOrgOfs         : word;
   HeapOrgSegX,HeapOrgOfsX       : string;
   HeapPtrSeg,HeapPtrOfs         : word;
   HeapPtrSegX,HeapPtrOfsX       : string;
   HeapOrg                       : ^integer;

Procedure InitPointers;
begin
   FirstItem := Nil;
   LastItem  := Nil;
end;

Procedure ListAdd(AddName: string; AddPrice: integer);
begin
   New(ThisItem);
   ThisItem^.Name := AddName;
   ThisItem^.Price := AddPrice;
   ThisItem^.NextItem := Nil;
   If LastItem <> Nil then LastItem^.NextItem := ThisItem;
   LastItem := ThisItem;
   If FirstItem = Nil then FirstItem := LastItem;
end;

Procedure ListDataIn;
begin
   Window(1,1,80,25);
   writeln('Please enter the name [15 characters maximum], followed by ENTER, then price');
   writeln('in pence [integer] followed by ENTER, when requested in table of 3 items below:');
   writeln;
   writeln('Item No.      Item name        Item Price');
   writeln;
   For i := 1 to 3 do
   begin
      GotoXY(4,5 + i);
      write(i);
      {$I-}
      Repeat
         GotoXY(15,5 + i);
         ClrEol;
         read(InName);
      until IOResult = 0;
      Repeat
         GotoXY(32,5 + i);
         ClrEol;
         readln(InPrice);
      until IOResult = 0;
      {$I+}
      ListAdd(InName,InPrice);
   end;
end;

Procedure HeapOrgCheck;
begin

   Mark(HeapOrg);
   HeapOrgSeg := seg(HeapOrg^);
   HeapOrgOfs := ofs(HeapOrg^);
   for i := HeapOrgOfs to (HeapOrgOfs + 1000) do Mem[HeapOrgSeg:i] := 0;
   dec2hex(HeapOrgSeg,HeapOrgSegX);
   dec2hex(HeapOrgOfs,HeapOrgOfsX);
end;

Procedure HeapPtrCheck;
begin
   HeapPtrSeg := seg(HeapPtr^);
   HeapPtrOfs := ofs(HeapPtr^);
   dec2hex(HeapPtrSeg,HeapPtrSegX);
   dec2hex(HeapPtrOfs,HeapPtrOfsX);
   writeln;
   Writeln('CHECK OF MEMORY FOR A SINGLE-LINKED LIST OF ITEMS.');
   Writeln;
   write('HeapOrg:    ',HeapOrgSegX,':',HeapOrgOfsX,'     ');
   writeln('HeapPtr:    ',HeapPtrSegX,':',HeapPtrOfsX);
   writeln;
end;

Procedure MemoryCheck;

Function DebugPath : Pathstr;

var
  DPath : PathStr;

begin
  DPath := '';
  DPath := FSearch('DEBUG.EXE', GetEnv('PATH'));
  If DPath = '' then DPath := FSearch('DEBUG.COM', GetEnv('PATH'));
  If DPath = '' then
     begin
        writeln('DEBUG file not found. Please check your DOS system.');
        writeln;
        writeln('Press any key to continue: ');
        repeat until keypressed;
     end;
  DebugPath := DPath;
end;      {of Function DebugPath}


begin
   writeln('Please wait for prompt (-) of DOS Debug, now being called by Exec procedure.');
   writeln('Then type D followed by a space and then the HeapOrg address (above) and ENTER.');
   writeln('Finally, after studying the contents of memory, type Q and press ENTER to quit.');
   writeln;
   SwapVectors;
   Exec(DebugPath,'');
   If DosError <> 0 then writeln('Dos error # ',DosError);
   SwapVectors;
end;


{Main}

begin
   ClrScr;
   InitPointers;
   HeapOrgCheck;
   ListDataIn;
   HeapPtrCheck;
   MemoryCheck;
   Release(HeapOrg);
end.

