	INCLUDE c.mac

;-------------------------- GetConnectionID --------------------------------
;
; Input:   char *serverName;	   Name of the server to find the number for
;	   WORD *serverNumber;	   Receives the server number
;
; Output:  0x00 --  SUCCESSFUL
;	   0xf8 --  NOT ATTACHED
;	   0xfc --  FILE SERVER UNKNOWN
;	   0xfe --  BINDERY LOCKED
;	   0xff --  NO SERVER RESPONSE
;
; Comments:
;   This routine returns the number of the given server if the station
;   has a connection to that server, or a 0 if not attached.
;___________________________________________________________________________

	DSeg
propertyName	db 'NET_ADDRESS', 0
	EndDS

	PExtern ReadPropertyValue
	DOSExterns

	PSeg

	__CompareBlocks proc near
;This procedure compares two 10 byte addresses.  The address's of the
;  two blocks to be compared are es: [si + bx + 2] and ss: bp - 128.  If the
;  address in es: [si + bx + 2] is greater a positive value will be returned
;  in al, if it is less a negative value will be returned, and if they are
;  equal a 0 will be returned in al.
	xor	ax, ax			;Result is returned in al
	xor	di, di			;Use di as counter from 0 to 10
	push	bx			;so bx can be restore after compare
	add	bx, 2			;Point to start of block
compare_loop:
	mov	al, es: [si + bx]	;Move byte from first block to register
	sub	al, [bp + di - 128]	;Subtract the byte from the second block
	jne	short found_answer
	inc	di			;move to next byte
	inc	bx
	cmp	di, 10
	jne	short compare_loop
found_answer:
	pop	bx			;Point bx back to the server slot that
					;  it was pointing at when this routine
					;  was called
	ret
__CompareBlocks ENDP

	ProcDef GetConnectionID,<<serverName, dptr>,<serverNumber, dptr>>
	sub	sp, 128 		;Save 128 byte data area
	PushSI
	PushDI
	PushES
;
;Set up parameters and call ReadPropertyValue to find the address of the
;  new server that is to be attached to
	xor	ax, ax
	IF	MODEL AND 1
	push	ax			;Push Nil for propertyFlags parameter
	push	ax
	push	ax			;Push Nil for moreSegments parameter
	push	ax
	push	ss			;Push address of 128 byte data parameter
	lea	bx, [bp - 128]
	push	bx
	inc	ax
	push	ax			;Push 1 for segment parameter
	push	ds
	mov	ax, offset dgroup:propertyName
	push	ax			;Push property name NET_ADDRESS
	mov	ax, 4
	push	ax			;Push 4 for objectType (4=file server)
	push	word ptr (serverName + 2)	;Push address of serverName
	push	word ptr (serverName)
	call	ReadPropertyValue
	add	sp, 24			;Remove parameters from stack
	ELSE
	push	ax			;Push Nil for propertyFlags parameter
	push	ax			;Push Nil for moreSegments parameter
	lea	bx, [bp - 128]
	push	bx			;Push address of 128 byte data parameter
	inc	ax
	push	ax			;Push 1 for segment parameter
	mov	ax, offset dgroup:propertyName
	push	ax			;Push property name NET_ADDRESS
	mov	ax, 4
	push	ax			;Push 4 for objectType (4 is file server)
	push	word ptr (serverName)	;Push address of serverName
	call	ReadPropertyValue
	add	sp, 14			;Remove parameters from stack
	ENDIF
	cmp	al, 0			;Check return value
	jz	short got_address
	cmp	al, 0feh
	jz	short bindry_locked
	mov	al, 0fch		;Return 0xfc when the server is unknown
bindry_locked:				;Return 0xfe when bindry is locked
	jmp	the_end
got_address:
;
;Get address of server table in es:si (call number 239)
	mov	ah, 239 		;Function call 239
	mov	al, 3			;Option 3 is get server table address
	EnterDOS
;
;Check to see if there is already a connection to the server
	xor	bx, bx
check_if_exists:
	cmp	byte ptr es: [si + bx], 0
	jz	no_match		;Skip slot if it is not being used
	call	__CompareBlocks 	;Continue searching if address did
					;  not match
	jne	short no_match
	mov	ax, bx			;Server was already attached, convert
	mov	cl, 5			;  the slot number to a server number
	shr	ax, cl
	inc	ax			;Convert to a 1-based server number
	PushDS
	LoadPtr di, serverNumber, ds
	mov	[di], ax		;Return server number in
					;  serverNumber parameter
	PopDS
	xor	ax, ax			;Return 0 the server number was found
	jmp	the_end
no_match:
	add	bx, 32			;Move to next server slot
	cmp	bx, 256
	jne	check_if_exists
;
;There is no connection to the server
	mov	ax, 0f8h		;Return 0xf8 there is no connection
the_end:
	PopES
	PopDI
	PopSI
	add	sp, 128 		;Restore 128 byte data area to stack
	RetVal	byte, reg, al
	Return
	ProcEnd GetConnectionID

	EndPS

	END

