/*      COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#include <stdio.h>
#include <string.h>
#include <sap.h>
#include <nwmisc.h>

int    LastSAPcc =                  0;
static SAP_BUFFER                 sap;
static BYTE AdvertiserHasSent = FALSE;

static WORD     serverType;
static char     serverName[48];
static WORD     serverSocket;
static BYTE     socketType;


int   AdvertiseService(sType, sName, sSocket)

WORD   sType;       /* Type of server (OT_JOB_SERVER - 5, OT_FILE_SERVER - 4) */
char  *sName;       /* Name of server (maximum 48 chars INCLUDING null        */
WORD   sSocket;     /* Server socket number.  If a zero is passed in as
                       sSocket then a socket will be dynamically assigned     */
{


    serverType = sType;
    strcpy(serverName, sName);
    serverSocket = sSocket;
    socketType = SHORT_LIVED;

    IPXInitialize();
    IPXOpenSocket(&serverSocket, socketType);
    InitializeSAP();

    return(0);

}



 /*-------------------------------------------------------------------------*/



void far Advertiser()
{


    _LoadDS();
    if(AdvertiserHasSent)
     {
        AdvertiserHasSent = FALSE;
        IPXScheduleSpecialEvent( ONE_MINUTE, &sap.theECB);
     }
    else
     {
        AdvertiserHasSent = TRUE;
        if ( !sap.theECB.inUseFlag)
         {
            LastSAPcc = sap.theECB.completionCode;
            IPXSendPacket(&sap.theECB);
         }
     }

}





 /*-------------------------------------------------------------------------*/





int  InitializeSAP()
{

   sap.packet.SAPPacketType = IntSwap(PERIODIC_ID_PACKET);
   sap.packet.serverType = IntSwap(serverType);
   strcpy(sap.packet.serverName, serverName);
   IPXGetInternetworkAddress(sap.packet.serverAddress.network);
   sap.packet.serverAddress.socket = IntSwap(serverSocket);
   sap.packet.interveningNetworks = IntSwap(1);

   sap.theECB.fragmentCount = 1;
   sap.theECB.fragmentDescriptor[0].address = &sap.packet;
   sap.theECB.fragmentDescriptor[0].size = sizeof(SAPHeader);
   sap.theECB.inUseFlag = 0;
   sap.theECB.socketNumber = IntSwap(SAP_SOCKET);
   sap.theECB.ESRAddress = (void (far *)()) Advertiser;
   memset(sap.theECB.immediateAddress, '\xFF', 6);

   sap.packet.packetType = 0;
   memset(sap.packet.destination.network, '\x00', 4);
   memset(sap.packet.destination.node, '\xFF', 6);
   sap.packet.destination.socket = IntSwap(SAP_SOCKET);

   IPXSendPacket (&sap.theECB);

   return(0);

}




 /*-------------------------------------------------------------------------*/


int ShutdownSAP()
{


    IPXCancelEvent(&sap.theECB);
    while (sap.theECB.inUseFlag)
         /* Wait until ECB is NOT in use */  ;

    if (sap.theECB.completionCode != IPX_EVENT_CANCELED)
        return(FAILURE);

    sap.theECB.ESRAddress = (char far *)0;
    sap.packet.interveningNetworks = IntSwap(0x10);

    IPXSendPacket(&sap.theECB);

    while (sap.theECB.inUseFlag)
         /* Wait until ECB is NOT in use */  ;

    return(SUCCESSFUL);

}
