/*      COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#include <nitq.h>
#include <nwlocal.h>
#include <nwmisc.h>
#include <ndt.h>

/*_____________________ServiceQueueJobAndOpenFile____________________________
|
|  Output:    0                   --  SUCCESSFUL
|             network error code  --  UNSUCCESSFUL
|
|  Comments:    This function allows a queue server to select a new job for
|               servicing.  It may be made only by a station that has
|               previously attached itself to the specified queue as a server.
|____________________________________________________________________________*/


int ServiceQueueJobAndOpenFile( queueID, targetJobType, job, fileHandle )

long queueID;            /* Object ID of the queue                          */
WORD targetJobType;      /* Job type that has to be matched                 */
JobStruct *job;          /* Receives the job record of the next available
                            job returned by the queue management software   */
int *fileHandle;         /* The file handle of the job file to be opened    */
{
    BYTE sendPacket[9], receivePacket[56];
    int ccode;

    *((WORD *)sendPacket) = 7;
    sendPacket[2] = 113;
    *((WORD *)receivePacket) = 54;
    *((long *)(sendPacket + 3)) = LongSwap(queueID);
    *((WORD *)(sendPacket + 7)) = IntSwap(targetJobType);
    ccode = _ShellRequest((BYTE)227, sendPacket, receivePacket);
    if (ccode == 0)
     {
        ccode = ReadQueueJobEntry(queueID, IntSwap(*((WORD *)(receivePacket + 24)) ), job);
        if ( (!ccode) && (fileHandle) )
         {
            *fileHandle = DOSOpen( "NETQ", (BYTE)(IF_INHERITED |
                                    SM_DENY_NONE | AM_READ) );
            if ( *fileHandle == -1 )
                ccode = DOSError;
         }
     }
    return(ccode);
}
