;	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.
NAME	ENABLEPD
	INCLUDE c.mac
;******************************************************************************
;*  $Header:   H:/library/nit/vcs/enablepd.avm	 1.5   04 Oct 1988 16:12:54   DAVE  $
;*
;*	Program Name:	Novell 'C' Library
;*
;*	Filename:	enablepd.asm
;*
;*	Date:		9/19/85
;*
;*	Version:	1.00
;*
;*	Modifications:	7/10/86 - Added support for autoEndSpool flag
;*  $Log:   H:/library/nit/vcs/enablepd.avm  $
;
;     Rev 1.5	04 Oct 1988 16:12:54   DAVE
;  The following changes have been made to all .ASM files in the NIT library:
;
;  1) The PVCS macros $Header$ and $Log$ have been added to the headers.
;*
;*	Comments:	This routine supports the get printer default call
;*			which is implemented in NetWare shells version 2.0 or
;*			greater.
;*
;*	COPYRIGHT (c) 1985, 1988 by Novell, Inc.  All Rights Reserved
;*
;******************************************************************************/

;
; EnablePrinterDefaults
;
; SYNOPSIS
;
;	ccode = EnablePrinterDefaults();
;
;	int ccode;			If wrong shell version, nonzero return.
;
; DESCRIPTION
;
;	This function enables the shell's printer default table.  When this
;	capability is enabled, the default printer parameters are sent
;	to the File server any time a ModifyLPTDevice call is made.
;
	DOSExterns

	PSeg

	ProcDef EnablePrinterDefaults
	sub	sp, 1			;Allocate 1 byte
	mov	bx, sp
	IF	Model AND 1
	mov	ax, ss
	mov	es, ax
	ENDIF
	mov	ax, 0B800h		;Specify Get Printer Defaults
	mov	cx, 1			;# of bytes to get
	EnterDOS
	or	ax, ax
	jnz	EPDError
	mov	byte ptr [bx], 0	;Enable printer defaults
	;
	; Send the altered table back to the shell
	;
	mov	ax, 0B801h
	mov	cx, 1
	EnterDOS

EPDError:

	;
	; All Done!!
	;
	RetVal	word, reg, ax
	add	sp, 1
	Return
	ProcEnd EnablePrinterDefaults

	EndPS

	END

