/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
/*========================================================================
  ==    $Header:   H:/library/nit/vcs/delque2.cvv   1.5   04 Oct 1988 16:02:26   DAVE  $
  ==
  ==    Program Name:   Novell 'C' Library
  ==
  ==    Filename:       delque2.c
  ==
  ==    Date:           4/17/85
  ==
  ==    Version:        1.00
  ==
  ==    Modifications:  6/8/88 changes to avoid warnings with TurboC 1.5
  ==    $Log:   H:/library/nit/vcs/delque2.cvv  $
 * 
 *    Rev 1.5   04 Oct 1988 16:02:26   DAVE
 * The following changes have been made to all .C files in the NIT library:
 * 
 * 1) Headers have been standardized.
 * 2) The PVCS macros $Header$ and $Log$ have been added to the headers.
 * 3) The include files have been changed to reflect the split out of NIT.
  ==
  ==    Comments:       
  ==
  ==    COPYRIGHT (c) 1985, 1988 by Novell, Inc.  All Rights Reserved
  ==
  ========================================================================*/

#include <string.h>
#include "nwlocal.h"
#include "nwprint.h"

/**** DeletePrintQueueEntries -- removes multiple jobs from a print queue
* Input:    int printerNumber;      The number of the printer that
*                                   should have the job removed from
*                                   its queue.
*           int numberOfJobs;       The number of jobs to be deleted.
*           BYTE *jobNumberArray;   A pointer to a character array of
*                                   numberOfJobs byte entries of the
*                                   job numbers to be deleted.
*
* Output:   Returns a 0 if successful or a network error code if unsuccessful.
*
* Comments:
*   This routine deletes multiple entries from a print queue.  The job numbers
*   of the entries to be deleted should be obtained by calling
*   GetPrintQueueEntry.
****/

int DeletePrintQueueEntries(printerNumber, numberOfJobs, jobNumberArray)
int printerNumber, numberOfJobs;
BYTE *jobNumberArray;
{
char    sendPacket[103];
char    receivePacket[2];
    
    sendPacket[2] = 5;
    sendPacket[3] = (char)((BYTE)printerNumber);
    memmove(sendPacket + 4, jobNumberArray, numberOfJobs);
    *((int *)sendPacket) = 2 + numberOfJobs;
    
    *((int *)receivePacket) = 0;
    
    return (_ShellRequest((BYTE)224, (BYTE *)sendPacket, (BYTE *)receivePacket));
}

/****************************************************************************/
/****************************************************************************/

