/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nit.h>
#include <niterror.h>
#ifndef LC310
 #include <conio.h>
#endif

#define upcase(chr) ((((chr)>='a')&&((chr)<='z'))?(chr)-'a'+'A':(chr))

extern char pathVariableName[];

static void   AddDriveToVector(char, int, char *, char *);
static void   DeleteDriveFromVector(int, char *);

static void   DeleteDriveFromVector(searchOrder, pathVariable)

int	searchOrder;
char   *pathVariable;

{
char   *separator;
char   *variablePtr;

    if (searchOrder == 0)
	goto DONE;
    variablePtr = _FindPathVariableElement( pathVariable, searchOrder );
    if ( variablePtr != (char *)NULL )
     {
	separator = strchr( variablePtr, ';' );
	if ( separator == (char *)NULL )
	 {
	    if ( variablePtr == pathVariable )
		*variablePtr = '\0';
	    else
		*(variablePtr - 1) = '\0';
	 }
	else
	 {
	    strcpy( variablePtr, separator + 1 );
	 }
     }
DONE:
    AllignDriveVectorToPath( pathVariable );
}


static void AddDriveToVector(driveLetter, searchOrder, pathVariable,
			     additionalPath )
char	driveLetter;
int	searchOrder;
char   *pathVariable;
char   *additionalPath;

{
int	len;
char   *tempPtr;
char   *tempPtr2;
char   *variablePtr;


    /*-- get path variable for modification --*/
    variablePtr = _FindPathVariableElement( pathVariable, searchOrder );

    /*-- add in path --*/
    if ( variablePtr != (char *)NULL )
     {
	/*-- create buffer to store path under construction --*/
	len = ((additionalPath != (char *)NULL) && (*additionalPath != 0)) ?
		strlen( additionalPath ) : 1;
	len += strlen( pathVariable ) + 3;
	tempPtr = (char *) calloc( 1, len );

	/*-- copy text before insert point --*/
	len = (int)(variablePtr - pathVariable);
	memmove( tempPtr, pathVariable, len );
	tempPtr2 = tempPtr + len;
	/*-- if insert point is at end, add a separator --*/
	if ( *variablePtr == '\0' )
	 {
	    *(tempPtr2++) = ';';
	 }

	/*-- add text to insert --*/
	*(tempPtr2++) = upcase( driveLetter );
	*(tempPtr2++) = ':';
	if ( (additionalPath) && (*additionalPath != '\0') )
	    tempPtr2 = additionalPath;
	else
	    tempPtr2 = ".";

	if ( *variablePtr != '\0' )
	 {
	    strcat( tempPtr2, ";" );
	    strcat( tempPtr2, variablePtr );
	 }
	strcpy( pathVariable, tempPtr );
	free( tempPtr );
     }
    else
     {
	 tempPtr = strchr(pathVariable,'\0');
	 tempPtr2 = tempPtr;
	 if (*(tempPtr-1) != ';')
	  {
	      *tempPtr = ';';
	       tempPtr++;
	  }
	 *tempPtr = driveLetter;
	 tempPtr++;
	 *tempPtr = ':';
	 tempPtr++;
	if ( (additionalPath) && (*additionalPath != '\0') )
	    strcpy(tempPtr, additionalPath);
	else
	    strcpy(tempPtr, ".");

     }

    /*-- update search drive vector --*/
    AllignDriveVectorToPath( pathVariable );
}



int MapDrive(connectionID, directoryHandle, directoryPath, searchFlag,
	     searchOrder, driveLetter )

WORD	connectionID;
BYTE	directoryHandle;
char   *directoryPath;
BYTE	searchFlag;
int	searchOrder;
char   *driveLetter;

{
    return( _MapDrive( connectionID, directoryHandle, directoryPath,
		      searchFlag, searchOrder, driveLetter, NULL,
					  NULL, NULL));
}

int _MapDrive(connectionID, directoryHandle, directoryPath, searchFlag,
	      searchOrder, driveLetter, DeleteVerify, OverwriteVerify,
	      varArgPtr )

WORD	connectionID;
BYTE	directoryHandle;
char   *directoryPath;
BYTE	searchFlag;
int	searchOrder;
char	*driveLetter;
int   (*DeleteVerify)();
int   (*OverwriteVerify)();
va_list varArgPtr;

{
int	    ccode		= 0;	/*-- default is no error --*/
BYTE	    driveStatus;
char	    lastLocalDriveLetter;
WORD	    oldConnectionID;
WORD	    pathConnectionID;
BYTE	    pathDirectoryHandle;
char	   *pathVariable;
char	    fileServer[49];
char	    restorePath[320];
char	    response;
int	    nextAvailableSearchOrder;
int	    search;


    ccode = GetPathEnvironmentVariable( &pathVariable );  /*-- get the path --*/
    if (ccode != 0)
	goto ERROR001;
    lastLocalDriveLetter = (char) (GetNumberOfLocalDrives() + 'A' - 1);
    nextAvailableSearchOrder = GetMaxSearchOrder(pathVariable)+1;
    if (searchOrder > nextAvailableSearchOrder)    /*-- take care of cases  --*/
	searchOrder = nextAvailableSearchOrder;    /*-- where S# is greater --*/
												/* than the last assigned # */
    if (searchOrder > (nextAvailableSearchOrder - 1))
     {										     /* if S# is > than last assigned # */
	 if (searchFlag == DRIVE_INSERT)	 /*-- it is not an insert,  --*/
	     searchFlag = DRIVE_ADD;		 /*-- it is an add	    --*/
	 if (searchFlag == DRIVE_DELETE)	 /*-- if they are deleting  --*/
	  {
	     ccode = NO_SUCH_SEARCH_DRIVE;
	     goto ERROR00;
	  }
     }

     /*-- allign drive letter and search order --*/

    if ( searchOrder == 0 )		   /*-- if no search order, get it --*/
     {
	 search=0;
	 response = GetDefaultDrive() + 'A';
	 if ((response != *driveLetter) && (*driveLetter > lastLocalDriveLetter))
	      searchOrder =
		    GetSearchOrderFromDriveLetter( pathVariable, *driveLetter );
     }
    else			      /*-- if search order, get driveLetter --*/
     {
	 search=1;
	 if (*driveLetter == '\0')        /*-- if no drive letter specified --*/
	 if ( directoryPath[1] == ':' )   /*-- check for a local drive --*/
	  {
	    *driveLetter = upcase(directoryPath[0]);
	  }
	 else				    /*-- otherwise it is default or --*/
	  {				    /*-- network --*/
	     StripFileServerFromPath(directoryPath,fileServer);
	     if (*fileServer == '\0')       /*-- if default drive --*/
		 *driveLetter = GetDefaultDrive() + 'A';
	     else			    /*-- if it is a network --*/
	      {
		 *driveLetter = GetDriveLetterFromSearchOrder(pathVariable,searchOrder);
		  if ( (searchOrder > (nextAvailableSearchOrder-1)) ||
				       (searchFlag == DRIVE_INSERT) ||
				      (lastLocalDriveLetter >= *driveLetter) )
		   {
		       for ( *driveLetter = 'Z';
			     *driveLetter > lastLocalDriveLetter;
			     (*driveLetter)-- )
			{
			     driveStatus =
			       GetDriveInformation( (BYTE)(*driveLetter - 'A'),
				       &pathConnectionID, &pathDirectoryHandle);
			       if ( driveStatus == 0x00 )
				    break;
			}
		       if ( *driveLetter <= lastLocalDriveLetter )
			{
			     ccode = NO_DRIVE_AVAILABLE;
			     goto ERROR00;
			}
		   }
	      }
	  }
     }

    if ( searchFlag == DRIVE_DELETE )		/*-- if DELETING --*/
     {

	 /*--  GET DRIVE LETTER FROM SEARCH ORDER --*/
	 if ( searchOrder != 0 )	   /*-- if there's a search order --*/
	     *driveLetter = GetDriveLetterFromSearchOrder( pathVariable,
							   searchOrder );

	 /*--  VERIFY OK TO DELETE SEARCH --*/
	 if ( (search == 0) && (searchOrder != 0) && (DeleteVerify) )
	 /*-- if no search drive specified but it is in search vector
	      and function is provided --*/

	    if ((ccode = (*DeleteVerify)( *driveLetter, varArgPtr )) != 0 )
		 goto ERROR00;

	 /*--  DEALLOCATE A DIRECTORY HANDLE --*/
	 driveStatus = GetDriveInformation( (BYTE)(*driveLetter - 'A'),
					    &connectionID,
					    &pathDirectoryHandle );

	 oldConnectionID = GetPreferredConnectionID();
	 SetPreferredConnectionID( connectionID );

	 if(((driveStatus==0x80) && (searchOrder == 0)) ||(driveStatus == 0x00))
	  {
	      /*-- if local drive & no search order, OR drive not mapped --*/
	       ccode = DRIVE_IS_NOT_MAPPED;
	       goto ERROR00;
	  }
	if ( driveStatus != 0x80 )   /*-- if drive not a local drive  --*/
	 {			     /*-- deallocate directory handle --*/
	     ccode = DeallocateDirectoryHandle( pathDirectoryHandle );
	     if ( ccode != 0 )
		  goto ERROR00;
	 }

	/*-- UPDATE THE SEARCH DRIVE VECTOR --*/
	DeleteDriveFromVector( searchOrder, pathVariable );

	/*-- ASSIGN NEXT DRIVE LETTER --*/
     }
    else	    /*-- if we are ADDING or INSERTING --*/
     {
	/*-- SAVE DIRECTORY PATH --*/
	driveStatus = GetDriveInformation( (BYTE)(*driveLetter - 'A'),
				 &pathConnectionID, &pathDirectoryHandle );
	if ( !(driveStatus & 0x03) )	 /*-- if a local drive --*/
	 {
	     *restorePath = '\0';        /*-- there's no restore path --*/
	      if ((directoryPath[1] == ':') &&
		 (*directoryPath <= lastLocalDriveLetter) && (searchOrder == 0))

		 /*-- if being mapped to a local drive
		      but not to a search order --*/
		 {				      /*-- it's an error --*/
		     ccode = CANT_MAP_LOCAL_DRIVE;
		     goto ERROR00;
		 }
		if ( ( searchFlag == DRIVE_ADD ) && (searchOrder == 0) &&
		      (driveStatus & 0x80) && OverwriteVerify )

		 /*-- if adding --*/
		 {								 /* check for overwrite */
		     ccode = (*OverwriteVerify)( *driveLetter, varArgPtr );
		     if ( ccode != 0 )
			  goto ERROR00;
		     searchOrder = GetSearchOrderFromDriveLetter(pathVariable,
								*driveLetter);
		     if (searchOrder)
		      {
			 while(searchOrder)
			  {
			      DeleteDriveFromVector( searchOrder, pathVariable );
			      searchOrder =
				    GetSearchOrderFromDriveLetter(pathVariable,
								 *driveLetter);
			   }
		      }
		 }
	 }
	else		 /*-- if it is a network --*/
	 {
	    if ( ( searchFlag == DRIVE_ADD ) &&
		  (IsSearchDrive( *driveLetter )) && OverwriteVerify )

	     /*-- if adding and if a search drive and if overwrite --*/
	     {
		 ccode = (*OverwriteVerify)( *driveLetter, varArgPtr );
		 if ( ccode != 0 )
		      goto ERROR00;
	     }
	    GetFileServerName( pathConnectionID, restorePath );
	    strcat( restorePath, "/" );
	    GetDirectoryPath( pathDirectoryHandle,
			      restorePath + strlen( restorePath ) );
	 }

	 /*-- ALLOCATE A DIRECTORY HANDLE --*/
	 StripFileServerFromPath(directoryPath,fileServer);
	 if (*fileServer == '\0')        /*-- if a local drive --*/
	  {
	     if (directoryPath[1] == ':')
	      {
		 if (*directoryPath <= lastLocalDriveLetter)
		    if (*driveLetter > lastLocalDriveLetter)
		     {
			 ccode = CANT_MAP_LOCAL_DRIVE;
			 goto ERROR00;
		     }
	      }
	     driveStatus = GetDriveInformation((BYTE)(*driveLetter - 'A'),
					       (WORD *)NULL, (BYTE *)NULL);
	     if ( driveStatus == 0x80 )
		 if ( searchOrder == 0 )
		  {
		      ccode = CANT_MAP_LOCAL_DRIVE;
		      goto ERROR00;
		  }
	  }
	 else
	  {
	     ccode = SetDrivePath( (BYTE)(*driveLetter - 'A'), directoryHandle,
					   directoryPath, (BYTE)TRUE );
	     if ( ccode != 0 )
		 goto ERROR00;
	  }

	 /*-- UPDATE THE SEARCH DRIVE VECTOR --*/
	 if ( ( searchOrder > 0 ) && ( searchFlag != DRIVE_INSERT ) )
	  {
	       DeleteDriveFromVector( searchOrder, pathVariable );
	  }
	 if ( searchOrder > 0 )
	  {
	     if (driveStatus == 0x80)
		*driveLetter = *directoryPath;
	     AddDriveToVector( *driveLetter, searchOrder,
				pathVariable, ( driveStatus == 0x80 ) ?
				directoryPath + 2 : (char *)NULL );
	  }
     }

    /*-- UPDATE THE DOS PATH VARIABLE --*/
    PutEnvironmentVariable( pathVariableName, pathVariable );


ERROR00:
    SetPreferredConnectionID( oldConnectionID );
    free( pathVariable );
ERROR001:
    return( ccode );
}
